/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource;

import java.security.AccessController;
import java.security.SecureRandom;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import jdk.management.resource.ResourceContext;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.ResourceNatives;
import jdk.management.resource.internal.SimpleResourceContext;
import jdk.management.resource.internal.TotalResourceContext;
import jdk.management.resource.internal.UnassignedContext;
import jdk.management.resource.internal.WrapInstrumentation;

public final class ResourceContextFactory {
    private static final ResourceContextFactory instance = new ResourceContextFactory();
    private final ResourceContext unassigned = ResourceNatives.isEnabled() ? UnassignedContext.getUnassignedContext() : null;
    private volatile boolean initialized = false;

    private ResourceContextFactory() {
    }

    public static ResourceContextFactory getInstance() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("jdk.management.resource.getResourceContextFactory"));
        }
        if (!ResourceNatives.isEnabled()) {
            throw new UnsupportedOperationException("Resource management is not enabled");
        }
        instance.initInstrumentation();
        return instance;
    }

    private synchronized void initInstrumentation() throws InternalError {
        if (!this.initialized) {
            ThreadLocalRandom.current();
            new SecureRandom();
            try {
                Class<?> clazz = Class.forName("jdk.management.resource.internal.inst.InitInstrumentation");
                Runnable runnable = (Runnable)clazz.newInstance();
                runnable.run();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new InternalError("Resource management instrumentation failed", reflectiveOperationException);
            }
            if (!new WrapInstrumentation().wrapComplete()) {
                throw new InternalError("Resource management instrumentation failed");
            }
            this.initPreBoundThreads();
            this.initialized = true;
        }
    }

    private void initPreBoundThreads() {
        AccessController.doPrivileged(() -> {
            ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
            while (threadGroup.getParent() != null) {
                threadGroup = threadGroup.getParent();
            }
            Thread[] threadArray = new Thread[threadGroup.activeCount() * 2];
            int n = threadGroup.enumerate(threadArray, true);
            for (int i = 0; i < n; ++i) {
                if (threadArray[i] == null) continue;
                UnassignedContext unassignedContext = threadArray[i].getThreadGroup().equals(threadGroup) ? UnassignedContext.getSystemContext() : UnassignedContext.getUnassignedContext();
                unassignedContext.bindThreadContext(threadArray[i]);
            }
            return null;
        });
    }

    public ResourceContext create(String string) {
        return SimpleResourceContext.create(string);
    }

    public ResourceContext lookup(String string) {
        return SimpleResourceContext.get(string);
    }

    public ResourceContext getThreadContext() {
        return this.getThreadContext(Thread.currentThread());
    }

    public ResourceContext getThreadContext(Thread thread) {
        return SimpleResourceContext.getThreadContext(thread);
    }

    public ResourceRequest getResourceRequest(ResourceType resourceType) {
        return this.getThreadContext().getResourceRequest(resourceType);
    }

    public ResourceContext getUnassignedContext() {
        return this.unassigned;
    }

    public ResourceContext getTotalsContext() {
        return TotalResourceContext.getTotalContext();
    }

    public Stream<ResourceContext> contexts() {
        return SimpleResourceContext.contexts();
    }
}

