/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.MemberName;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.Unsafe;

class MethodHandleStatics {
    static final Unsafe UNSAFE = Unsafe.getUnsafe();
    static final boolean DEBUG_METHOD_HANDLE_NAMES;
    static final boolean DUMP_CLASS_FILES;
    static final boolean TRACE_INTERPRETER;
    static final boolean TRACE_METHOD_LINKAGE;
    static final int COMPILE_THRESHOLD;
    static final int DONT_INLINE_THRESHOLD;
    static final int PROFILE_LEVEL;

    private MethodHandleStatics() {
    }

    static boolean debugEnabled() {
        return DEBUG_METHOD_HANDLE_NAMES | DUMP_CLASS_FILES | TRACE_INTERPRETER | TRACE_METHOD_LINKAGE;
    }

    static String getNameString(MethodHandle methodHandle, MethodType methodType) {
        if (methodType == null) {
            methodType = methodHandle.type();
        }
        MemberName memberName = null;
        if (methodHandle != null) {
            memberName = methodHandle.internalMemberName();
        }
        if (memberName == null) {
            return "invoke" + methodType;
        }
        return memberName.getName() + methodType;
    }

    static String getNameString(MethodHandle methodHandle, MethodHandle methodHandle2) {
        return MethodHandleStatics.getNameString(methodHandle, methodHandle2 == null ? (MethodType)null : methodHandle2.type());
    }

    static String getNameString(MethodHandle methodHandle) {
        return MethodHandleStatics.getNameString(methodHandle, (MethodType)null);
    }

    static String addTypeString(Object object, MethodHandle methodHandle) {
        String string = String.valueOf(object);
        if (methodHandle == null) {
            return string;
        }
        int n = string.indexOf(40);
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return string + methodHandle.type();
    }

    static InternalError newInternalError(String string) {
        return new InternalError(string);
    }

    static InternalError newInternalError(String string, Throwable throwable) {
        return new InternalError(string, throwable);
    }

    static InternalError newInternalError(Throwable throwable) {
        return new InternalError(throwable);
    }

    static RuntimeException newIllegalStateException(String string) {
        return new IllegalStateException(string);
    }

    static RuntimeException newIllegalStateException(String string, Object object) {
        return new IllegalStateException(MethodHandleStatics.message(string, object));
    }

    static RuntimeException newIllegalArgumentException(String string) {
        return new IllegalArgumentException(string);
    }

    static RuntimeException newIllegalArgumentException(String string, Object object) {
        return new IllegalArgumentException(MethodHandleStatics.message(string, object));
    }

    static RuntimeException newIllegalArgumentException(String string, Object object, Object object2) {
        return new IllegalArgumentException(MethodHandleStatics.message(string, object, object2));
    }

    static Error uncaughtException(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw MethodHandleStatics.newInternalError("uncaught exception", throwable);
    }

    static Error NYI() {
        throw new AssertionError((Object)"NYI");
    }

    private static String message(String string, Object object) {
        if (object != null) {
            string = string + ": " + object;
        }
        return string;
    }

    private static String message(String string, Object object, Object object2) {
        if (object != null || object2 != null) {
            string = string + ": " + object + ", " + object2;
        }
        return string;
    }

    static {
        final Object[] objectArray = new Object[7];
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                objectArray[0] = Boolean.getBoolean("java.lang.invoke.MethodHandle.DEBUG_NAMES");
                objectArray[1] = Boolean.getBoolean("java.lang.invoke.MethodHandle.DUMP_CLASS_FILES");
                objectArray[2] = Boolean.getBoolean("java.lang.invoke.MethodHandle.TRACE_INTERPRETER");
                objectArray[3] = Boolean.getBoolean("java.lang.invoke.MethodHandle.TRACE_METHOD_LINKAGE");
                objectArray[4] = Integer.getInteger("java.lang.invoke.MethodHandle.COMPILE_THRESHOLD", 0);
                objectArray[5] = Integer.getInteger("java.lang.invoke.MethodHandle.DONT_INLINE_THRESHOLD", 30);
                objectArray[6] = Integer.getInteger("java.lang.invoke.MethodHandle.PROFILE_LEVEL", 0);
                return null;
            }
        });
        DEBUG_METHOD_HANDLE_NAMES = (Boolean)objectArray[0];
        DUMP_CLASS_FILES = (Boolean)objectArray[1];
        TRACE_INTERPRETER = (Boolean)objectArray[2];
        TRACE_METHOD_LINKAGE = (Boolean)objectArray[3];
        COMPILE_THRESHOLD = (Integer)objectArray[4];
        DONT_INLINE_THRESHOLD = (Integer)objectArray[5];
        PROFILE_LEVEL = (Integer)objectArray[6];
    }
}

