/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.services.flr.internal;

import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.rjmx.services.flr.IOptionConstraint;
import com.jrockit.mc.rjmx.services.flr.internal.BasicPrimitivesConverter;
import com.jrockit.mc.rjmx.services.flr.internal.BooleanConverter;
import com.jrockit.mc.rjmx.services.flr.internal.ContentMashup;
import com.jrockit.mc.rjmx.services.flr.internal.ConversionException;
import com.jrockit.mc.rjmx.services.flr.internal.Converter;
import com.jrockit.mc.rjmx.services.flr.internal.DateConverter;
import com.jrockit.mc.rjmx.services.flr.internal.DurationConverter;
import com.jrockit.mc.rjmx.services.flr.internal.StringConverter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public final class ConversionToolkit {
    private static final Map<Serializable, Converter<?>> convertersByContent = new HashMap();
    private static final Map<Class<?>, Converter<?>> convertersByType = new HashMap();

    static {
        ConversionToolkit.addConverter(ContentMashup.DATE, new DateConverter());
        ConversionToolkit.addConverter(ContentMashup.BYTES, new BasicPrimitivesConverter.LongConverter());
        ConversionToolkit.addConverter(ContentMashup.NANOSECONDS, new DurationConverter(true));
        ConversionToolkit.addConverter(ContentMashup.BOOLEAN, new BooleanConverter());
        ConversionToolkit.addConverter(ContentMashup.FILE_NAME, new StringConverter());
        ConversionToolkit.addConverter(ContentMashup.MILLISECONDS, new DurationConverter(false));
        ConversionToolkit.addConverter(ContentMashup.MILLIS_PERIODICITY, new DurationConverter.PeriodicityConverter());
    }

    private static Converter<?> getConverter(String contentType) {
        return convertersByContent.get(contentType);
    }

    public static <T extends Comparable<T>> Converter<T> getConverter(Class<T> type) {
        Converter<Object> converter = convertersByType.get(type);
        if (converter == null) {
            converter = BasicPrimitivesConverter.getConverter(type);
        }
        return converter;
    }

    public static final <T extends Comparable<T>> void addConverter(ContentMashup<T> contentType, Converter<T> converter) {
        convertersByContent.put((Serializable)((Object)contentType.key), converter);
    }

    public static final <T extends Comparable<T>> void addConverter(Class<T> type, Converter<T> converter) {
        convertersByType.put(type, converter);
    }

    public static <T extends Comparable<T>> Converter<T> getConverter(IOptionConstraint<T> optionConstraint) {
        Converter<Object> c = ConversionToolkit.getConverter(optionConstraint.getContentType());
        if (c == null) {
            c = ConversionToolkit.getConverter(optionConstraint.getType());
        }
        return c;
    }

    public static <T extends Comparable<T>> void validateRange(IOptionConstraint<T> optionConstraint, T value) throws QuantityConversionException {
        T min = optionConstraint.getMin();
        if (min != null && min.compareTo(value) > 0) {
            Converter<T> conv = ConversionToolkit.getConverter(optionConstraint);
            String badStr = conv.toConfigString(value);
            throw ConversionException.tooLow(badStr, conv, min);
        }
        T max = optionConstraint.getMax();
        if (max != null && max.compareTo(value) < 0) {
            Converter<T> conv = ConversionToolkit.getConverter(optionConstraint);
            String badStr = conv.toConfigString(value);
            throw ConversionException.tooHigh(badStr, conv, max);
        }
    }

    public static <T extends Comparable<T>> String toConfigString(IOptionConstraint<T> optionConstraint, T serverValue) {
        return ConversionToolkit.getConverter(optionConstraint).toConfigString(serverValue);
    }

    public static <T extends Comparable<T>> String toHuman(IOptionConstraint<T> optionConstraint, T serverValue) {
        return ConversionToolkit.getConverter(optionConstraint).toHuman(serverValue);
    }

    public static <T extends Comparable<T>> T toServerValue(IOptionConstraint<T> optionConstraint, String configurationValue) throws QuantityConversionException {
        T value = ConversionToolkit.getConverter(optionConstraint).toServerValue(configurationValue);
        ConversionToolkit.validateRange(optionConstraint, value);
        return value;
    }

    public static <T extends Comparable<T>> T fromHuman(IOptionConstraint<T> optionConstraint, String humanString) throws QuantityConversionException {
        T value = ConversionToolkit.getConverter(optionConstraint).fromHuman(humanString);
        ConversionToolkit.validateRange(optionConstraint, value);
        return value;
    }
}

