/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.impl.encoding;

import com.sun.corba.se.impl.corba.TypeCodeImpl;
import com.sun.corba.se.impl.encoding.BufferManagerWrite;
import com.sun.corba.se.impl.encoding.ByteBufferWithInfo;
import com.sun.corba.se.impl.encoding.CDRInputObject;
import com.sun.corba.se.impl.encoding.CDRInputStream;
import com.sun.corba.se.impl.encoding.CDROutputStreamBase;
import com.sun.corba.se.impl.encoding.CodeSetConversion;
import com.sun.corba.se.impl.logging.ORBUtilSystemException;
import com.sun.corba.se.impl.orbutil.CacheTable;
import com.sun.corba.se.impl.orbutil.ORBUtility;
import com.sun.corba.se.impl.orbutil.RepositoryIdFactory;
import com.sun.corba.se.impl.orbutil.RepositoryIdStrings;
import com.sun.corba.se.impl.orbutil.RepositoryIdUtility;
import com.sun.corba.se.impl.util.Utility;
import com.sun.corba.se.pept.protocol.MessageMediator;
import com.sun.corba.se.spi.ior.IOR;
import com.sun.corba.se.spi.ior.IORFactories;
import com.sun.corba.se.spi.ior.iiop.GIOPVersion;
import com.sun.corba.se.spi.orb.ORB;
import com.sun.corba.se.spi.orb.ORBVersionFactory;
import com.sun.org.omg.CORBA.portable.ValueHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import javax.rmi.CORBA.ValueHandlerMultiFormat;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.CustomMarshal;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.BoxedValueHelper;
import org.omg.CORBA.portable.CustomValue;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.StreamableValue;
import org.omg.CORBA.portable.ValueBase;

public class CDROutputStream_1_0
extends CDROutputStreamBase {
    private static final int INDIRECTION_TAG = -1;
    protected boolean littleEndian;
    protected BufferManagerWrite bufferManagerWrite;
    ByteBufferWithInfo bbwi;
    protected ORB orb;
    protected ORBUtilSystemException wrapper;
    protected boolean debug = false;
    protected int blockSizeIndex = -1;
    protected int blockSizePosition = 0;
    protected byte streamFormatVersion;
    private static final int DEFAULT_BUFFER_SIZE = 1024;
    private static final String kWriteMethod = "write";
    private CacheTable codebaseCache = null;
    private CacheTable valueCache = null;
    private CacheTable repositoryIdCache = null;
    private int end_flag = 0;
    private int chunkedValueNestingLevel = 0;
    private boolean mustChunk = false;
    protected boolean inBlock = false;
    private int end_flag_position = 0;
    private int end_flag_index = 0;
    private ValueHandler valueHandler = null;
    private RepositoryIdUtility repIdUtil;
    private RepositoryIdStrings repIdStrs;
    private CodeSetConversion.CTBConverter charConverter;
    private CodeSetConversion.CTBConverter wcharConverter;
    private static final String _id = "IDL:omg.org/CORBA/DataOutputStream:1.0";
    private static final String[] _ids = new String[]{"IDL:omg.org/CORBA/DataOutputStream:1.0"};

    @Override
    public void init(org.omg.CORBA.ORB oRB, boolean bl, BufferManagerWrite bufferManagerWrite, byte by, boolean bl2) {
        this.orb = (ORB)oRB;
        this.wrapper = ORBUtilSystemException.get(this.orb, "rpc.encoding");
        this.debug = this.orb.transportDebugFlag;
        this.littleEndian = bl;
        this.bufferManagerWrite = bufferManagerWrite;
        this.bbwi = new ByteBufferWithInfo(oRB, bufferManagerWrite, bl2);
        this.streamFormatVersion = by;
        this.createRepositoryIdHandlers();
    }

    public void init(org.omg.CORBA.ORB oRB, boolean bl, BufferManagerWrite bufferManagerWrite, byte by) {
        this.init(oRB, bl, bufferManagerWrite, by, true);
    }

    private final void createRepositoryIdHandlers() {
        this.repIdUtil = RepositoryIdFactory.getRepIdUtility();
        this.repIdStrs = RepositoryIdFactory.getRepIdStringsFactory();
    }

    @Override
    public BufferManagerWrite getBufferManager() {
        return this.bufferManagerWrite;
    }

    @Override
    public byte[] toByteArray() {
        byte[] byArray = new byte[this.bbwi.position()];
        for (int i = 0; i < this.bbwi.position(); ++i) {
            byArray[i] = this.bbwi.byteBuffer.get(i);
        }
        return byArray;
    }

    @Override
    public GIOPVersion getGIOPVersion() {
        return GIOPVersion.V1_0;
    }

    @Override
    void setHeaderPadding(boolean bl) {
        throw this.wrapper.giopVersionError();
    }

    protected void handleSpecialChunkBegin(int n) {
    }

    protected void handleSpecialChunkEnd() {
    }

    protected final int computeAlignment(int n) {
        int n2;
        if (n > 1 && (n2 = this.bbwi.position() & n - 1) != 0) {
            return n - n2;
        }
        return 0;
    }

    protected void alignAndReserve(int n, int n2) {
        this.bbwi.position(this.bbwi.position() + this.computeAlignment(n));
        if (this.bbwi.position() + n2 > this.bbwi.buflen) {
            this.grow(n, n2);
        }
    }

    protected void grow(int n, int n2) {
        this.bbwi.needed = n2;
        this.bufferManagerWrite.overflow(this.bbwi);
    }

    @Override
    public final void putEndian() throws SystemException {
        this.write_boolean(this.littleEndian);
    }

    public final boolean littleEndian() {
        return this.littleEndian;
    }

    @Override
    void freeInternalCaches() {
        if (this.codebaseCache != null) {
            this.codebaseCache.done();
        }
        if (this.valueCache != null) {
            this.valueCache.done();
        }
        if (this.repositoryIdCache != null) {
            this.repositoryIdCache.done();
        }
    }

    public final void write_longdouble(double d) {
        throw this.wrapper.longDoubleNotImplemented(CompletionStatus.COMPLETED_MAYBE);
    }

    @Override
    public void write_octet(byte by) {
        this.alignAndReserve(1, 1);
        this.bbwi.byteBuffer.put(this.bbwi.position(), by);
        this.bbwi.position(this.bbwi.position() + 1);
    }

    @Override
    public final void write_boolean(boolean bl) {
        this.write_octet(bl ? (byte)1 : 0);
    }

    @Override
    public void write_char(char c) {
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(c);
        if (cTBConverter.getNumBytes() > 1) {
            throw this.wrapper.invalidSingleCharCtb(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_octet(cTBConverter.getBytes()[0]);
    }

    private final void writeLittleEndianWchar(char c) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(c & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(c >>> 8 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeBigEndianWchar(char c) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(c >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(c & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeLittleEndianShort(short s) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(s & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(s >>> 8 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeBigEndianShort(short s) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(s >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(s & 0xFF));
        this.bbwi.position(this.bbwi.position() + 2);
    }

    private final void writeLittleEndianLong(int n) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(n & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(n >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(n >>> 16 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(n >>> 24 & 0xFF));
        this.bbwi.position(this.bbwi.position() + 4);
    }

    private final void writeBigEndianLong(int n) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(n >>> 24 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(n >>> 16 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(n >>> 8 & 0xFF));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(n & 0xFF));
        this.bbwi.position(this.bbwi.position() + 4);
    }

    private final void writeLittleEndianLongLong(long l) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(l & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(l >>> 8 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(l >>> 16 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(l >>> 24 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 4, (byte)(l >>> 32 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 5, (byte)(l >>> 40 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 6, (byte)(l >>> 48 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 7, (byte)(l >>> 56 & 0xFFL));
        this.bbwi.position(this.bbwi.position() + 8);
    }

    private final void writeBigEndianLongLong(long l) {
        this.bbwi.byteBuffer.put(this.bbwi.position(), (byte)(l >>> 56 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 1, (byte)(l >>> 48 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 2, (byte)(l >>> 40 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 3, (byte)(l >>> 32 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 4, (byte)(l >>> 24 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 5, (byte)(l >>> 16 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 6, (byte)(l >>> 8 & 0xFFL));
        this.bbwi.byteBuffer.put(this.bbwi.position() + 7, (byte)(l & 0xFFL));
        this.bbwi.position(this.bbwi.position() + 8);
    }

    @Override
    public void write_wchar(char c) {
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianWchar(c);
        } else {
            this.writeBigEndianWchar(c);
        }
    }

    @Override
    public void write_short(short s) {
        this.alignAndReserve(2, 2);
        if (this.littleEndian) {
            this.writeLittleEndianShort(s);
        } else {
            this.writeBigEndianShort(s);
        }
    }

    @Override
    public final void write_ushort(short s) {
        this.write_short(s);
    }

    @Override
    public void write_long(int n) {
        this.alignAndReserve(4, 4);
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    @Override
    public final void write_ulong(int n) {
        this.write_long(n);
    }

    @Override
    public void write_longlong(long l) {
        this.alignAndReserve(8, 8);
        if (this.littleEndian) {
            this.writeLittleEndianLongLong(l);
        } else {
            this.writeBigEndianLongLong(l);
        }
    }

    @Override
    public final void write_ulonglong(long l) {
        this.write_longlong(l);
    }

    @Override
    public final void write_float(float f) {
        this.write_long(Float.floatToIntBits(f));
    }

    @Override
    public final void write_double(double d) {
        this.write_longlong(Double.doubleToLongBits(d));
    }

    @Override
    public void write_string(String string) {
        this.writeString(string);
    }

    protected int writeString(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        CodeSetConversion.CTBConverter cTBConverter = this.getCharConverter();
        cTBConverter.convert(string);
        int n = cTBConverter.getNumBytes() + 1;
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 4 + n);
        this.write_long(n);
        int n2 = this.get_offset() - 4;
        this.internalWriteOctetArray(cTBConverter.getBytes(), 0, cTBConverter.getNumBytes());
        this.write_octet((byte)0);
        this.handleSpecialChunkEnd();
        return n2;
    }

    @Override
    public void write_wstring(String string) {
        if (string == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        if (ORBUtility.isForeignORB(this.orb)) {
            throw this.wrapper.wcharDataInGiop10(CompletionStatus.COMPLETED_MAYBE);
        }
        int n = string.length() + 1;
        this.handleSpecialChunkBegin(4 + n * 2 + this.computeAlignment(4));
        this.write_long(n);
        for (int i = 0; i < n - 1; ++i) {
            this.write_wchar(string.charAt(i));
        }
        this.write_short((short)0);
        this.handleSpecialChunkEnd();
    }

    void internalWriteOctetArray(byte[] byArray, int n, int n2) {
        int n3;
        boolean bl = true;
        for (int i = n; i < n2 + n; i += n3) {
            int n4;
            int n5;
            if (this.bbwi.position() + 1 > this.bbwi.buflen || bl) {
                bl = false;
                this.alignAndReserve(1, 1);
            }
            n3 = (n5 = n2 + n - i) < (n4 = this.bbwi.buflen - this.bbwi.position()) ? n5 : n4;
            for (int j = 0; j < n3; ++j) {
                this.bbwi.byteBuffer.put(this.bbwi.position() + j, byArray[i + j]);
            }
            this.bbwi.position(this.bbwi.position() + n3);
        }
    }

    @Override
    public final void write_octet_array(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        this.internalWriteOctetArray(byArray, n, n2);
        this.handleSpecialChunkEnd();
    }

    @Override
    public void write_Principal(Principal principal) {
        this.write_long(principal.name().length);
        this.write_octet_array(principal.name(), 0, principal.name().length);
    }

    @Override
    public void write_any(Any any) {
        if (any == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.write_TypeCode(any.type());
        any.write_value(this.parent);
    }

    @Override
    public void write_TypeCode(TypeCode typeCode) {
        if (typeCode == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        TypeCodeImpl typeCodeImpl = typeCode instanceof TypeCodeImpl ? (TypeCodeImpl)typeCode : new TypeCodeImpl(this.orb, typeCode);
        typeCodeImpl.write_value(this.parent);
    }

    @Override
    public void write_Object(Object object) {
        if (object == null) {
            IOR iOR = IORFactories.makeIOR(this.orb);
            iOR.write(this.parent);
            return;
        }
        if (object instanceof LocalObject) {
            throw this.wrapper.writeLocalObject(CompletionStatus.COMPLETED_MAYBE);
        }
        IOR iOR = ORBUtility.connectAndGetIOR(this.orb, object);
        iOR.write(this.parent);
    }

    @Override
    public void write_abstract_interface(java.lang.Object object) {
        boolean bl = false;
        Object object2 = null;
        if (object != null && object instanceof Object) {
            object2 = (Object)object;
            bl = true;
        }
        this.write_boolean(bl);
        if (bl) {
            this.write_Object(object2);
        } else {
            try {
                this.write_value((Serializable)object);
            }
            catch (ClassCastException classCastException) {
                if (object instanceof Serializable) {
                    throw classCastException;
                }
                ORBUtility.throwNotSerializableForCorba(object.getClass().getName());
            }
        }
    }

    @Override
    public void write_value(Serializable serializable, Class clazz) {
        this.write_value(serializable);
    }

    private void writeWStringValue(String string) {
        int n = this.writeValueTag(this.mustChunk, true, null);
        this.write_repositoryId(this.repIdStrs.getWStringValueRepId());
        this.updateIndirectionTable(n, string, string);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        this.write_wstring(string);
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeArray(Serializable serializable, Class clazz) {
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler();
        }
        int n = this.writeValueTag(this.mustChunk, true, Util.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createSequenceRepID(clazz));
        this.updateIndirectionTable(n, serializable, serializable);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        if (this.valueHandler instanceof ValueHandlerMultiFormat) {
            ValueHandlerMultiFormat valueHandlerMultiFormat = (ValueHandlerMultiFormat)this.valueHandler;
            valueHandlerMultiFormat.writeValue(this.parent, serializable, this.streamFormatVersion);
        } else {
            this.valueHandler.writeValue(this.parent, serializable);
        }
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeValueBase(ValueBase valueBase, Class clazz) {
        this.mustChunk = true;
        int n = this.writeValueTag(true, true, Util.getCodebase(clazz));
        String string = valueBase._truncatable_ids()[0];
        this.write_repositoryId(string);
        this.updateIndirectionTable(n, valueBase, valueBase);
        this.start_block();
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.writeIDLValue(valueBase, string);
        this.end_block();
        this.writeEndTag(true);
    }

    private void writeRMIIIOPValueType(Serializable serializable, Class clazz) {
        Serializable serializable2;
        if (this.valueHandler == null) {
            this.valueHandler = ORBUtility.createValueHandler();
        }
        if ((serializable = this.valueHandler.writeReplace(serializable2 = serializable)) == null) {
            this.write_long(0);
            return;
        }
        if (serializable != serializable2) {
            if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
                this.writeIndirection(-1, this.valueCache.getVal(serializable));
                return;
            }
            clazz = serializable.getClass();
        }
        if (this.mustChunk || this.valueHandler.isCustomMarshaled(clazz)) {
            this.mustChunk = true;
        }
        int n = this.writeValueTag(this.mustChunk, true, Util.getCodebase(clazz));
        this.write_repositoryId(this.repIdStrs.createForJavaType(clazz));
        this.updateIndirectionTable(n, serializable, serializable2);
        if (this.mustChunk) {
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            this.start_block();
        } else {
            --this.end_flag;
        }
        if (this.valueHandler instanceof ValueHandlerMultiFormat) {
            ValueHandlerMultiFormat valueHandlerMultiFormat = (ValueHandlerMultiFormat)this.valueHandler;
            valueHandlerMultiFormat.writeValue(this.parent, serializable, this.streamFormatVersion);
        } else {
            this.valueHandler.writeValue(this.parent, serializable);
        }
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    @Override
    public void write_value(Serializable serializable, String string) {
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        Class<?> clazz = serializable.getClass();
        boolean bl = this.mustChunk;
        if (this.mustChunk) {
            this.mustChunk = true;
        }
        if (this.inBlock) {
            this.end_block();
        }
        if (clazz.isArray()) {
            this.writeArray(serializable, clazz);
        } else if (serializable instanceof ValueBase) {
            this.writeValueBase((ValueBase)serializable, clazz);
        } else if (this.shouldWriteAsIDLEntity(serializable)) {
            this.writeIDLEntity((IDLEntity)serializable);
        } else if (serializable instanceof String) {
            this.writeWStringValue((String)((java.lang.Object)serializable));
        } else if (serializable instanceof Class) {
            this.writeClass(string, (Class)serializable);
        } else {
            this.writeRMIIIOPValueType(serializable, clazz);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    public void write_value(Serializable serializable) {
        this.write_value(serializable, (String)null);
    }

    @Override
    public void write_value(Serializable serializable, BoxedValueHelper boxedValueHelper) {
        int n;
        if (serializable == null) {
            this.write_long(0);
            return;
        }
        if (this.valueCache != null && this.valueCache.containsKey(serializable)) {
            this.writeIndirection(-1, this.valueCache.getVal(serializable));
            return;
        }
        boolean bl = this.mustChunk;
        boolean bl2 = false;
        if (boxedValueHelper instanceof ValueHelper) {
            try {
                n = ((ValueHelper)boxedValueHelper).get_type().type_modifier();
            }
            catch (BadKind badKind) {
                n = 0;
            }
            if (serializable instanceof CustomMarshal && n == 1) {
                bl2 = true;
                this.mustChunk = true;
            }
            if (n == 3) {
                this.mustChunk = true;
            }
        }
        if (this.mustChunk) {
            if (this.inBlock) {
                this.end_block();
            }
            n = this.writeValueTag(true, this.orb.getORBData().useRepId(), Util.getCodebase(serializable.getClass()));
            if (this.orb.getORBData().useRepId()) {
                this.write_repositoryId(boxedValueHelper.get_id());
            }
            this.updateIndirectionTable(n, serializable, serializable);
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
            if (bl2) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
            this.end_block();
            this.writeEndTag(true);
        } else {
            n = this.writeValueTag(false, this.orb.getORBData().useRepId(), Util.getCodebase(serializable.getClass()));
            if (this.orb.getORBData().useRepId()) {
                this.write_repositoryId(boxedValueHelper.get_id());
            }
            this.updateIndirectionTable(n, serializable, serializable);
            --this.end_flag;
            boxedValueHelper.write_value(this.parent, serializable);
            this.writeEndTag(false);
        }
        this.mustChunk = bl;
        if (this.mustChunk) {
            this.start_block();
        }
    }

    public int get_offset() {
        return this.bbwi.position();
    }

    @Override
    public void start_block() {
        if (this.debug) {
            this.dprint("CDROutputStream_1_0 start_block, position" + this.bbwi.position());
        }
        this.write_long(0);
        this.inBlock = true;
        this.blockSizePosition = this.get_offset();
        this.blockSizeIndex = this.bbwi.position();
        if (this.debug) {
            this.dprint("CDROutputStream_1_0 start_block, blockSizeIndex " + this.blockSizeIndex);
        }
    }

    protected void writeLongWithoutAlign(int n) {
        if (this.littleEndian) {
            this.writeLittleEndianLong(n);
        } else {
            this.writeBigEndianLong(n);
        }
    }

    @Override
    public void end_block() {
        if (this.debug) {
            this.dprint("CDROutputStream_1_0.java end_block");
        }
        if (!this.inBlock) {
            return;
        }
        if (this.debug) {
            this.dprint("CDROutputStream_1_0.java end_block, in a block");
        }
        this.inBlock = false;
        if (this.get_offset() == this.blockSizePosition) {
            this.bbwi.position(this.bbwi.position() - 4);
            this.blockSizeIndex = -1;
            this.blockSizePosition = -1;
            return;
        }
        int n = this.bbwi.position();
        this.bbwi.position(this.blockSizeIndex - 4);
        this.writeLongWithoutAlign(n - this.blockSizeIndex);
        this.bbwi.position(n);
        this.blockSizeIndex = -1;
        this.blockSizePosition = -1;
    }

    @Override
    public org.omg.CORBA.ORB orb() {
        return this.orb;
    }

    @Override
    public final void write_boolean_array(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        for (int i = 0; i < n2; ++i) {
            this.write_boolean(blArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_char_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(n2);
        for (int i = 0; i < n2; ++i) {
            this.write_char(cArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public void write_wchar_array(char[] cArray, int n, int n2) {
        if (cArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n2 * 2);
        for (int i = 0; i < n2; ++i) {
            this.write_wchar(cArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_short_array(short[] sArray, int n, int n2) {
        if (sArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(2) + n2 * 2);
        for (int i = 0; i < n2; ++i) {
            this.write_short(sArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ushort_array(short[] sArray, int n, int n2) {
        this.write_short_array(sArray, n, n2);
    }

    @Override
    public final void write_long_array(int[] nArray, int n, int n2) {
        if (nArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n2 * 4);
        for (int i = 0; i < n2; ++i) {
            this.write_long(nArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulong_array(int[] nArray, int n, int n2) {
        this.write_long_array(nArray, n, n2);
    }

    @Override
    public final void write_longlong_array(long[] lArray, int n, int n2) {
        if (lArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n2 * 8);
        for (int i = 0; i < n2; ++i) {
            this.write_longlong(lArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_ulonglong_array(long[] lArray, int n, int n2) {
        this.write_longlong_array(lArray, n, n2);
    }

    @Override
    public final void write_float_array(float[] fArray, int n, int n2) {
        if (fArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(4) + n2 * 4);
        for (int i = 0; i < n2; ++i) {
            this.write_float(fArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    @Override
    public final void write_double_array(double[] dArray, int n, int n2) {
        if (dArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        this.handleSpecialChunkBegin(this.computeAlignment(8) + n2 * 8);
        for (int i = 0; i < n2; ++i) {
            this.write_double(dArray[n + i]);
        }
        this.handleSpecialChunkEnd();
    }

    public void write_string_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_string(stringArray[n + i]);
        }
    }

    public void write_wstring_array(String[] stringArray, int n, int n2) {
        if (stringArray == null) {
            throw this.wrapper.nullParam(CompletionStatus.COMPLETED_MAYBE);
        }
        for (int i = 0; i < n2; ++i) {
            this.write_wstring(stringArray[n + i]);
        }
    }

    @Override
    public final void write_any_array(Any[] anyArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            this.write_any(anyArray[n + i]);
        }
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        byte[] byArray = null;
        if (this.bbwi.byteBuffer.hasArray()) {
            byArray = this.bbwi.byteBuffer.array();
        } else {
            int n = this.bbwi.position();
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.bbwi.byteBuffer.get(i);
            }
        }
        outputStream.write(byArray, 0, this.bbwi.position());
    }

    @Override
    public void writeOctetSequenceTo(org.omg.CORBA.portable.OutputStream outputStream) {
        byte[] byArray = null;
        if (this.bbwi.byteBuffer.hasArray()) {
            byArray = this.bbwi.byteBuffer.array();
        } else {
            int n = this.bbwi.position();
            byArray = new byte[n];
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.bbwi.byteBuffer.get(i);
            }
        }
        outputStream.write_long(this.bbwi.position());
        outputStream.write_octet_array(byArray, 0, this.bbwi.position());
    }

    @Override
    public final int getSize() {
        return this.bbwi.position();
    }

    @Override
    public int getIndex() {
        return this.bbwi.position();
    }

    @Override
    public boolean isLittleEndian() {
        return this.littleEndian;
    }

    @Override
    public void setIndex(int n) {
        this.bbwi.position(n);
    }

    @Override
    public ByteBufferWithInfo getByteBufferWithInfo() {
        return this.bbwi;
    }

    @Override
    public void setByteBufferWithInfo(ByteBufferWithInfo byteBufferWithInfo) {
        this.bbwi = byteBufferWithInfo;
    }

    @Override
    public ByteBuffer getByteBuffer() {
        ByteBuffer byteBuffer = null;
        if (this.bbwi != null) {
            byteBuffer = this.bbwi.byteBuffer;
        }
        return byteBuffer;
    }

    @Override
    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.bbwi.byteBuffer = byteBuffer;
    }

    private final void updateIndirectionTable(int n, java.lang.Object object, java.lang.Object object2) {
        if (this.valueCache == null) {
            this.valueCache = new CacheTable(this.orb, true);
        }
        this.valueCache.put(object, n);
        if (object2 != object) {
            this.valueCache.put(object2, n);
        }
    }

    private final void write_repositoryId(String string) {
        if (this.repositoryIdCache != null && this.repositoryIdCache.containsKey(string)) {
            this.writeIndirection(-1, this.repositoryIdCache.getVal(string));
            return;
        }
        int n = this.writeString(string);
        if (this.repositoryIdCache == null) {
            this.repositoryIdCache = new CacheTable(this.orb, true);
        }
        this.repositoryIdCache.put(string, n);
    }

    private void write_codebase(String string, int n) {
        if (this.codebaseCache != null && this.codebaseCache.containsKey(string)) {
            this.writeIndirection(-1, this.codebaseCache.getVal(string));
        } else {
            this.write_string(string);
            if (this.codebaseCache == null) {
                this.codebaseCache = new CacheTable(this.orb, true);
            }
            this.codebaseCache.put(string, n);
        }
    }

    private final int writeValueTag(boolean bl, boolean bl2, String string) {
        int n = 0;
        if (bl && !bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedNoRepStrId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedNoRepStrId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (bl && bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIChunkedId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIChunkedId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (!bl && !bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIUnchunkedNoRepStrId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedNoRepStrId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        } else if (!bl && bl2) {
            if (string == null) {
                this.write_long(this.repIdUtil.getStandardRMIUnchunkedId());
                n = this.get_offset() - 4;
            } else {
                this.write_long(this.repIdUtil.getCodeBaseRMIUnchunkedId());
                n = this.get_offset() - 4;
                this.write_codebase(string, this.get_offset());
            }
        }
        return n;
    }

    private void writeIDLValue(Serializable serializable, String string) {
        if (serializable instanceof StreamableValue) {
            ((StreamableValue)serializable)._write(this.parent);
        } else if (serializable instanceof CustomValue) {
            ((CustomValue)serializable).marshal(this.parent);
        } else {
            BoxedValueHelper boxedValueHelper = Utility.getHelper(serializable.getClass(), null, string);
            boolean bl = false;
            if (boxedValueHelper instanceof ValueHelper && serializable instanceof CustomMarshal) {
                try {
                    if (((ValueHelper)boxedValueHelper).get_type().type_modifier() == 1) {
                        bl = true;
                    }
                }
                catch (BadKind badKind) {
                    throw this.wrapper.badTypecodeForCustomValue(CompletionStatus.COMPLETED_MAYBE, badKind);
                }
            }
            if (bl) {
                ((CustomMarshal)((java.lang.Object)serializable)).marshal(this.parent);
            } else {
                boxedValueHelper.write_value(this.parent, serializable);
            }
        }
    }

    private void writeEndTag(boolean bl) {
        if (bl) {
            if (this.get_offset() == this.end_flag_position && this.bbwi.position() == this.end_flag_index) {
                this.bbwi.position(this.bbwi.position() - 4);
            }
            this.writeNestingLevel();
            this.end_flag_index = this.bbwi.position();
            this.end_flag_position = this.get_offset();
            ++this.chunkedValueNestingLevel;
        }
        ++this.end_flag;
    }

    private void writeNestingLevel() {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_long(this.chunkedValueNestingLevel);
        } else {
            this.write_long(this.end_flag);
        }
    }

    private void writeClass(String string, Class clazz) {
        if (string == null) {
            string = this.repIdStrs.getClassDescValueRepId();
        }
        int n = this.writeValueTag(this.mustChunk, true, null);
        this.updateIndirectionTable(n, clazz, clazz);
        this.write_repositoryId(string);
        if (this.mustChunk) {
            this.start_block();
            --this.end_flag;
            --this.chunkedValueNestingLevel;
        } else {
            --this.end_flag;
        }
        this.writeClassBody(clazz);
        if (this.mustChunk) {
            this.end_block();
        }
        this.writeEndTag(this.mustChunk);
    }

    private void writeClassBody(Class clazz) {
        if (this.orb == null || ORBVersionFactory.getFOREIGN().equals(this.orb.getORBVersion()) || ORBVersionFactory.getNEWER().compareTo(this.orb.getORBVersion()) <= 0) {
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
        } else {
            this.write_value((Serializable)((java.lang.Object)this.repIdStrs.createForAnyType(clazz)));
            this.write_value((Serializable)((java.lang.Object)Util.getCodebase(clazz)));
        }
    }

    private boolean shouldWriteAsIDLEntity(Serializable serializable) {
        return serializable instanceof IDLEntity && !(serializable instanceof ValueBase) && !(serializable instanceof Object);
    }

    private void writeIDLEntity(IDLEntity iDLEntity) {
        this.mustChunk = true;
        String string = this.repIdStrs.createForJavaType(iDLEntity);
        Class<?> clazz = iDLEntity.getClass();
        String string2 = Util.getCodebase(clazz);
        int n = this.writeValueTag(true, true, string2);
        this.updateIndirectionTable(n, iDLEntity, iDLEntity);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
        try {
            ClassLoader classLoader = clazz == null ? null : clazz.getClassLoader();
            final Class clazz2 = Utility.loadClassForClass(clazz.getName() + "Helper", string2, classLoader, clazz, classLoader);
            final Class[] classArray = new Class[]{org.omg.CORBA.portable.OutputStream.class, clazz};
            Method method = null;
            try {
                method = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public java.lang.Object run() throws NoSuchMethodException {
                        return clazz2.getDeclaredMethod(CDROutputStream_1_0.kWriteMethod, classArray);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (NoSuchMethodException)privilegedActionException.getException();
            }
            java.lang.Object[] objectArray = new java.lang.Object[]{this.parent, iDLEntity};
            method.invoke(null, objectArray);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw this.wrapper.errorInvokingHelperWrite(CompletionStatus.COMPLETED_MAYBE, invocationTargetException);
        }
        this.end_block();
        this.writeEndTag(true);
    }

    @Override
    public void write_Abstract(java.lang.Object object) {
        this.write_abstract_interface(object);
    }

    @Override
    public void write_Value(Serializable serializable) {
        this.write_value(serializable);
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal, short s, short s2) {
        String string;
        String string2;
        int n;
        String string3 = bigDecimal.toString();
        if (string3.charAt(0) == '-' || string3.charAt(0) == '+') {
            string3 = string3.substring(1);
        }
        if ((n = string3.indexOf(46)) == -1) {
            string2 = string3;
            string = null;
        } else if (n == 0) {
            string2 = null;
            string = string3;
        } else {
            string2 = string3.substring(0, n);
            string = string3.substring(n + 1);
        }
        StringBuffer stringBuffer = new StringBuffer(s);
        if (string != null) {
            stringBuffer.append(string);
        }
        while (stringBuffer.length() < s2) {
            stringBuffer.append('0');
        }
        if (string2 != null) {
            stringBuffer.insert(0, string2);
        }
        while (stringBuffer.length() < s) {
            stringBuffer.insert(0, '0');
        }
        this.write_fixed(stringBuffer.toString(), bigDecimal.signum());
    }

    @Override
    public void write_fixed(BigDecimal bigDecimal) {
        this.write_fixed(bigDecimal.toString(), bigDecimal.signum());
    }

    public void write_fixed(String string, int n) {
        char c;
        int n2;
        int n3 = string.length();
        byte by = 0;
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            ++n4;
        }
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '-' || c == '+' || c == '.') continue;
            byte by2 = (byte)Character.digit(c, 10);
            if (by2 == -1) {
                throw this.wrapper.badDigitInFixed(CompletionStatus.COMPLETED_MAYBE);
            }
            if (n4 % 2 == 0) {
                by = (byte)(by | by2);
                this.write_octet(by);
                by = 0;
            } else {
                by = (byte)(by | by2 << 4);
            }
            --n4;
        }
        by = n == -1 ? (byte)((byte)(by | 0xD)) : (byte)((byte)(by | 0xC));
        this.write_octet(by);
    }

    @Override
    public String[] _truncatable_ids() {
        if (_ids == null) {
            return null;
        }
        return (String[])_ids.clone();
    }

    @Override
    public void printBuffer() {
        CDROutputStream_1_0.printBuffer(this.bbwi);
    }

    public static void printBuffer(ByteBufferWithInfo byteBufferWithInfo) {
        System.out.println("+++++++ Output Buffer ++++++++");
        System.out.println();
        System.out.println("Current position: " + byteBufferWithInfo.position());
        System.out.println("Total length : " + byteBufferWithInfo.buflen);
        System.out.println();
        char[] cArray = new char[16];
        try {
            for (int i = 0; i < byteBufferWithInfo.position(); i += 16) {
                int n;
                int n2;
                for (n2 = 0; n2 < 16 && n2 + i < byteBufferWithInfo.position(); ++n2) {
                    String string;
                    n = byteBufferWithInfo.byteBuffer.get(i + n2);
                    if (n < 0) {
                        n = 256 + n;
                    }
                    if ((string = Integer.toHexString(n)).length() == 1) {
                        string = "0" + string;
                    }
                    System.out.print(string + " ");
                }
                while (n2 < 16) {
                    System.out.print("   ");
                    ++n2;
                }
                for (n = 0; n < 16 && n + i < byteBufferWithInfo.position(); ++n) {
                    cArray[n] = ORBUtility.isPrintable((char)byteBufferWithInfo.byteBuffer.get(i + n)) ? (int)byteBufferWithInfo.byteBuffer.get(i + n) : 46;
                }
                System.out.println(new String(cArray, 0, n));
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.out.println("++++++++++++++++++++++++++++++");
    }

    @Override
    public void writeIndirection(int n, int n2) {
        this.handleSpecialChunkBegin(this.computeAlignment(4) + 8);
        this.write_long(n);
        this.write_long(n2 - this.parent.getRealIndex(this.get_offset()));
        this.handleSpecialChunkEnd();
    }

    protected CodeSetConversion.CTBConverter getCharConverter() {
        if (this.charConverter == null) {
            this.charConverter = this.parent.createCharCTBConverter();
        }
        return this.charConverter;
    }

    protected CodeSetConversion.CTBConverter getWCharConverter() {
        if (this.wcharConverter == null) {
            this.wcharConverter = this.parent.createWCharCTBConverter();
        }
        return this.wcharConverter;
    }

    protected void dprint(String string) {
        if (this.debug) {
            ORBUtility.dprint(this, string);
        }
    }

    @Override
    void alignOnBoundary(int n) {
        this.alignAndReserve(n, 0);
    }

    @Override
    public void start_value(String string) {
        if (this.debug) {
            this.dprint("start_value w/ rep id " + string + " called at pos " + this.get_offset() + " position " + this.bbwi.position());
        }
        if (this.inBlock) {
            this.end_block();
        }
        this.writeValueTag(true, true, null);
        this.write_repositoryId(string);
        --this.end_flag;
        --this.chunkedValueNestingLevel;
        this.start_block();
    }

    @Override
    public void end_value() {
        if (this.debug) {
            this.dprint("end_value called at pos " + this.get_offset() + " position " + this.bbwi.position());
        }
        this.end_block();
        this.writeEndTag(true);
        if (this.debug) {
            this.dprint("mustChunk is " + this.mustChunk);
        }
        if (this.mustChunk) {
            this.start_block();
        }
    }

    @Override
    public void close() throws IOException {
        this.getBufferManager().close();
        if (this.getByteBufferWithInfo() != null && this.getByteBuffer() != null) {
            java.lang.Object object;
            MessageMediator messageMediator = this.parent.getMessageMediator();
            if (messageMediator != null && (object = (CDRInputObject)messageMediator.getInputObject()) != null && ((CDRInputStream)object).isSharing(this.getByteBuffer())) {
                ((CDRInputStream)object).setByteBuffer(null);
                ((CDRInputStream)object).setByteBufferWithInfo(null);
            }
            object = this.orb.getByteBufferPool();
            if (this.debug) {
                int n = System.identityHashCode(this.bbwi.byteBuffer);
                StringBuffer stringBuffer = new StringBuffer(80);
                stringBuffer.append(".close - releasing ByteBuffer id (");
                stringBuffer.append(n).append(") to ByteBufferPool.");
                String string = stringBuffer.toString();
                this.dprint(string);
            }
            object.releaseByteBuffer(this.getByteBuffer());
            this.bbwi.byteBuffer = null;
            this.bbwi = null;
        }
    }
}

