/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jnlp;

import com.sun.deploy.cache.Cache;
import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.util.URLUtil;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.jnlp.ApiDialog;
import com.sun.jnlp.CheckServicePermission;
import com.sun.jnlp.FileContentsImpl;
import com.sun.jnlp.JNLPClassLoaderUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import javax.jnlp.FileContents;
import javax.jnlp.PersistenceService;

public final class PersistenceServiceImpl
implements PersistenceService {
    private static final int MUFFIN_TAG_INDEX = 0;
    private static final int MUFFIN_MAXSIZE_INDEX = 1;
    private static final long GIGABYTE = 0x40000000L;
    private static final long GLOBAL_LIMIT = 0x100000000L;
    private static PersistenceServiceImpl _sharedInstance = null;
    private long _appLimit = -1L;
    private final ApiDialog _apiDialog = new ApiDialog();

    private PersistenceServiceImpl() {
    }

    public static synchronized PersistenceServiceImpl getInstance() {
        PersistenceServiceImpl.initialize();
        return _sharedInstance;
    }

    public static synchronized void initialize() {
        if (_sharedInstance == null) {
            _sharedInstance = new PersistenceServiceImpl();
        }
        if (_sharedInstance != null) {
            long l = (long)Config.getIntProperty((String)"deployment.javaws.muffin.max") * 1024L;
            if (l > 0x100000000L) {
                l = 0x100000000L;
            }
            PersistenceServiceImpl._sharedInstance._appLimit = l;
        }
    }

    long getLength(URL uRL) throws MalformedURLException, IOException {
        this.checkAccess(uRL);
        return Cache.getMuffinSize((URL)uRL);
    }

    long getMaxLength(final URL uRL) throws MalformedURLException, IOException {
        long l = 0L;
        try {
            l = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws IOException {
                    long[] lArray = Cache.getMuffinAttributes((URL)uRL);
                    if (lArray == null) {
                        return -1L;
                    }
                    return lArray[1];
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        return l;
    }

    long setMaxLength(final URL uRL, long l) throws MalformedURLException, IOException {
        long l2;
        block4: {
            l2 = 0L;
            this.checkAccess(uRL);
            l2 = this.checkSetMaxSize(uRL, l);
            if (l2 < 0L) {
                return -1L;
            }
            final long l3 = l2;
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes((URL)uRL, (int)PersistenceServiceImpl.this.getTag(uRL), (long)l3);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    private long checkSetMaxSize(final URL uRL, long l) throws IOException {
        long l2;
        URL[] uRLArray = null;
        try {
            uRLArray = AccessController.doPrivileged(new PrivilegedExceptionAction<URL[]>(){

                @Override
                public URL[] run() throws IOException {
                    return Cache.getAccessibleMuffins((URL)uRL);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
        long l3 = 0L;
        if (uRLArray != null) {
            for (int i = 0; i < uRLArray.length; ++i) {
                URL uRL2;
                if (uRLArray[i] == null || (uRL2 = uRLArray[i]).equals(uRL)) continue;
                long l4 = 0L;
                try {
                    l4 = this.getMaxLength(uRL2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                l3 += l4;
            }
        }
        if (l > (l2 = this._appLimit - l3)) {
            return this.reconcileMaxSize(l, l3, this._appLimit);
        }
        return l;
    }

    private long reconcileMaxSize(long l, long l2, long l3) {
        long l4 = l + l2;
        if (l4 < l || l4 > 0x100000000L) {
            return l3 - l2;
        }
        boolean bl = CheckServicePermission.hasFileAccessPermissions();
        if (bl || this.askUser(l4, l3)) {
            this._appLimit = l4;
            return l;
        }
        return l3 - l2;
    }

    public long create(final URL uRL, long l) throws MalformedURLException, IOException {
        long l2;
        block4: {
            this.checkAccess(uRL);
            l2 = 0L;
            long l3 = -1L;
            l3 = this.checkSetMaxSize(uRL, l);
            if (l3 < 0L) {
                return 0L;
            }
            final long l4 = l3;
            try {
                l2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                    @Override
                    public Long run() throws MalformedURLException, IOException {
                        Cache.createMuffinEntry((URL)uRL, (int)0, (long)l4);
                        return l4;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        return l2;
    }

    public FileContents get(final URL uRL) throws MalformedURLException, IOException {
        File file;
        block4: {
            this.checkAccess(uRL);
            file = null;
            try {
                file = AccessController.doPrivileged(new PrivilegedExceptionAction<File>(){

                    @Override
                    public File run() throws MalformedURLException, IOException {
                        return Cache.getMuffinFile((URL)uRL);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block4;
                throw (MalformedURLException)exception;
            }
        }
        if (file == null) {
            throw new FileNotFoundException(uRL.toString());
        }
        return new FileContentsImpl(file, this, uRL, this.getMaxLength(uRL));
    }

    public void delete(final URL uRL) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.removeMuffinEntry((URL)uRL);
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
    }

    public String[] getNames(URL uRL) throws MalformedURLException, IOException {
        String[] stringArray;
        block3: {
            stringArray = null;
            final URL uRL2 = URLUtil.asPathURL((URL)uRL);
            this.checkAccess(uRL2);
            try {
                stringArray = AccessController.doPrivileged(new PrivilegedExceptionAction<String[]>(){

                    @Override
                    public String[] run() throws MalformedURLException, IOException {
                        return Cache.getMuffinNames((URL)uRL2);
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
        return stringArray;
    }

    public int getTag(final URL uRL) throws MalformedURLException, IOException {
        Integer n;
        block3: {
            n = null;
            this.checkAccess(uRL);
            try {
                n = AccessController.doPrivileged(new PrivilegedExceptionAction<Integer>(){

                    @Override
                    public Integer run() throws MalformedURLException, IOException {
                        long[] lArray = Cache.getMuffinAttributes((URL)uRL);
                        if (lArray == null) {
                            throw new MalformedURLException();
                        }
                        return (int)lArray[0];
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
        return n;
    }

    public void setTag(final URL uRL, final int n) throws MalformedURLException, IOException {
        block3: {
            this.checkAccess(uRL);
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws MalformedURLException, IOException {
                        Cache.putMuffinAttributes((URL)uRL, (int)n, (long)PersistenceServiceImpl.this.getMaxLength(uRL));
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                if (exception instanceof IOException) {
                    throw (IOException)exception;
                }
                if (!(exception instanceof MalformedURLException)) break block3;
                throw (MalformedURLException)exception;
            }
        }
    }

    private boolean askUser(final long l, final long l2) {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                String string = ResourceManager.getString((String)"api.persistence.title");
                String string2 = ResourceManager.getString((String)"api.persistence.message");
                String string3 = ResourceManager.getString((String)"api.persistence.detail", (Long)new Long(l), (Long)new Long(l2));
                ApiDialog.DialogResult dialogResult = PersistenceServiceImpl.this._apiDialog.askUser(string, string2, null, null, string3, false);
                if (dialogResult == ApiDialog.DialogResult.OK || dialogResult == ApiDialog.DialogResult.ALWAYS) {
                    long l3 = Math.min(0x100000000L, (l + 1023L) / 1024L);
                    Config.setIntProperty((String)"deployment.javaws.muffin.max", (int)((int)l3));
                    Config.get().storeIfNeeded();
                    return true;
                }
                return false;
            }
        });
        return bl;
    }

    protected void checkAccess(URL uRL) throws MalformedURLException {
        URL uRL2;
        if (uRL == null) {
            throw new MalformedURLException("URL is null");
        }
        LaunchDesc launchDesc = JNLPClassLoaderUtil.getInstance().getLaunchDesc();
        if (launchDesc != null && launchDesc.getSecurityModel() == 0 && (uRL2 = launchDesc.getMainJarURL()) != null) {
            int n;
            String string;
            if (uRL == null || !uRL2.getHost().equals(uRL.getHost())) {
                this.throwAccessDenied(uRL);
            }
            if ((string = uRL.getFile()) == null) {
                this.throwAccessDenied(uRL);
            }
            if ((n = string.lastIndexOf(47)) == -1) {
                return;
            }
            if (!uRL2.getFile().startsWith(string.substring(0, n + 1))) {
                this.throwAccessDenied(uRL);
            }
        }
    }

    private void throwAccessDenied(URL uRL) throws MalformedURLException {
        throw new MalformedURLException(ResourceManager.getString((String)"api.persistence.accessdenied", (String)uRL.toString()));
    }
}

