/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.misc;

import com.jrockit.mc.ui.misc.MCColor;
import com.jrockit.mc.ui.misc.Messages;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class ColorConfigurationPage
extends WizardPage {
    public static final String NAME = "color.page";
    private final Map<String, MCColor> m_colorMap = new LinkedHashMap<String, MCColor>();
    private final Map<String, String> m_nameMap = new LinkedHashMap<String, String>();

    public ColorConfigurationPage() {
        super(NAME);
        this.setTitle(Messages.ColorPage_Configure_COLOR_TITLE_TEXT);
        this.setDescription(Messages.ColorChooser_COLOR_CONFIGURATION_DESCRIPTION_TEXT);
    }

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        layout.numColumns = 2;
        Iterator<String> iterator = this.m_nameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String element;
            String key = element = iterator.next();
            this.createInput(parent, key);
        }
        this.setControl((Control)parent);
    }

    private void createInput(Composite parent, String key) {
        GridData gd1 = new GridData(4, 4, true, false);
        Label l = this.createLabel(parent, key);
        l.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        ColorSelector selector = this.createSelector(parent, key);
        selector.getButton().setLayoutData((Object)gd2);
    }

    private Label createLabel(Composite parent, String key) {
        String name = this.m_nameMap.get(key);
        Label label = new Label(parent, 0);
        label.setText(name);
        return label;
    }

    private ColorSelector createSelector(Composite parent, final String key) {
        ColorSelector selector = new ColorSelector(parent);
        selector.setColorValue(this.m_colorMap.get(key).getRGBColor());
        selector.addListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("colorValue".equals(event.getProperty())) {
                    ColorConfigurationPage.this.m_colorMap.put(key, new MCColor((RGB)event.getNewValue()));
                }
            }
        });
        return selector;
    }

    public void addColorToConfigure(String key, String displayName, MCColor defaultColor) {
        this.m_colorMap.put(key, defaultColor);
        this.m_nameMap.put(key, displayName);
    }

    public MCColor getColor(String key) {
        return this.m_colorMap.get(key);
    }
}

