/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.ui.fields;

import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.fields.FieldFilter;
import com.jrockit.mc.ui.fields.Messages;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.IFieldListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.WorkbenchJob;

public class FieldViewerFilterControl
extends Composite
implements IFieldListener {
    private static Color filterErrorBgColor = JFaceResources.getColorRegistry().get("ERROR_COLOR");
    private static Color filterErrorFgColor = Display.getCurrent().getSystemColor(22);
    private static Color filterColorForeground = UIPlugin.getDefault().getFontColorToolkit().getFilterForegroundColor();
    private static Color filterColorBackground = UIPlugin.getDefault().getFontColorToolkit().getFilterBackgroundColor();
    private final ViewerFilterRefreshJob m_refreshJob = new ViewerFilterRefreshJob();
    private final boolean m_showCombo;
    private Text m_filterText;
    private ComboViewer m_comboViewer;
    private final FieldFilter m_fieldFilter = new FieldFilter(null, "");
    private Field[] m_fields;
    private StructuredViewer m_viewer;
    private Label filterLabel;
    private ControlDecoration m_cd;

    public FieldViewerFilterControl(Composite parent, FormToolkit toolkit, boolean showCombo) {
        super(parent, 0);
        this.m_showCombo = showCombo;
        toolkit.paintBordersFor((Composite)this);
        this.create(toolkit, this);
    }

    public void initialize(StructuredViewer viewer, Field[] fields) {
        this.m_viewer = viewer;
        this.m_fields = fields;
        if (this.hasComboViewer()) {
            this.m_comboViewer.setInput((Object)fields);
        }
        if (this.m_fields.length > 0) {
            this.setFilteredField(this.m_fields[0]);
        }
        this.hookListeners();
        this.layout(true, true);
    }

    private void hookListeners() {
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Field[] fieldArray = FieldViewerFilterControl.this.m_fields;
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field m_field = fieldArray[n2];
                    m_field.removeListener(FieldViewerFilterControl.this);
                    ++n2;
                }
            }
        });
        Field[] fieldArray = this.m_fields;
        int n = this.m_fields.length;
        int n2 = 0;
        while (n2 < n) {
            Field m_field = fieldArray[n2];
            m_field.addListener(this);
            ++n2;
        }
    }

    @Override
    public void changed(Field field, Object property) {
        if ("visibility.change".equals(property)) {
            this.refresh();
        }
    }

    public void refresh() {
        if (this.hasComboViewer()) {
            this.m_comboViewer.refresh();
        }
    }

    public void setFilteredField(Field field) {
        this.m_fieldFilter.setFilterField(field);
        this.m_fieldFilter.setFilterExpression("*");
        if (this.hasComboViewer()) {
            this.m_comboViewer.setSelection((ISelection)new StructuredSelection((Object)field));
        }
    }

    protected void create(FormToolkit toolkit, Composite parent) {
        int numColumns = this.m_showCombo ? 3 : 2;
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginWidth = 2;
        layout.marginRight = 16;
        layout.marginHeight = 2;
        this.setLayout((Layout)layout);
        GridData gd0 = new GridData(4, 0x1000000, false, false);
        this.filterLabel = toolkit.createLabel(parent, "");
        if (this.m_showCombo) {
            this.filterLabel.setText(Messages.TableSectionPart_FILTER_COLUMN_TEXT);
        } else {
            this.filterLabel.setText(Messages.FieldViewerFilterControl_FILTER_SINGLE_COLUMN_TEXT);
        }
        this.filterLabel.setLayoutData((Object)gd0);
        if (this.m_showCombo) {
            GridData gd1 = new GridData(4, 4, false, false);
            this.m_comboViewer = this.createFilterCombo(toolkit, parent);
            this.m_comboViewer.getControl().setLayoutData((Object)gd1);
        }
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        this.m_filterText = toolkit.createText(parent, "", 0);
        this.m_filterText.setText("");
        this.m_cd = new ControlDecoration((Control)this.m_filterText, 131072);
        this.m_cd.hide();
        this.m_cd.setImage(UIPlugin.getDefault().getImage("error_obj.gif"));
        this.m_filterText.setLayoutData((Object)gd2);
        this.m_filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\r' && e.keyCode == 13) {
                    FieldViewerFilterControl.this.updateFilter(0L);
                }
            }
        });
        this.m_filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldViewerFilterControl.this.updateFilter(600L);
            }
        });
        this.m_filterText.setToolTipText(Messages.FieldViewerFilterControl_TYPE_FILTER_TOOLTIP_TEXT);
        if (UIPlugin.getDefault().getAccessibilityMode()) {
            MCAccessibleListener mcal = new MCAccessibleListener();
            mcal.setName(Messages.FieldViewerFilterControl_TYPE_FILTER_TOOLTIP_TEXT);
            this.m_filterText.getAccessible().addAccessibleListener((AccessibleListener)mcal);
        }
    }

    private ComboViewer createFilterCombo(FormToolkit toolkit, Composite parent) {
        ComboViewer viewer = new ComboViewer(parent);
        toolkit.adapt((Composite)viewer.getControl());
        viewer.setContentProvider((IContentProvider)new ComboProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new ComboProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FieldViewerFilterControl.this.updateFilter(0L);
            }
        });
        viewer.getCombo().setVisibleItemCount(10);
        viewer.setFilters(this.createComboFiler());
        return viewer;
    }

    private ViewerFilter[] createComboFiler() {
        return new ViewerFilter[]{new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return ((Field)element).isFilterable();
            }
        }};
    }

    boolean hasComboViewer() {
        return this.m_comboViewer != null && !this.m_comboViewer.getControl().isDisposed();
    }

    public void updateFilter(long delay) {
        if (this.m_filterText == null || this.m_filterText.isDisposed()) {
            return;
        }
        Field field = this.getFieldToFilter();
        if (field != null) {
            this.m_refreshJob.cancel();
            this.m_viewer.setFilters(new ViewerFilter[]{this.m_fieldFilter});
            this.m_fieldFilter.setFilterField(field);
            String filterExpressions = this.m_filterText.getText();
            this.m_fieldFilter.setFilterExpression(filterExpressions);
            if (this.m_fieldFilter.getErrorMessage() != null) {
                this.m_cd.setDescriptionText(String.valueOf(this.m_fieldFilter.getErrorMessage()) + "\n" + Messages.FieldViewerFilterControl_FILTER_EXPRESSION_TIP);
                this.m_cd.show();
            } else {
                this.m_cd.setDescriptionText(null);
                this.m_cd.hide();
            }
            if (delay > 0L) {
                this.m_refreshJob.schedule(delay);
            } else {
                this.m_viewer.refresh();
            }
        }
        String text = this.m_filterText.getText().trim();
        if (this.m_fieldFilter.getErrorMessage() != null) {
            this.m_filterText.setBackground(filterErrorBgColor);
            this.m_filterText.setForeground(filterErrorFgColor);
        } else if (text.length() > 0) {
            this.m_filterText.setForeground(filterColorForeground);
            this.m_filterText.setBackground(filterColorBackground);
        } else {
            this.m_filterText.setBackground(null);
            this.m_filterText.setForeground(null);
        }
    }

    public Text getTextControl() {
        return this.m_filterText;
    }

    private Field getFieldToFilter() {
        if (this.m_showCombo) {
            if (this.hasComboViewer()) {
                return (Field)((IStructuredSelection)this.m_comboViewer.getSelection()).getFirstElement();
            }
        } else if (this.m_fields.length > 0) {
            return this.m_fields[0];
        }
        return null;
    }

    public Control getComboControl() {
        return this.m_comboViewer.getControl();
    }

    static class ComboProvider
    extends LabelProvider
    implements IStructuredContentProvider {
        ComboProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return (Object[])inputElement;
        }

        public String getText(Object element) {
            return ((Field)element).getName();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class ViewerFilterRefreshJob
    extends WorkbenchJob {
        public ViewerFilterRefreshJob() {
            super("ViewerFilter Refresh Job");
            this.setSystem(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            FieldViewerFilterControl.this.m_viewer.refresh();
            return Status.OK_STATUS;
        }
    }
}

