/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.components.ui.design.view.toolbar;

import com.jrockit.mc.components.ui.messages.internal.Messages;
import com.jrockit.mc.components.ui.tab.BaseDescriptor;
import com.jrockit.mc.components.ui.tab.TabGroupDescriptor;
import com.jrockit.mc.components.ui.tab.TabItemDescriptor;
import com.jrockit.mc.ui.UIPlugin;
import java.util.List;
import org.eclipse.jface.action.Action;

final class RemoveAction
extends Action {
    private final List<? extends BaseDescriptor> m_list;
    private final BaseDescriptor m_removeItem;

    public RemoveAction(List<? extends BaseDescriptor> list, BaseDescriptor removeItem) {
        super(Messages.DESIGN_MENU_REMOVE_TAB_ITEM_TEXT);
        this.m_list = list;
        this.m_removeItem = removeItem;
        this.setImageDescriptor(UIPlugin.getDefault().getMCImageDescriptor("delete-16.png"));
    }

    public void run() {
        if (this.removeInList(this.m_list, this.m_removeItem)) {
            this.firePropertyChange("refresh", null, null);
        }
    }

    private boolean removeInList(List<? extends BaseDescriptor> list, BaseDescriptor removable) {
        if (list.contains(removable)) {
            return list.remove(removable);
        }
        for (BaseDescriptor baseDescriptor : list) {
            if (!(baseDescriptor instanceof TabGroupDescriptor) || !this.removeInGroup((TabGroupDescriptor)baseDescriptor, removable)) continue;
            return true;
        }
        return false;
    }

    private boolean removeInGroup(TabGroupDescriptor group, BaseDescriptor removable) {
        List<TabItemDescriptor> items = group.getTabs();
        if (items.contains(removable)) {
            return items.remove(removable);
        }
        return this.removeInList(group.getGroups(), removable);
    }
}

