/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.api.internal.util;

import com.taobao.api.FileItem;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoLogger;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AliyunWebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final String METHOD_POST = "POST";
    private static final String METHOD_GET = "GET";

    private AliyunWebUtils() {
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return AliyunWebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        return AliyunWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = AliyunWebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return AliyunWebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, headerMap);
    }

    @Deprecated
    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        return AliyunWebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String rsp;
        HttpURLConnection conn;
        block9: {
            conn = null;
            OutputStream out = null;
            rsp = null;
            try {
                try {
                    conn = AliyunWebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setReadTimeout(readTimeout);
                }
                catch (IOException e) {
                    Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                    TaobaoLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), content);
                    throw e;
                }
                try {
                    out = conn.getOutputStream();
                    out.write(content);
                    rsp = AliyunWebUtils.getResponseAsString(conn);
                }
                catch (IOException e) {
                    Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                    TaobaoLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), content);
                    throw e;
                }
                Object var12_13 = null;
                if (out == null) break block9;
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
            out.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return AliyunWebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
        }
        return AliyunWebUtils.doPost(url, params, fileParams, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws IOException {
        return AliyunWebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return AliyunWebUtils.doPost(url, params, charset, connectTimeout, readTimeout, headerMap);
        }
        return AliyunWebUtils._doPostWithFile(url, params, fileParams, charset, connectTimeout, readTimeout, headerMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPostWithFile(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String rsp;
        HttpURLConnection conn;
        block11: {
            String boundary = System.currentTimeMillis() + "";
            conn = null;
            OutputStream out = null;
            rsp = null;
            try {
                try {
                    String ctype = "multipart/form-data;charset=" + charset + ";boundary=" + boundary;
                    conn = AliyunWebUtils.getConnection(new URL(url), METHOD_POST, ctype, headerMap);
                    conn.setConnectTimeout(connectTimeout);
                    conn.setReadTimeout(readTimeout);
                }
                catch (IOException e) {
                    Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                    TaobaoLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), params);
                    throw e;
                }
                try {
                    out = conn.getOutputStream();
                    byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
                    Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
                    for (Map.Entry<String, String> textEntry : textEntrySet) {
                        byte[] textBytes = AliyunWebUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), charset);
                        out.write(entryBoundaryBytes);
                        out.write(textBytes);
                    }
                    Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
                    for (Map.Entry<String, FileItem> fileEntry : fileEntrySet) {
                        FileItem fileItem = fileEntry.getValue();
                        if (fileItem.getContent() == null) continue;
                        byte[] fileBytes = AliyunWebUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                        out.write(entryBoundaryBytes);
                        out.write(fileBytes);
                        out.write(fileItem.getContent());
                    }
                    byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
                    out.write(endBoundaryBytes);
                    rsp = AliyunWebUtils.getResponseAsString(conn);
                }
                catch (IOException e) {
                    Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                    TaobaoLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), params);
                    throw e;
                }
                Object var19_22 = null;
                if (out == null) break block11;
            }
            catch (Throwable throwable) {
                Object var19_23 = null;
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
            out.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return AliyunWebUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = AliyunWebUtils.buildQuery(params, charset);
            try {
                conn = AliyunWebUtils.getConnection(AliyunWebUtils.buildGetUrl(url, query), METHOD_GET, ctype, null);
            }
            catch (IOException e) {
                Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                TaobaoLogger.logCommError((Exception)e, url, map.get("app_key"), map.get("method"), params);
                throw e;
            }
            try {
                rsp = AliyunWebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                Map<String, String> map = AliyunWebUtils.getParamsFromUrl(url);
                TaobaoLogger.logCommError((Exception)e, conn, map.get("app_key"), map.get("method"), params);
                throw e;
            }
            Object var10_11 = null;
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            SSLContext ctx = null;
            try {
                ctx = SSLContext.getInstance("TLS");
                ctx.init(new KeyManager[0], new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HttpsURLConnection connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setSSLSocketFactory(ctx.getSocketFactory());
            connHttps.setHostnameVerifier(new HostnameVerifier(){

                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestProperty("Accept", "text/xml,text/javascript,text/html");
        conn.setRequestProperty("User-Agent", "top-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static URL buildGetUrl(String strUrl, String query) throws IOException {
        URL url = new URL(strUrl);
        if (StringUtils.isEmpty(query)) {
            return url;
        }
        strUrl = StringUtils.isEmpty(url.getQuery()) ? (strUrl.endsWith("?") ? strUrl + query : strUrl + "?" + query) : (strUrl.endsWith("&") ? strUrl + query : strUrl + "&" + query);
        return new URL(strUrl);
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = AliyunWebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return AliyunWebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = AliyunWebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String string;
        block3: {
            try {
                InputStreamReader reader = new InputStreamReader(stream, charset);
                StringBuilder response = new StringBuilder();
                char[] buff = new char[1024];
                int read = 0;
                while ((read = reader.read(buff)) > 0) {
                    response.append(buff, 0, read);
                }
                string = response.toString();
                Object var8_7 = null;
                if (stream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (stream == null) break block4;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return string;
    }

    private static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return AliyunWebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return AliyunWebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    private static Map<String, String> getParamsFromUrl(String url) {
        Map<Object, Object> map = null;
        if (url != null && url.indexOf(63) != -1) {
            map = AliyunWebUtils.splitUrlQuery(url.substring(url.indexOf(63) + 1));
        }
        if (map == null) {
            map = new HashMap();
        }
        return map;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

