/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.remoting;

import com.taobao.top.link.remoting.MethodCall;
import com.taobao.top.link.remoting.MethodCallContext;
import com.taobao.top.link.remoting.MethodCallContextBean;
import com.taobao.top.link.remoting.MethodCallProcessor;
import com.taobao.top.link.remoting.MethodReturn;
import com.taobao.top.link.remoting.ServiceBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.springframework.beans.factory.ListableBeanFactory;

public class SpringMethodCallProcessor
implements MethodCallProcessor {
    private HashMap<String, Object> services = new HashMap();

    public SpringMethodCallProcessor(ListableBeanFactory beanFactory) {
        this.readServices(beanFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodReturn process(MethodCall methodCall, MethodCallContext callContext) throws Throwable {
        MethodReturn methodReturn;
        try {
            MethodCallContextBean.setCurrentContext(callContext);
            Object target = this.services.get(methodCall.TypeName);
            MethodReturn methodReturn2 = new MethodReturn();
            methodReturn2.ReturnValue = this.getMethod(target, methodCall).invoke(target, methodCall.Args);
            methodReturn = methodReturn2;
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            MethodCallContextBean.setCurrentContext(null);
            throw throwable;
        }
        MethodCallContextBean.setCurrentContext(null);
        return methodReturn;
    }

    public void register(String serviceInterface, Object serviceObject) {
        this.services.put(serviceInterface, serviceObject);
    }

    private void readServices(ListableBeanFactory beanFactory) {
        String[] names;
        for (String n : names = beanFactory.getBeanNamesForType(ServiceBean.class)) {
            ServiceBean s = (ServiceBean)beanFactory.getBean(n);
            this.register(s.getInterfaceName(), s.getTarget());
        }
    }

    private Method getMethod(Object target, MethodCall methodCall) throws SecurityException, NoSuchMethodException {
        try {
            return target.getClass().getMethod(methodCall.MethodName, methodCall.MethodSignature);
        }
        catch (NoSuchMethodException e) {
            return target.getClass().getMethod(methodCall.MethodName, new Class[0]);
        }
    }
}

