/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.State;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class HighLevelEncoder {
    static final String[] MODE_NAMES = new String[]{"UPPER", "LOWER", "DIGIT", "MIXED", "PUNCT"};
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE;
    private static final int[][] CHAR_MAP;
    static final int[][] SHIFT_TABLE;
    private final byte[] text;

    static {
        int[][] nArrayArray = new int[5][];
        int[] nArray = new int[5];
        nArray[1] = 327708;
        nArray[2] = 327710;
        nArray[3] = 327709;
        nArray[4] = 656318;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[5];
        nArray2[0] = 590318;
        nArray2[2] = 327710;
        nArray2[3] = 327709;
        nArray2[4] = 656318;
        nArrayArray[1] = nArray2;
        int[] nArray3 = new int[5];
        nArray3[0] = 262158;
        nArray3[1] = 590300;
        nArray3[3] = 590301;
        nArray3[4] = 932798;
        nArrayArray[2] = nArray3;
        int[] nArray4 = new int[5];
        nArray4[0] = 327709;
        nArray4[1] = 327708;
        nArray4[2] = 656318;
        nArray4[4] = 327710;
        nArrayArray[3] = nArray4;
        int[] nArray5 = new int[5];
        nArray5[0] = 327711;
        nArray5[1] = 656380;
        nArray5[2] = 656382;
        nArray5[3] = 656381;
        nArrayArray[4] = nArray5;
        LATCH_TABLE = nArrayArray;
        CHAR_MAP = new int[5][256];
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        int c = 65;
        while (c <= 90) {
            HighLevelEncoder.CHAR_MAP[0][c] = c - 65 + 2;
            ++c;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        c = 97;
        while (c <= 122) {
            HighLevelEncoder.CHAR_MAP[1][c] = c - 97 + 2;
            ++c;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        c = 48;
        while (c <= 57) {
            HighLevelEncoder.CHAR_MAP[2][c] = c - 48 + 2;
            ++c;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        int[] nArray6 = new int[28];
        nArray6[1] = 32;
        nArray6[2] = 1;
        nArray6[3] = 2;
        nArray6[4] = 3;
        nArray6[5] = 4;
        nArray6[6] = 5;
        nArray6[7] = 6;
        nArray6[8] = 7;
        nArray6[9] = 8;
        nArray6[10] = 9;
        nArray6[11] = 10;
        nArray6[12] = 11;
        nArray6[13] = 12;
        nArray6[14] = 13;
        nArray6[15] = 27;
        nArray6[16] = 28;
        nArray6[17] = 29;
        nArray6[18] = 30;
        nArray6[19] = 31;
        nArray6[20] = 64;
        nArray6[21] = 92;
        nArray6[22] = 94;
        nArray6[23] = 95;
        nArray6[24] = 96;
        nArray6[25] = 124;
        nArray6[26] = 126;
        nArray6[27] = 127;
        int[] mixedTable = nArray6;
        int i = 0;
        while (i < mixedTable.length) {
            HighLevelEncoder.CHAR_MAP[3][mixedTable[i]] = i;
            ++i;
        }
        int[] nArray7 = new int[31];
        nArray7[1] = 13;
        nArray7[6] = 33;
        nArray7[7] = 39;
        nArray7[8] = 35;
        nArray7[9] = 36;
        nArray7[10] = 37;
        nArray7[11] = 38;
        nArray7[12] = 39;
        nArray7[13] = 40;
        nArray7[14] = 41;
        nArray7[15] = 42;
        nArray7[16] = 43;
        nArray7[17] = 44;
        nArray7[18] = 45;
        nArray7[19] = 46;
        nArray7[20] = 47;
        nArray7[21] = 58;
        nArray7[22] = 59;
        nArray7[23] = 60;
        nArray7[24] = 61;
        nArray7[25] = 62;
        nArray7[26] = 63;
        nArray7[27] = 91;
        nArray7[28] = 93;
        nArray7[29] = 123;
        nArray7[30] = 125;
        int[] punctTable = nArray7;
        int i2 = 0;
        while (i2 < punctTable.length) {
            if (punctTable[i2] > 0) {
                HighLevelEncoder.CHAR_MAP[4][punctTable[i2]] = i2;
            }
            ++i2;
        }
        int[][] nArray8 = SHIFT_TABLE = new int[6][6];
        int n = SHIFT_TABLE.length;
        int n2 = 0;
        while (n2 < n) {
            int[] table = nArray8[n2];
            Arrays.fill(table, -1);
            ++n2;
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }

    public HighLevelEncoder(byte[] text) {
        this.text = text;
    }

    public BitArray encode() {
        Collection<State> states = Collections.singletonList(State.INITIAL_STATE);
        int index = 0;
        while (index < this.text.length) {
            int pairCode;
            byte nextChar = index + 1 < this.text.length ? this.text[index + 1] : (byte)0;
            switch (this.text[index]) {
                case 13: {
                    pairCode = nextChar == 10 ? 2 : 0;
                    break;
                }
                case 46: {
                    pairCode = nextChar == 32 ? 3 : 0;
                    break;
                }
                case 44: {
                    pairCode = nextChar == 32 ? 4 : 0;
                    break;
                }
                case 58: {
                    pairCode = nextChar == 32 ? 5 : 0;
                    break;
                }
                default: {
                    pairCode = 0;
                }
            }
            if (pairCode > 0) {
                states = HighLevelEncoder.updateStateListForPair(states, index, pairCode);
                ++index;
            } else {
                states = this.updateStateListForChar(states, index);
            }
            ++index;
        }
        State minState = Collections.min(states, new Comparator<State>(){

            @Override
            public int compare(State a, State b) {
                return a.getBitCount() - b.getBitCount();
            }
        });
        return minState.toBitArray(this.text);
    }

    private Collection<State> updateStateListForChar(Iterable<State> states, int index) {
        LinkedList<State> result = new LinkedList<State>();
        for (State state : states) {
            this.updateStateForChar(state, index, result);
        }
        return HighLevelEncoder.simplifyStates(result);
    }

    private void updateStateForChar(State state, int index, Collection<State> result) {
        char ch = (char)(this.text[index] & 0xFF);
        boolean charInCurrentTable = CHAR_MAP[state.getMode()][ch] > 0;
        State stateNoBinary = null;
        int mode = 0;
        while (mode <= 4) {
            int charInMode = CHAR_MAP[mode][ch];
            if (charInMode > 0) {
                if (stateNoBinary == null) {
                    stateNoBinary = state.endBinaryShift(index);
                }
                if (!charInCurrentTable || mode == state.getMode() || mode == 2) {
                    State latch_state = stateNoBinary.latchAndAppend(mode, charInMode);
                    result.add(latch_state);
                }
                if (!charInCurrentTable && SHIFT_TABLE[state.getMode()][mode] >= 0) {
                    State shift_state = stateNoBinary.shiftAndAppend(mode, charInMode);
                    result.add(shift_state);
                }
            }
            ++mode;
        }
        if (state.getBinaryShiftByteCount() > 0 || CHAR_MAP[state.getMode()][ch] == 0) {
            State binaryState = state.addBinaryShiftChar(index);
            result.add(binaryState);
        }
    }

    private static Collection<State> updateStateListForPair(Iterable<State> states, int index, int pairCode) {
        LinkedList<State> result = new LinkedList<State>();
        for (State state : states) {
            HighLevelEncoder.updateStateForPair(state, index, pairCode, result);
        }
        return HighLevelEncoder.simplifyStates(result);
    }

    private static void updateStateForPair(State state, int index, int pairCode, Collection<State> result) {
        State stateNoBinary = state.endBinaryShift(index);
        result.add(stateNoBinary.latchAndAppend(4, pairCode));
        if (state.getMode() != 4) {
            result.add(stateNoBinary.shiftAndAppend(4, pairCode));
        }
        if (pairCode == 3 || pairCode == 4) {
            State digit_state = stateNoBinary.latchAndAppend(2, 16 - pairCode).latchAndAppend(2, 1);
            result.add(digit_state);
        }
        if (state.getBinaryShiftByteCount() > 0) {
            State binaryState = state.addBinaryShiftChar(index).addBinaryShiftChar(index + 1);
            result.add(binaryState);
        }
    }

    private static Collection<State> simplifyStates(Iterable<State> states) {
        LinkedList<State> result = new LinkedList<State>();
        for (State newState : states) {
            boolean add = true;
            Iterator iterator = result.iterator();
            while (iterator.hasNext()) {
                State oldState = (State)iterator.next();
                if (oldState.isBetterThanOrEqualTo(newState)) {
                    add = false;
                    break;
                }
                if (!newState.isBetterThanOrEqualTo(oldState)) continue;
                iterator.remove();
            }
            if (!add) continue;
            result.add(newState);
        }
        return result;
    }
}

