/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.kaptcha.impl;

import com.google.code.kaptcha.BackgroundProducer;
import com.google.code.kaptcha.util.Configurable;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class DefaultBackground
extends Configurable
implements BackgroundProducer {
    public BufferedImage addBackground(BufferedImage baseImage) {
        Color colorFrom = this.getConfig().getBackgroundColorFrom();
        Color colorTo = this.getConfig().getBackgroundColorTo();
        int width = baseImage.getWidth();
        int height = baseImage.getHeight();
        BufferedImage imageWithBackground = new BufferedImage(width, height, 1);
        Graphics2D graph = (Graphics2D)imageWithBackground.getGraphics();
        RenderingHints hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        hints.add(new RenderingHints(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY));
        hints.add(new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY));
        graph.setRenderingHints(hints);
        GradientPaint paint = new GradientPaint(0.0f, 0.0f, colorFrom, width, height, colorTo);
        graph.setPaint(paint);
        graph.fill(new Rectangle2D.Double(0.0, 0.0, width, height));
        graph.drawImage((Image)baseImage, 0, 0, null);
        return imageWithBackground;
    }
}

