/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.CommonParams;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JSCallback;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.PackagerLib;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;

public class Main {
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private static final String version = bundle.getString("MSG_Version") + " " + "8.0" + "\n";
    private static final String help = bundle.getString("MSG_Help_1") + bundle.getString("MSG_Help_2") + bundle.getString("MSG_Help_3") + bundle.getString("MSG_Help_4") + bundle.getString("MSG_Help_5") + bundle.getString("MSG_Help_6") + bundle.getString("MSG_Help_7");
    private static boolean verbose = false;
    private static boolean packageAsJar = false;
    private static boolean genJNLP = false;
    private static boolean css2Bin = false;
    private static boolean signJar = false;
    private static boolean makeAll = false;

    private static String nextArg(String[] stringArray, int n) {
        return n == stringArray.length - 1 ? "" : stringArray[n + 1];
    }

    private static void addResources(CommonParams commonParams, File file, String string) {
        String[] stringArray;
        if (string == null || "".equals(string)) {
            return;
        }
        for (String string2 : stringArray = string.split(File.pathSeparator)) {
            commonParams.addResource(file, string2);
        }
    }

    private static void addArgument(DeployParams deployParams, String string) {
        if (deployParams.arguments != null) {
            deployParams.arguments.add(string);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            deployParams.setArguments(linkedList);
        }
    }

    private static void addArgument(CreateJarParams createJarParams, String string) {
        if (createJarParams.arguments != null) {
            createJarParams.arguments.add(string);
        } else {
            LinkedList<String> linkedList = new LinkedList<String>();
            linkedList.add(string);
            createJarParams.setArguments(linkedList);
        }
    }

    private static Map<String, String> createAttrMap(String string) {
        String[] stringArray;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string == null || "".equals(string)) {
            return null;
        }
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("=");
            hashMap.put(stringArray2[0].trim(), stringArray2[1].trim());
        }
        return hashMap;
    }

    private static List<Param> parseParams(String string) throws IOException {
        File file = new File(string);
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        fileInputStream.close();
        ArrayList<Param> arrayList = new ArrayList<Param>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            Param param = new Param();
            param.setName((String)entry.getKey());
            param.setValue((String)entry.getValue());
            arrayList.add(param);
        }
        return arrayList;
    }

    private static List<HtmlParam> parseHtmlParams(String string) throws IOException {
        File file = new File(string);
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(file);
        properties.load(fileInputStream);
        fileInputStream.close();
        ArrayList<HtmlParam> arrayList = new ArrayList<HtmlParam>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            HtmlParam htmlParam = new HtmlParam();
            htmlParam.setName((String)entry.getKey());
            htmlParam.setValue((String)entry.getValue());
            arrayList.add(htmlParam);
        }
        return arrayList;
    }

    private static List<JSCallback> parseCallbacks(String string) {
        String[] stringArray = string.split(",");
        ArrayList<JSCallback> arrayList = new ArrayList<JSCallback>(stringArray.length);
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split(":");
            if (stringArray2.length != 2) continue;
            arrayList.add(new JSCallback(stringArray2[0], stringArray2[1]));
        }
        return arrayList;
    }

    public static void main(String ... stringArray) throws Exception {
        if (stringArray.length == 0 || stringArray.length == 1 && stringArray[0].equals("-help")) {
            System.out.println(help);
        } else if (stringArray.length == 1 && stringArray[0].equals("-version")) {
            System.out.println(version);
        } else {
            PackagerLib packagerLib = new PackagerLib();
            CreateJarParams createJarParams = new CreateJarParams();
            DeployParams deployParams = new DeployParams();
            CreateBSSParams createBSSParams = new CreateBSSParams();
            SignJarParams signJarParams = new SignJarParams();
            MakeAllParams makeAllParams = new MakeAllParams();
            File file = null;
            try {
                if (stringArray[0].equalsIgnoreCase("-createjar")) {
                    boolean bl = false;
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.equalsIgnoreCase("-appclass")) {
                            createJarParams.setApplicationClass(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-preloader")) {
                            createJarParams.setPreloader(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-classpath")) {
                            createJarParams.setClasspath(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-manifestAttrs")) {
                            createJarParams.setManifestAttrs(Main.createAttrMap(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-noembedlauncher")) {
                            System.out.println("-noembedlauncher is deprecated");
                            continue;
                        }
                        if (string.equalsIgnoreCase("-nocss2bin")) {
                            createJarParams.setCss2bin(false);
                            continue;
                        }
                        if (string.equalsIgnoreCase("-runtimeVersion")) {
                            createJarParams.setFxVersion(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                            createJarParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (string.equalsIgnoreCase("-outdir")) {
                            createJarParams.setOutdir(new File(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-outfile")) {
                            createJarParams.setOutfile(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcdir")) {
                            file = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(createJarParams, file, Main.nextArg(stringArray, i++));
                            bl = true;
                            continue;
                        }
                        if (string.equalsIgnoreCase("-argument")) {
                            Main.addArgument(createJarParams, Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-paramFile")) {
                            createJarParams.setParams(Main.parseParams(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        throw new PackagerException("ERR_UnknownArgument", string);
                    }
                    if (file != null && !file.isDirectory()) {
                        throw new PackagerException("ERR_InvalidDirectory", file.getAbsolutePath());
                    }
                    if (!bl) {
                        if (file == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(createJarParams, file, ".");
                    }
                    packageAsJar = true;
                } else if (stringArray[0].equalsIgnoreCase("-deploy")) {
                    boolean bl = false;
                    File file2 = null;
                    File file3 = null;
                    deployParams.setEmbedJNLP(false);
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string;
                        Object object;
                        String string2 = stringArray[i];
                        if (string2.startsWith("-B")) {
                            int n = 2;
                            int n2 = string2.indexOf("=");
                            int n3 = string2.length();
                            if (n2 < n) {
                                if (n >= n3) continue;
                                object = string2.substring(n, n3);
                                string = Boolean.TRUE.toString();
                            } else {
                                if (n >= n2) continue;
                                object = string2.substring(n, n2);
                                string = string2.substring(n2 + 1, n3);
                            }
                            deployParams.addBundleArgument((String)object, string);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-title")) {
                            deployParams.setTitle(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-vendor")) {
                            deployParams.setVendor(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-native")) {
                            object = Bundler.BundleType.ALL;
                            string = null;
                            if (i + 1 < stringArray.length && !stringArray[i + 1].startsWith("-")) {
                                String string3;
                                if ("image".equals(string3 = stringArray[++i])) {
                                    object = Bundler.BundleType.IMAGE;
                                } else if ("installer".equals(string3)) {
                                    object = Bundler.BundleType.INSTALLER;
                                } else {
                                    object = Bundler.BundleType.INSTALLER;
                                    string = string3 != null ? string3.toLowerCase() : null;
                                }
                            }
                            deployParams.setBundleType((Bundler.BundleType)((Object)object));
                            deployParams.setTargetFormat(string);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-description")) {
                            deployParams.setDescription(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-appclass")) {
                            deployParams.setApplicationClass(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-daemon")) {
                            deployParams.setServiceHint(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-preloader")) {
                            deployParams.setPreloader(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-paramFile")) {
                            deployParams.setParams(Main.parseParams(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-htmlParamFile")) {
                            deployParams.setHtmlParams(Main.parseHtmlParams(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-width")) {
                            deployParams.setWidth(Integer.parseInt(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-height")) {
                            deployParams.setHeight(Integer.parseInt(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-name")) {
                            deployParams.setAppName(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-embedJNLP")) {
                            deployParams.setEmbedJNLP(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-embedCertificates")) {
                            System.out.println("-embedCertificates is deprecated");
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-allpermissions")) {
                            deployParams.setAllPermissions(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-updatemode")) {
                            deployParams.setUpdateMode(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-isExtension")) {
                            deployParams.setExtension(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-callbacks")) {
                            deployParams.setJSCallbacks(Main.parseCallbacks(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-templateInFilename")) {
                            file2 = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-templateOutFilename")) {
                            file3 = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-appId")) {
                            object = Main.nextArg(stringArray, i++);
                            deployParams.setAppId((String)object);
                            deployParams.setId((String)object);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-verbose") || string2.equalsIgnoreCase("-v")) {
                            deployParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-includedt")) {
                            deployParams.setIncludeDT(true);
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-outdir")) {
                            deployParams.setOutdir(new File(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-outfile")) {
                            deployParams.setOutfile(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-srcdir")) {
                            file = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(deployParams, file, Main.nextArg(stringArray, i++));
                            bl = true;
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-argument")) {
                            Main.addArgument(deployParams, Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string2.equalsIgnoreCase("-nosign")) {
                            deployParams.setSignBundle(false);
                            continue;
                        }
                        throw new PackagerException("ERR_UnknownArgument", string2);
                    }
                    if (file2 != null) {
                        deployParams.addTemplate(file2, file3);
                    }
                    if (file != null && !file.isDirectory()) {
                        throw new PackagerException("ERR_InvalidDirectory", file.getAbsolutePath());
                    }
                    if (!bl) {
                        if (file == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(deployParams, file, ".");
                    }
                    genJNLP = true;
                } else if (stringArray[0].equalsIgnoreCase("-createbss")) {
                    boolean bl = false;
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                            createBSSParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (string.equalsIgnoreCase("-outdir")) {
                            createBSSParams.setOutdir(new File(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcdir")) {
                            file = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(createBSSParams, file, Main.nextArg(stringArray, i++));
                            bl = true;
                            continue;
                        }
                        throw new PackagerException("ERR_UnknownArgument", string);
                    }
                    if (file != null && !file.isDirectory()) {
                        throw new PackagerException("ERR_InvalidDirectory", file.getAbsolutePath());
                    }
                    if (!bl) {
                        if (file == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(createBSSParams, file, ".");
                    }
                    css2Bin = true;
                } else if (stringArray[0].equalsIgnoreCase("-signJar")) {
                    boolean bl = false;
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.equalsIgnoreCase("-keyStore")) {
                            signJarParams.setKeyStore(new File(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-alias")) {
                            signJarParams.setAlias(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-storePass")) {
                            signJarParams.setStorePass(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-keyPass")) {
                            signJarParams.setKeyPass(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-storeType")) {
                            signJarParams.setStoreType(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-verbose") || string.equalsIgnoreCase("-v")) {
                            signJarParams.setVerbose(true);
                            verbose = true;
                            continue;
                        }
                        if (string.equalsIgnoreCase("-outdir")) {
                            signJarParams.setOutdir(new File(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcdir")) {
                            file = new File(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-srcfiles")) {
                            Main.addResources(signJarParams, file, Main.nextArg(stringArray, i++));
                            bl = true;
                            continue;
                        }
                        throw new PackagerException("ERR_UnknownArgument", string);
                    }
                    if (file != null && !file.isDirectory()) {
                        throw new PackagerException("ERR_InvalidDirectory", file.getAbsolutePath());
                    }
                    if (!bl) {
                        if (file == null) {
                            throw new PackagerException("ERR_MissingArgument", "-srcfiles (-srcdir)");
                        }
                        Main.addResources(signJarParams, file, ".");
                    }
                    signJar = true;
                } else if (stringArray[0].equalsIgnoreCase("-makeall")) {
                    for (int i = 1; i < stringArray.length; ++i) {
                        String string = stringArray[i];
                        if (string.equalsIgnoreCase("-appclass")) {
                            makeAllParams.setAppClass(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-preloader")) {
                            makeAllParams.setPreloader(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-classpath")) {
                            makeAllParams.setClasspath(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-name")) {
                            makeAllParams.setAppName(Main.nextArg(stringArray, i++));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-width")) {
                            makeAllParams.setWidth(Integer.parseInt(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-height")) {
                            makeAllParams.setHeight(Integer.parseInt(Main.nextArg(stringArray, i++)));
                            continue;
                        }
                        if (string.equalsIgnoreCase("-v")) {
                            makeAllParams.setVerbose(true);
                            continue;
                        }
                        throw new PackagerException("ERR_UnknownArgument", string);
                    }
                    makeAll = true;
                } else if (stringArray[0].equalsIgnoreCase("-help")) {
                    Main.showBundlerHelp(stringArray[1], stringArray.length > 2 && "-verbose".equals(stringArray[2]));
                } else {
                    System.err.println(MessageFormat.format(bundle.getString("ERR_UnknownCommand"), stringArray[0]));
                    System.exit(-1);
                }
                if (verbose) {
                    Log.setLogger(new Log.Logger(true));
                } else {
                    Log.setLogger(new Log.Logger(false));
                }
                if (css2Bin) {
                    createBSSParams.validate();
                    packagerLib.generateBSS(createBSSParams);
                }
                if (packageAsJar) {
                    createJarParams.validate();
                    packagerLib.packageAsJar(createJarParams);
                }
                if (genJNLP) {
                    deployParams.validate();
                    packagerLib.generateDeploymentPackages(deployParams);
                }
                if (signJar) {
                    signJarParams.validate();
                    packagerLib.signJar(signJarParams);
                }
                if (makeAll) {
                    makeAllParams.validate();
                    packagerLib.makeAll(makeAllParams);
                }
            }
            catch (Exception exception) {
                if (verbose) {
                    throw exception;
                }
                System.err.println(exception.getMessage());
                if (exception.getCause() != null && exception.getCause() != exception) {
                    System.err.println(exception.getCause().getMessage());
                }
                System.exit(-1);
            }
        }
    }

    public static void showBundlerHelp(String string, boolean bl) {
        if ("bundlers".equals(string)) {
            System.out.println("Known Bundlers -- \n");
            for (Bundler bundler : Bundlers.createBundlersInstance().getBundlers()) {
                try {
                    bundler.validate(new HashMap());
                }
                catch (UnsupportedPlatformException unsupportedPlatformException) {
                    continue;
                }
                catch (ConfigException configException) {
                    // empty catch block
                }
                if (bl) {
                    System.out.printf("%s - %s - %s\n\t%s\n", bundler.getID(), bundler.getName(), bundler.getBundleType(), bundler.getDescription());
                    continue;
                }
                System.out.printf("%s - %s - %s\n", bundler.getID(), bundler.getName(), bundler.getBundleType());
            }
        } else {
            for (Bundler bundler : Bundlers.createBundlersInstance().getBundlers()) {
                if (!bundler.getID().equals(string)) continue;
                System.out.printf("Bundler Parameters for %s (%s) --\n", bundler.getName(), bundler.getID());
                for (BundlerParamInfo<?> bundlerParamInfo : bundler.getBundleParameters()) {
                    if (bundlerParamInfo.getStringConverter() == null) continue;
                    if (bl) {
                        System.out.printf("%s - %s - %s\n\t%s\n", bundlerParamInfo.getID(), bundlerParamInfo.getName(), bundlerParamInfo.getValueType().getSimpleName(), bundlerParamInfo.getDescription());
                        continue;
                    }
                    System.out.printf("%s - %s - %s\n", bundlerParamInfo.getID(), bundlerParamInfo.getName(), bundlerParamInfo.getValueType().getSimpleName());
                }
                return;
            }
            System.out.printf("Sorry, no bundler matching the id %s was found.\n", string);
        }
    }
}

