/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;

public class MacPkgBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacPkgBundler.class.getName());
    public static final String MAC_BUNDLER_PREFIX = "package/macosx" + File.separator;
    private static final String DEFAULT_BACKGROUND_IMAGE = "background_pkg.png";
    private static final String TEMPLATE_PREINSTALL_SCRIPT = "preinstall.template";
    private static final String TEMPLATE_POSTINSTALL_SCRIPT = "postinstall.template";
    private static final BundlerParamInfo<File> PACKAGES_ROOT = new StandardBundlerParam<File>(I18N.getString("param.packages-root.name"), I18N.getString("param.packages-root.description"), "mac.pkg.packagesRoot", File.class, map -> {
        File file = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "packages");
        file.mkdirs();
        return file;
    }, (string, map) -> new File((String)string));
    protected final BundlerParamInfo<File> SCRIPTS_DIR = new StandardBundlerParam<File>(I18N.getString("param.scripts-dir.name"), I18N.getString("param.scripts-dir.description"), "mac.pkg.scriptsDir", File.class, map -> {
        File file = new File((File)CONFIG_ROOT.fetchFrom((Map<String, ? super Object>)map), "scripts");
        file.mkdirs();
        return file;
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<String> DEVELOPER_ID_INSTALLER_SIGNING_KEY = new StandardBundlerParam<String>(I18N.getString("param.signing-key-developer-id-installer.name"), I18N.getString("param.signing-key-developer-id-installer.description"), "mac.signing-key-developer-id-installer", String.class, map -> MacBaseInstallerBundler.findKey("Developer ID Installer: " + (String)SIGNING_KEY_USER.fetchFrom((Map<String, ? super Object>)map), (Boolean)StandardBundlerParam.VERBOSE.fetchFrom((Map<String, Object>)map)), (string, map) -> string);

    public MacPkgBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block37: {
            File file3;
            Log.info(MessageFormat.format(I18N.getString("message.building-pkg"), StandardBundlerParam.APP_NAME.fetchFrom(map)));
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            file2 = null;
            file2 = this.prepareAppBundle(map);
            if (file2 == null || !this.prepareConfigFiles(map)) break block37;
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                file3 = (File)this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(map);
                file3.mkdirs();
                this.prepareDaemonBundle(map);
            }
            if ((file3 = this.getConfig_Script(map)).exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-script"), file3.getAbsolutePath()));
                IOUtils.run("bash", file3, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            }
            File file4 = this.createPKG(map, file, file2);
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.cleanupConfigFiles(map);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.debug(fileNotFoundException);
                return null;
            }
            return file4;
        }
        File file5 = null;
        try {
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.cleanupConfigFiles(map);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.debug(fileNotFoundException);
            return null;
        }
        return file5;
        catch (IOException iOException) {
            File file6;
            try {
                Log.verbose(iOException);
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.cleanupConfigFiles(map);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.debug(fileNotFoundException);
                    return null;
                }
                throw throwable;
            }
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.cleanupConfigFiles(map);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.debug(fileNotFoundException);
                return null;
            }
            return file6;
        }
    }

    private File getPackages_AppPackage(Map<String, ? super Object> map) {
        return new File(PACKAGES_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + "-app.pkg");
    }

    private File getPackages_DaemonPackage(Map<String, ? super Object> map) {
        return new File(PACKAGES_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + "-daemon.pkg");
    }

    private void cleanupPackagesFiles(Map<String, ? super Object> map) {
        if (this.getPackages_AppPackage(map) != null) {
            this.getPackages_AppPackage(map).delete();
        }
        if (this.getPackages_DaemonPackage(map) != null) {
            this.getPackages_DaemonPackage(map).delete();
        }
    }

    private File getConfig_DistributionXMLFile(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), "distribution.dist");
    }

    private File getConfig_BackgroundImage(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-background.png");
    }

    private File getScripts_PreinstallFile(Map<String, ? super Object> map) {
        return new File(this.SCRIPTS_DIR.fetchFrom(map), "preinstall");
    }

    private File getScripts_PostinstallFile(Map<String, ? super Object> map) {
        return new File(this.SCRIPTS_DIR.fetchFrom(map), "postinstall");
    }

    private void cleanupPackageScripts(Map<String, ? super Object> map) {
        if (this.getScripts_PreinstallFile(map) != null) {
            this.getScripts_PreinstallFile(map).delete();
        }
        if (this.getScripts_PostinstallFile(map) != null) {
            this.getScripts_PostinstallFile(map).delete();
        }
    }

    private void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (this.getConfig_DistributionXMLFile(map) != null) {
            this.getConfig_DistributionXMLFile(map).delete();
        }
        if (this.getConfig_BackgroundImage(map) != null) {
            this.getConfig_BackgroundImage(map).delete();
        }
    }

    private String getAppIdentifier(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map);
    }

    private String getDaemonIdentifier(Map<String, ? super Object> map) {
        return (String)StandardBundlerParam.IDENTIFIER.fetchFrom(map) + ".daemon";
    }

    private void preparePackageScripts(Map<String, ? super Object> map) throws IOException {
        Log.verbose(I18N.getString("message.preparing-scripts"));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEPLOY_DAEMON_IDENTIFIER", this.getDaemonIdentifier(map));
        hashMap.put("DEPLOY_LAUNCHD_PLIST_FILE", ((String)StandardBundlerParam.IDENTIFIER.fetchFrom(map)).toLowerCase() + ".launchd.plist");
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getScripts_PreinstallFile(map)));
        String string = this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getScripts_PreinstallFile(map).getName(), I18N.getString("resource.pkg-preinstall-script"), TEMPLATE_PREINSTALL_SCRIPT, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.getScripts_PreinstallFile(map).setExecutable(true, false);
        bufferedWriter = new BufferedWriter(new FileWriter(this.getScripts_PostinstallFile(map)));
        string = this.preprocessTextResource(MAC_BUNDLER_PREFIX + this.getScripts_PostinstallFile(map).getName(), I18N.getString("resource.pkg-postinstall-script"), TEMPLATE_POSTINSTALL_SCRIPT, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        bufferedWriter.write(string);
        ((Writer)bufferedWriter).close();
        this.getScripts_PostinstallFile(map).setExecutable(true, false);
    }

    private void prepareDistributionXMLFile(Map<String, ? super Object> map) throws IOException {
        Object object;
        File file = this.getConfig_DistributionXMLFile(map);
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-distribution-dist"), file.getAbsolutePath()));
        PrintStream printStream = new PrintStream(file);
        printStream.println("<?xml version=\"1.0\" encoding=\"utf-8\" standalone=\"no\"?>");
        printStream.println("<installer-gui-script minSpecVersion=\"1\">");
        printStream.println("<title>" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "</title>");
        printStream.println("<background file=\"" + this.getConfig_BackgroundImage(map).getName() + "\"" + " mime-type=\"image/png\"" + " alignment=\"bottomleft\" " + " scaling=\"none\"" + "/>");
        if (!((List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)).isEmpty()) {
            object = new File(((RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map)).getBaseDirectory(), (String)((List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)).get(0));
            printStream.println("<license file=\"" + ((File)object).getAbsolutePath() + "\"" + " mime-type=\"text/rtf\"" + "/>");
        }
        object = this.getAppIdentifier(map);
        String string = this.getDaemonIdentifier(map);
        printStream.println("<pkg-ref id=\"" + (String)object + "\"/>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            printStream.println("<pkg-ref id=\"" + string + "\"/>");
        }
        printStream.println("<options customize=\"never\" require-scripts=\"false\"/>");
        printStream.println("<choices-outline>");
        printStream.println("    <line choice=\"default\">");
        printStream.println("        <line choice=\"" + (String)object + "\"/>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            printStream.println("        <line choice=\"" + string + "\"/>");
        }
        printStream.println("    </line>");
        printStream.println("</choices-outline>");
        printStream.println("<choice id=\"default\"/>");
        printStream.println("<choice id=\"" + (String)object + "\" visible=\"false\">");
        printStream.println("    <pkg-ref id=\"" + (String)object + "\"/>");
        printStream.println("</choice>");
        printStream.println("<pkg-ref id=\"" + (String)object + "\" version=\"" + (String)StandardBundlerParam.VERSION.fetchFrom(map) + "\" onConclusion=\"none\">" + URLEncoder.encode(this.getPackages_AppPackage(map).getName(), "UTF-8") + "</pkg-ref>");
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            printStream.println("<choice id=\"" + string + "\" visible=\"false\">");
            printStream.println("    <pkg-ref id=\"" + string + "\"/>");
            printStream.println("</choice>");
            printStream.println("<pkg-ref id=\"" + string + "\" version=\"" + (String)StandardBundlerParam.VERSION.fetchFrom(map) + "\" onConclusion=\"none\">" + URLEncoder.encode(this.getPackages_DaemonPackage(map).getName(), "UTF-8") + "</pkg-ref>");
        }
        printStream.println("</installer-gui-script>");
        printStream.close();
    }

    private boolean prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_BackgroundImage(map);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.pkg-background-image"), DEFAULT_BACKGROUND_IMAGE, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        this.prepareDistributionXMLFile(map);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_Script(map).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        return true;
    }

    private File getConfig_Script(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-post-image.sh");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createPKG(Map<String, ? super Object> map, File file, File file2) {
        try {
            Object object;
            String string = this.DAEMON_IMAGE_BUILD_ROOT.fetchFrom(map) + "/" + (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".daemon";
            File file3 = this.getPackages_AppPackage(map);
            File file4 = this.getPackages_DaemonPackage(map);
            ProcessBuilder processBuilder = new ProcessBuilder("pkgbuild", "--component", file2.toString(), "--install-location", "/Applications", file3.getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                this.preparePackageScripts(map);
                processBuilder = new ProcessBuilder("pkgbuild", "--identifier", (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + ".daemon", "--root", string, "--scripts", this.SCRIPTS_DIR.fetchFrom(map).getAbsolutePath(), file4.getAbsolutePath());
                IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            }
            File file5 = new File(file, (String)INSTALLER_NAME.fetchFrom(map) + ".pkg");
            file.mkdirs();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("productbuild");
            arrayList.add("--resources");
            arrayList.add(((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath());
            if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(map)).orElse(Boolean.TRUE).booleanValue() && (object = DEVELOPER_ID_INSTALLER_SIGNING_KEY.fetchFrom(map)) != null) {
                arrayList.add("--sign");
                arrayList.add((String)object);
            }
            arrayList.add("--distribution");
            arrayList.add(this.getConfig_DistributionXMLFile(map).getAbsolutePath());
            arrayList.add("--package-path");
            arrayList.add(PACKAGES_ROOT.fetchFrom(map).getAbsolutePath());
            arrayList.add(file5.getAbsolutePath());
            processBuilder = new ProcessBuilder(arrayList);
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            object = file5;
            return object;
        }
        catch (Exception exception) {
            Log.verbose(exception);
            File file6 = null;
            return file6;
        }
        finally {
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.cleanupPackagesFiles(map);
                this.cleanupConfigFiles(map);
                if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                    this.cleanupPackageScripts(map);
                }
            }
        }
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "pkg";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(this.getPKGBundleParameters());
        return linkedHashSet;
    }

    public Collection<BundlerParamInfo<?>> getPKGBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(Arrays.asList(DEVELOPER_ID_INSTALLER_SIGNING_KEY, StandardBundlerParam.LICENSE_FILE));
        return linkedHashSet;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            Object object;
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            this.validateAppImageAndBundeler(map);
            if (map.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                object = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
                for (String string : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    if (((RelativeFileSet)object).contains(string)) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), string, ((RelativeFileSet)object).getBaseDirectory().toString()));
                }
            }
            if (Optional.ofNullable(StandardBundlerParam.SIGN_BUNDLE.fetchFrom(map)).orElse(Boolean.FALSE).booleanValue() && (object = DEVELOPER_ID_INSTALLER_SIGNING_KEY.fetchFrom(map)) == null) {
                throw new ConfigException(I18N.getString("error.explicit-sign-no-cert"), I18N.getString("error.explicit-sign-no-cert.advice"));
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }
}

