/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.mac;

import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.mac.MacAppBundler;
import com.oracle.tools.packager.mac.MacBaseInstallerBundler;
import com.oracle.tools.packager.mac.MacResources;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import sun.misc.BASE64Encoder;

public class MacDmgBundler
extends MacBaseInstallerBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(MacDmgBundler.class.getName());
    static final String DEFAULT_BACKGROUND_IMAGE = "background_dmg.png";
    static final String DEFAULT_DMG_SETUP_SCRIPT = "DMGsetup.scpt";
    static final String TEMPLATE_BUNDLE_ICON = "GenericApp.icns";
    static final String DEFAULT_LICENSE_PLIST = "lic_template.plist";
    public static final BundlerParamInfo<Boolean> SIMPLE_DMG = new StandardBundlerParam<Boolean>(I18N.getString("param.simple-dmg.name"), I18N.getString("param.simple-dmg.description"), "mac.dmg.simple", Boolean.class, map -> Boolean.FALSE, (string, map) -> Boolean.parseBoolean(string));
    private static final String hdiutil = "/usr/bin/hdiutil";

    public MacDmgBundler() {
        this.baseResourceLoader = MacResources.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block36: {
            Log.info(MessageFormat.format(I18N.getString("message.building-dmg"), StandardBundlerParam.APP_NAME.fetchFrom(map)));
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            file2 = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(map);
            file2.mkdirs();
            if (this.prepareAppBundle(map) == null || !this.prepareConfigFiles(map)) break block36;
            File file3 = this.getConfig_Script(map);
            if (file3.exists()) {
                Log.info(MessageFormat.format(I18N.getString("message.running-script"), file3.getAbsolutePath()));
                IOUtils.run("bash", file3, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            }
            File file4 = this.buildDMG(map, file);
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.cleanupConfigFiles(map);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.debug(fileNotFoundException);
                return null;
            }
            return file4;
        }
        File file5 = null;
        try {
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
            }
            if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.cleanupConfigFiles(map);
            } else {
                Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            Log.debug(fileNotFoundException);
            return null;
        }
        return file5;
        catch (IOException iOException) {
            File file6;
            try {
                Log.verbose(iOException);
                file6 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                    }
                    if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.cleanupConfigFiles(map);
                    } else {
                        Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Log.debug(fileNotFoundException);
                    return null;
                }
                throw throwable;
            }
            try {
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.intermediate-image-location"), file2.getAbsolutePath()));
                }
                if (!((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.cleanupConfigFiles(map);
                } else {
                    Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), ((File)CONFIG_ROOT.fetchFrom(map)).getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.debug(fileNotFoundException);
                return null;
            }
            return file6;
        }
    }

    protected void cleanupConfigFiles(Map<String, ? super Object> map) {
        if (this.getConfig_VolumeBackground(map) != null) {
            this.getConfig_VolumeBackground(map).delete();
        }
        if (this.getConfig_VolumeIcon(map) != null) {
            this.getConfig_VolumeIcon(map).delete();
        }
        if (this.getConfig_VolumeScript(map) != null) {
            this.getConfig_VolumeScript(map).delete();
        }
        if (this.getConfig_Script(map) != null) {
            this.getConfig_Script(map).delete();
        }
        if (this.getConfig_LicenseFile(map) != null) {
            this.getConfig_LicenseFile(map).delete();
        }
        ((MacAppBundler)APP_BUNDLER.fetchFrom(map)).cleanupConfigFiles(map);
    }

    private void prepareDMGSetupScript(String string, Map<String, ? super Object> map) throws IOException {
        boolean bl;
        File file = this.getConfig_VolumeScript(map);
        Log.verbose(MessageFormat.format(I18N.getString("message.preparing-dmg-setup"), file.getAbsolutePath()));
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("DEPLOY_ACTUAL_VOLUME_NAME", string);
        hashMap.put("DEPLOY_APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
        boolean bl2 = bl = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(map) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(map) != false;
        if (bl) {
            hashMap.put("DEPLOY_INSTALL_LOCATION", "POSIX file \"/Applications\"");
            hashMap.put("DEPLOY_INSTALL_NAME", "Applications");
        } else {
            hashMap.put("DEPLOY_INSTALL_LOCATION", "(path to desktop folder)");
            hashMap.put("DEPLOY_INSTALL_NAME", "Desktop");
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.dmg-setup-script"), DEFAULT_DMG_SETUP_SCRIPT, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map)));
        ((Writer)bufferedWriter).close();
    }

    private File getConfig_VolumeScript(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-dmg-setup.scpt");
    }

    private File getConfig_VolumeBackground(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-background.png");
    }

    private File getConfig_VolumeIcon(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-volume.icns");
    }

    private File getConfig_LicenseFile(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-license.plist");
    }

    private void prepareLicense(Map<String, ? super Object> map) {
        try {
            if (((List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)).isEmpty()) {
                return;
            }
            File file = new File(((RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map)).getBaseDirectory(), (String)((List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)).get(0));
            byte[] byArray = IOUtils.readFully(file);
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            String string = bASE64Encoder.encode(byArray);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("APPLICATION_LICENSE_TEXT", string);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(this.getConfig_LicenseFile(map)));
            bufferedWriter.write(this.preprocessTextResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_LicenseFile(map).getName(), I18N.getString("resource.license-setup"), DEFAULT_LICENSE_PLIST, hashMap, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map)));
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            Log.verbose(iOException);
        }
    }

    private boolean prepareConfigFiles(Map<String, ? super Object> map) throws IOException {
        File file = this.getConfig_VolumeBackground(map);
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + file.getName(), I18N.getString("resource.dmg-background"), DEFAULT_BACKGROUND_IMAGE, file, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        File file2 = this.getConfig_VolumeIcon(map);
        if (MacAppBundler.ICON_ICNS.fetchFrom(map) == null || !MacAppBundler.ICON_ICNS.fetchFrom(map).exists()) {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.volume-icon"), TEMPLATE_BUNDLE_ICON, file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        } else {
            this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.volume-icon"), MacAppBundler.ICON_ICNS.fetchFrom(map), file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        }
        this.fetchResource(MacAppBundler.MAC_BUNDLER_PREFIX + this.getConfig_Script(map).getName(), I18N.getString("resource.post-install-script"), (String)null, this.getConfig_Script(map), (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        this.prepareLicense(map);
        this.prepareDMGSetupScript((String)StandardBundlerParam.APP_NAME.fetchFrom(map), map);
        return true;
    }

    private File getConfig_Script(Map<String, ? super Object> map) {
        return new File((File)CONFIG_ROOT.fetchFrom(map), (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-post-image.sh");
    }

    private String findSetFileUtility() {
        Object object;
        String[] stringArray = new String[]{"/Developer/Tools/SetFile", "/usr/bin/SetFile", "/Developer/usr/bin/SetFile"};
        for (String object2 : stringArray) {
            object = new File(object2);
            if (!((File)object).exists() || !((File)object).canExecute()) continue;
            return object2;
        }
        try {
            File file;
            ProcessBuilder processBuilder = new ProcessBuilder("xcrun", "-find", "SetFile");
            Process process = processBuilder.start();
            InputStreamReader inputStreamReader = new InputStreamReader(process.getInputStream());
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            object = bufferedReader.readLine();
            if (object != null && (file = new File((String)object)).exists() && file.canExecute()) {
                return file.getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private File buildDMG(Map<String, ? super Object> map, File file) throws IOException {
        Object object;
        File file2 = (File)IMAGES_ROOT.fetchFrom(map);
        if (!file2.exists()) {
            file2.mkdirs();
        }
        File file3 = new File(file2, (String)StandardBundlerParam.APP_NAME.fetchFrom(map) + "-tmp.dmg");
        File file4 = new File(file, (String)INSTALLER_NAME.fetchFrom(map) + ".dmg");
        File file5 = (File)this.APP_IMAGE_BUILD_ROOT.fetchFrom(map);
        File file6 = MacDmgBundler.getPredefinedImage(map);
        if (file6 != null) {
            file5 = file6;
        }
        Log.verbose(MessageFormat.format(I18N.getString("message.creating-dmg-file"), file4.getAbsolutePath()));
        file3.delete();
        if (file4.exists() && !file4.delete()) {
            throw new IOException(MessageFormat.format(I18N.getString("message.dmg-cannot-be-overwritten"), file4.getAbsolutePath()));
        }
        file3.getParentFile().mkdirs();
        file4.getParentFile().mkdirs();
        String string = Log.isDebug() ? "-verbose" : "-quiet";
        ProcessBuilder processBuilder = new ProcessBuilder(hdiutil, "create", string, "-srcfolder", file5.getAbsolutePath(), "-volname", (String)StandardBundlerParam.APP_NAME.fetchFrom(map), "-ov", file3.getAbsolutePath(), "-format", "UDRW");
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        processBuilder = new ProcessBuilder(hdiutil, "attach", file3.getAbsolutePath(), string, "-mountroot", file2.getAbsolutePath());
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        File file7 = new File(file2.getAbsolutePath(), (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
        File file8 = new File(file7, ".VolumeIcon.icns");
        IOUtils.copyFile(this.getConfig_VolumeIcon(map), file8);
        if (!SIMPLE_DMG.fetchFrom(map).booleanValue()) {
            object = new File(file7, ".background");
            ((File)object).mkdirs();
            IOUtils.copyFile(this.getConfig_VolumeBackground(map), new File((File)object, "background.png"));
            processBuilder = new ProcessBuilder("osascript", this.getConfig_VolumeScript(map).getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        }
        if ((object = this.findSetFileUtility()) != null) {
            file8.setWritable(true);
            processBuilder = new ProcessBuilder(new String[]{object, "-c", "icnC", file8.getAbsolutePath()});
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            file8.setReadOnly();
            processBuilder = new ProcessBuilder(new String[]{object, "-a", "C", file7.getAbsolutePath()});
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        } else {
            Log.verbose("Skip enabling custom icon as SetFile utility is not found");
        }
        processBuilder = new ProcessBuilder(hdiutil, "detach", string, file7.getAbsolutePath());
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        processBuilder = new ProcessBuilder(hdiutil, "convert", file3.getAbsolutePath(), string, "-format", "UDZO", "-o", file4.getAbsolutePath());
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        if (this.getConfig_LicenseFile(map).exists()) {
            processBuilder = new ProcessBuilder(hdiutil, "unflatten", file4.getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            processBuilder = new ProcessBuilder(hdiutil, "udifrez", file4.getAbsolutePath(), "-xml", this.getConfig_LicenseFile(map).getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
            processBuilder = new ProcessBuilder(hdiutil, "flatten", file4.getAbsolutePath());
            IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        }
        file3.delete();
        Log.info(MessageFormat.format(I18N.getString("message.output-to-location"), StandardBundlerParam.APP_NAME.fetchFrom(map), file4.getAbsolutePath()));
        return file4;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "dmg";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(this.getDMGBundleParameters());
        return linkedHashSet;
    }

    public Collection<BundlerParamInfo<?>> getDMGBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(MacAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(Arrays.asList(StandardBundlerParam.LICENSE_FILE, SIMPLE_DMG, StandardBundlerParam.SYSTEM_WIDE));
        return linkedHashSet;
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            this.validateAppImageAndBundeler(map);
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
                throw new ConfigException(I18N.getString("error.dmg-does-not-do-daemons"), I18N.getString("error.dmg-does-not-do-daemons.advice"));
            }
            if (map.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
                for (String string : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    if (relativeFileSet.contains(string)) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), string, relativeFileSet.getBaseDirectory().toString()));
                }
            }
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }
}

