/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager.linux;

import com.oracle.tools.packager.AbstractBundler;
import com.oracle.tools.packager.BundlerParamInfo;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.StandardBundlerParam;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.oracle.tools.packager.linux.LinuxAppBundler;
import com.oracle.tools.packager.linux.LinuxDebBundler;
import com.oracle.tools.packager.linux.LinuxResources;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;

public class LinuxRpmBundler
extends AbstractBundler {
    private static final ResourceBundle I18N = ResourceBundle.getBundle(LinuxRpmBundler.class.getName());
    public static final BundlerParamInfo<LinuxAppBundler> APP_BUNDLER = new StandardBundlerParam<LinuxAppBundler>(I18N.getString("param.app-bundler.name"), I18N.getString("param.app-bundler.description"), "linux.app.bundler", LinuxAppBundler.class, map -> new LinuxAppBundler(), null);
    public static final BundlerParamInfo<File> RPM_IMAGE_DIR = new StandardBundlerParam<File>(I18N.getString("param.image-dir.name"), I18N.getString("param.image-dir.description"), "linux.rpm.imageDir", File.class, map -> {
        File file = (File)IMAGES_ROOT.fetchFrom((Map<String, ? super Object>)map);
        if (!file.exists()) {
            file.mkdirs();
        }
        return new File(file, "linux-rpm.image");
    }, (string, map) -> new File((String)string));
    public static final BundlerParamInfo<File> CONFIG_ROOT = new StandardBundlerParam<File>(I18N.getString("param.config-root.name"), I18N.getString("param.config-root.description"), "configRoot", File.class, map -> new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom((Map<String, Object>)map), "linux"), (string, map) -> new File((String)string));
    private static final Pattern RPM_BUNDLE_NAME_PATTERN = Pattern.compile("[a-z\\d\\+\\-\\.\\_]+", 2);
    public static final BundlerParamInfo<String> BUNDLE_NAME = new StandardBundlerParam<String>(I18N.getString("param.bundle-name.name"), I18N.getString("param.bundle-name.description"), "linux.bundleName", String.class, map -> {
        String string = (String)StandardBundlerParam.APP_NAME.fetchFrom((Map<String, Object>)map);
        if (string == null) {
            return null;
        }
        string = string.toLowerCase().replaceAll("[ ]", "-");
        return string;
    }, (string, map) -> {
        if (!RPM_BUNDLE_NAME_PATTERN.matcher((CharSequence)string).matches()) {
            throw new IllegalArgumentException(new ConfigException(MessageFormat.format(I18N.getString("error.invalid-value-for-package-name"), string), I18N.getString("error.invalid-value-for-package-name.advice")));
        }
        return string;
    });
    public static final BundlerParamInfo<String> XDG_FILE_PREFIX = new StandardBundlerParam<String>(I18N.getString("param.xdg-prefix.name"), I18N.getString("param.xdg-prefix.description"), "linux.xdg-prefix", String.class, map -> {
        try {
            String string = map.containsKey(StandardBundlerParam.VENDOR.getID()) ? (String)StandardBundlerParam.VENDOR.fetchFrom((Map<String, Object>)map) : "javapackager";
            String string2 = (String)StandardBundlerParam.APP_FS_NAME.fetchFrom((Map<String, Object>)map);
            return (string + "-" + string2).replaceAll("\\s", "");
        }
        catch (Exception exception) {
            if (Log.isDebug()) {
                exception.printStackTrace();
            }
            return "unknown-MimeInfo.xml";
        }
    }, (string, map) -> string);
    private static final String DEFAULT_ICON = "javalogo_white_32.png";
    private static final String DEFAULT_SPEC_TEMPLATE = "template.spec";
    private static final String DEFAULT_DESKTOP_FILE_TEMPLATE = "template.desktop";
    private static final String DEFAULT_INIT_SCRIPT_TEMPLATE = "template.rpm.init.script";
    public static final String TOOL_RPMBUILD = "rpmbuild";
    public static final double TOOL_RPMBUILD_MIN_VERSION = 4.0;

    public LinuxRpmBundler() {
        this.baseResourceLoader = LinuxResources.class;
    }

    /*
     * Exception decompiling
     */
    public static boolean testTool(String var0, double var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean validate(Map<String, ? super Object> map) throws UnsupportedPlatformException, ConfigException {
        try {
            boolean bl;
            Object object2;
            if (map == null) {
                throw new ConfigException(I18N.getString("error.parameters-null"), I18N.getString("error.parameters-null.advice"));
            }
            APP_BUNDLER.fetchFrom(map).doValidate(map);
            if (map.containsKey(StandardBundlerParam.LICENSE_FILE.getID())) {
                RelativeFileSet relativeFileSet = (RelativeFileSet)StandardBundlerParam.APP_RESOURCES.fetchFrom(map);
                for (Object object2 : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)) {
                    if (relativeFileSet.contains((String)object2)) continue;
                    throw new ConfigException(I18N.getString("error.license-missing"), MessageFormat.format(I18N.getString("error.license-missing.advice"), object2, relativeFileSet.getBaseDirectory().toString()));
                }
            }
            if (!LinuxRpmBundler.testTool(TOOL_RPMBUILD, 4.0)) {
                throw new ConfigException(I18N.getString(MessageFormat.format("error.cannot-find-rpmbuild", 4.0)), I18N.getString(MessageFormat.format("error.cannot-find-rpmbuild.advice", 4.0)));
            }
            boolean bl2 = StandardBundlerParam.SYSTEM_WIDE.fetchFrom(map) == null || (Boolean)StandardBundlerParam.SYSTEM_WIDE.fetchFrom(map) != false;
            boolean bl3 = bl = map.containsKey(StandardBundlerParam.SERVICE_HINT.getID()) && (Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map) != false;
            if (bl && !bl2) {
                throw new ConfigException(I18N.getString("error.no-support-for-peruser-daemons"), I18N.getString("error.no-support-for-peruser-daemons.advice"));
            }
            object2 = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
            if (object2 != null) {
                for (int i = 0; i < object2.size(); ++i) {
                    Map map2 = (Map)object2.get(i);
                    List list = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(map2);
                    if (list == null || list.isEmpty()) {
                        throw new ConfigException(MessageFormat.format(I18N.getString("error.no-content-types-for-file-association"), i), I18N.getString("error.no-content-types-for-file-association.advice"));
                    }
                    if (list.size() <= 1) continue;
                    throw new ConfigException(MessageFormat.format(I18N.getString("error.too-many-content-types-for-file-association"), i), I18N.getString("error.too-many-content-types-for-file-association.advice"));
                }
            }
            BUNDLE_NAME.getStringConverter().apply(BUNDLE_NAME.fetchFrom(map), map);
            return true;
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException.getCause() instanceof ConfigException) {
                throw (ConfigException)runtimeException.getCause();
            }
            throw new ConfigException(runtimeException);
        }
    }

    private boolean prepareProto(Map<String, ? super Object> map) {
        File file = RPM_IMAGE_DIR.fetchFrom(map);
        File file2 = APP_BUNDLER.fetchFrom(map).doBundle(map, file, true);
        return file2 != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public File bundle(Map<String, ? super Object> map, File file) {
        File file2;
        block32: {
            if (!file.isDirectory() && !file.mkdirs()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-create-output-dir"), file.getAbsolutePath()));
            }
            if (!file.canWrite()) {
                throw new RuntimeException(MessageFormat.format(I18N.getString("error.cannot-write-to-output-dir"), file.getAbsolutePath()));
            }
            file2 = RPM_IMAGE_DIR.fetchFrom(map);
            file2.mkdirs();
            boolean bl = (Boolean)StandardBundlerParam.MENU_HINT.fetchFrom(map);
            boolean bl2 = (Boolean)StandardBundlerParam.SHORTCUT_HINT.fetchFrom(map);
            if (!bl && !bl2) {
                Log.verbose(I18N.getString("message.one-shortcut-required"));
                map.put(StandardBundlerParam.MENU_HINT.getID(), (Object)true);
            }
            if (!this.prepareProto(map) || !this.prepareProjectConfig(map)) break block32;
            File file3 = this.buildRPM(map, file);
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file3;
        }
        File file4 = null;
        try {
            if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                this.saveConfigFiles(map);
            }
            if (file2 != null && !Log.isDebug()) {
                IOUtils.deleteRecursive(file2);
            } else if (file2 != null) {
                Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        return file4;
        catch (IOException iOException) {
            File file5;
            try {
                iOException.printStackTrace();
                file5 = null;
            }
            catch (Throwable throwable) {
                try {
                    if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                        this.saveConfigFiles(map);
                    }
                    if (file2 != null && !Log.isDebug()) {
                        IOUtils.deleteRecursive(file2);
                    } else if (file2 != null) {
                        Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return null;
                }
                throw throwable;
            }
            try {
                if (((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)).booleanValue()) {
                    this.saveConfigFiles(map);
                }
                if (file2 != null && !Log.isDebug()) {
                    IOUtils.deleteRecursive(file2);
                } else if (file2 != null) {
                    Log.info(MessageFormat.format(I18N.getString("message.debug-working-directory"), file2.getAbsolutePath()));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
            return file5;
        }
    }

    private void setPermissions(File file, String string) {
        Set<PosixFilePermission> set = PosixFilePermissions.fromString(string);
        try {
            if (file.exists()) {
                Files.setPosixFilePermissions(file.toPath(), set);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger(LinuxDebBundler.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    protected void saveConfigFiles(Map<String, ? super Object> map) {
        try {
            File file = CONFIG_ROOT.fetchFrom(map);
            File file2 = LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(map), map);
            if (this.getConfig_SpecFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_SpecFile(map), new File(file, this.getConfig_SpecFile(map).getName()));
            }
            if (this.getConfig_DesktopShortcutFile(file2, map).exists()) {
                IOUtils.copyFile(this.getConfig_DesktopShortcutFile(file2, map), new File(file, this.getConfig_DesktopShortcutFile(file2, map).getName()));
            }
            if (this.getConfig_IconFile(file2, map).exists()) {
                IOUtils.copyFile(this.getConfig_IconFile(file2, map), new File(file, this.getConfig_IconFile(file2, map).getName()));
            }
            if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue() && this.getConfig_InitScriptFile(map).exists()) {
                IOUtils.copyFile(this.getConfig_InitScriptFile(map), new File(file, this.getConfig_InitScriptFile(map).getName()));
            }
            Log.info(MessageFormat.format(I18N.getString("message.config-save-location"), file.getAbsolutePath()));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private String getLicenseFileString(Map<String, ? super Object> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : (List)StandardBundlerParam.LICENSE_FILE.fetchFrom(map)) {
            if (stringBuilder.length() != 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append("%doc /opt/");
            stringBuilder.append((String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
            stringBuilder.append("/app/");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    private boolean prepareProjectConfig(Map<String, ? super Object> map) throws IOException {
        CharSequence charSequence;
        Appendable appendable;
        Object object;
        Object object22;
        Map<String, String> map2 = this.createReplacementData(map);
        File file = LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(map), map);
        File file2 = this.getConfig_IconFile(file, map);
        File file3 = LinuxAppBundler.ICON_PNG.fetchFrom(map);
        if (file3 == null || !file3.exists()) {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        } else {
            this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.menu-icon"), file3, file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        }
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Object object22 : (List)StandardBundlerParam.SECONDARY_LAUNCHERS.fetchFrom(map)) {
            object = this.createReplacementData((Map<String, ? super Object>)object22);
            object.put((String)"APPLICATION_FS_NAME", (String)map2.get("APPLICATION_FS_NAME"));
            object.put((String)"DESKTOP_MIMES", (String)"");
            appendable = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(file, (Map<String, ? super Object>)object22)));
            charSequence = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(file, (Map<String, ? super Object>)object22).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, (Map<String, String>)object, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
            ((Writer)appendable).write((String)charSequence);
            ((Writer)appendable).close();
            file2 = this.getConfig_IconFile(file, (Map<String, ? super Object>)object22);
            file3 = LinuxAppBundler.ICON_PNG.fetchFrom((Map<String, Object>)object22);
            if (file3 == null || !file3.exists()) {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.menu-icon"), DEFAULT_ICON, file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
            } else {
                this.fetchResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + file2.getName(), I18N.getString("resource.menu-icon"), file3, file2, (boolean)((Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map)), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
            }
            stringBuilder.append("xdg-desktop-menu install --novendor /opt/");
            stringBuilder.append(map2.get("APPLICATION_FS_NAME"));
            stringBuilder.append("/");
            stringBuilder.append((String)object.get("APPLICATION_LAUNCHER_FILENAME"));
            stringBuilder.append(".desktop\n");
            stringBuilder2.append("xdg-desktop-menu uninstall --novendor /opt/");
            stringBuilder2.append(map2.get("APPLICATION_FS_NAME"));
            stringBuilder2.append("/");
            stringBuilder2.append((String)object.get("APPLICATION_LAUNCHER_FILENAME"));
            stringBuilder2.append(".desktop\n");
        }
        map2.put("SECONDARY_LAUNCHERS_INSTALL", stringBuilder.toString());
        map2.put("SECONDARY_LAUNCHERS_REMOVE", stringBuilder2.toString());
        List list = (List)StandardBundlerParam.FILE_ASSOCIATIONS.fetchFrom(map);
        map2.put("FILE_ASSOCIATION_INSTALL", "");
        map2.put("FILE_ASSOCIATION_REMOVE", "");
        map2.put("DESKTOP_MIMES", "");
        if (list != null) {
            object22 = XDG_FILE_PREFIX.fetchFrom(map) + "-MimeInfo.xml";
            object = new StringBuilder("<?xml version=\"1.0\"?>\n<mime-info xmlns='http://www.freedesktop.org/standards/shared-mime-info'>\n");
            appendable = new StringBuilder();
            charSequence = new StringBuilder();
            StringBuilder stringBuilder3 = new StringBuilder("MimeType=");
            boolean bl = false;
            Object object3 = list.iterator();
            while (object3.hasNext()) {
                int n;
                Object object42;
                List list2;
                Map map3 = (Map)object3.next();
                if (map3 == null) continue;
                String string = (String)StandardBundlerParam.FA_DESCRIPTION.fetchFrom(map3);
                File file4 = (File)StandardBundlerParam.FA_ICON.fetchFrom(map3);
                List list3 = (List)StandardBundlerParam.FA_EXTENSIONS.fetchFrom(map3);
                if (list3 == null) {
                    Log.info(I18N.getString("message.creating-association-with-null-extension"));
                }
                if ((list2 = (List)StandardBundlerParam.FA_CONTENT_TYPE.fetchFrom(map3)) == null || list2.isEmpty()) continue;
                String string2 = (String)list2.get(0);
                String string3 = string2.replace('/', '-');
                ((StringBuilder)object).append("  <mime-type type='").append(string2).append("'>\n");
                if (string != null && !string.isEmpty()) {
                    ((StringBuilder)object).append("    <comment>").append(string).append("</comment>\n");
                }
                if (list3 != null) {
                    for (Object object42 : list3) {
                        ((StringBuilder)object).append("    <glob pattern='*.").append((String)object42).append("'/>\n");
                    }
                }
                ((StringBuilder)object).append("  </mime-type>\n");
                if (!bl) {
                    ((StringBuilder)appendable).append("xdg-mime install /opt/").append(map2.get("APPLICATION_FS_NAME")).append("/").append((String)object22).append("\n");
                    ((StringBuilder)charSequence).append("xdg-mime uninstall /opt/").append(map2.get("APPLICATION_FS_NAME")).append("/").append((String)object22).append("\n");
                    bl = true;
                } else {
                    stringBuilder3.append(";");
                }
                stringBuilder3.append(string2);
                if (file4 == null || !file4.exists() || (n = this.getSquareSizeOfImage(file4)) <= 0) continue;
                object42 = new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + "_fa_" + file4.getName());
                IOUtils.copyFile(file4, (File)object42);
                ((StringBuilder)appendable).append("xdg-icon-resource install --context mimetypes --size ").append(n).append(" /opt/").append(map2.get("APPLICATION_FS_NAME")).append("/").append(((File)object42).getName()).append(" ").append(string3).append("\n");
                ((StringBuilder)charSequence).append("xdg-icon-resource uninstall --context mimetypes --size ").append(n).append(" /opt/").append(map2.get("APPLICATION_FS_NAME")).append("/").append(((File)object42).getName()).append(" ").append(string3).append("\n");
            }
            ((StringBuilder)object).append("</mime-info>");
            if (bl) {
                object3 = new BufferedWriter(new FileWriter(new File(file, (String)object22)));
                ((Writer)object3).write(((StringBuilder)object).toString());
                ((Writer)object3).close();
                map2.put("FILE_ASSOCIATION_INSTALL", ((StringBuilder)appendable).toString());
                map2.put("FILE_ASSOCIATION_REMOVE", ((StringBuilder)charSequence).toString());
                map2.put("DESKTOP_MIMES", stringBuilder3.toString());
            }
        }
        object22 = new BufferedWriter(new FileWriter(this.getConfig_DesktopShortcutFile(file, map)));
        object = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_DesktopShortcutFile(file, map).getName(), I18N.getString("resource.menu-shortcut-descriptor"), DEFAULT_DESKTOP_FILE_TEMPLATE, map2, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        ((Writer)object22).write((String)object);
        ((Writer)object22).close();
        object22 = new BufferedWriter(new FileWriter(this.getConfig_SpecFile(map)));
        object = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_SpecFile(map).getName(), I18N.getString("resource.rpm-spec-file"), DEFAULT_SPEC_TEMPLATE, map2, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
        ((Writer)object22).write((String)object);
        ((Writer)object22).close();
        if (((Boolean)StandardBundlerParam.SERVICE_HINT.fetchFrom(map)).booleanValue()) {
            object22 = new BufferedWriter(new FileWriter(this.getConfig_InitScriptFile(map)));
            object = this.preprocessTextResource(LinuxAppBundler.LINUX_BUNDLER_PREFIX + this.getConfig_InitScriptFile(map).getName(), I18N.getString("resource.rpm-init-script"), DEFAULT_INIT_SCRIPT_TEMPLATE, map2, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map), (File)StandardBundlerParam.DROP_IN_RESOURCES_ROOT.fetchFrom(map));
            ((Writer)object22).write((String)object);
            ((Writer)object22).close();
            this.setPermissions(this.getConfig_InitScriptFile(map), "rwxr-xr-x");
        }
        return true;
    }

    private Map<String, String> createReplacementData(Map<String, ? super Object> map) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("APPLICATION_NAME", (String)StandardBundlerParam.APP_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_FS_NAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_PACKAGE", BUNDLE_NAME.fetchFrom(map));
        hashMap.put("APPLICATION_VENDOR", (String)StandardBundlerParam.VENDOR.fetchFrom(map));
        hashMap.put("APPLICATION_VERSION", (String)StandardBundlerParam.VERSION.fetchFrom(map));
        hashMap.put("APPLICATION_LAUNCHER_FILENAME", (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map));
        hashMap.put("XDG_PREFIX", XDG_FILE_PREFIX.fetchFrom(map));
        hashMap.put("DEPLOY_BUNDLE_CATEGORY", (String)StandardBundlerParam.CATEGORY.fetchFrom(map));
        hashMap.put("APPLICATION_DESCRIPTION", (String)StandardBundlerParam.DESCRIPTION.fetchFrom(map));
        hashMap.put("APPLICATION_SUMMARY", (String)StandardBundlerParam.TITLE.fetchFrom(map));
        hashMap.put("APPLICATION_LICENSE_TYPE", StandardBundlerParam.LICENSE_TYPE.fetchFrom(map));
        hashMap.put("APPLICATION_LICENSE_FILE", this.getLicenseFileString(map));
        hashMap.put("SERVICE_HINT", String.valueOf(StandardBundlerParam.SERVICE_HINT.fetchFrom(map)));
        hashMap.put("START_ON_INSTALL", String.valueOf(StandardBundlerParam.START_ON_INSTALL.fetchFrom(map)));
        hashMap.put("STOP_ON_UNINSTALL", String.valueOf(StandardBundlerParam.STOP_ON_UNINSTALL.fetchFrom(map)));
        hashMap.put("RUN_AT_STARTUP", String.valueOf(StandardBundlerParam.RUN_AT_STARTUP.fetchFrom(map)));
        return hashMap;
    }

    private File getConfig_DesktopShortcutFile(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".desktop");
    }

    private File getConfig_IconFile(File file, Map<String, ? super Object> map) {
        return new File(file, (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".png");
    }

    private File getConfig_InitScriptFile(Map<String, ? super Object> map) {
        return new File(LinuxAppBundler.getRootDir(RPM_IMAGE_DIR.fetchFrom(map), map), BUNDLE_NAME.fetchFrom(map) + ".init");
    }

    private File getConfig_SpecFile(Map<String, ? super Object> map) {
        return new File(RPM_IMAGE_DIR.fetchFrom(map), (String)StandardBundlerParam.APP_FS_NAME.fetchFrom(map) + ".spec");
    }

    private File buildRPM(Map<String, ? super Object> map, File file) throws IOException {
        Log.verbose(MessageFormat.format(I18N.getString("message.outputting-bundle-location"), file.getAbsolutePath()));
        File file2 = new File((File)StandardBundlerParam.BUILD_ROOT.fetchFrom(map), "rmpbuildroot");
        file.mkdirs();
        ProcessBuilder processBuilder = new ProcessBuilder(TOOL_RPMBUILD, "-bb", this.getConfig_SpecFile(map).getAbsolutePath(), "--define", "%_sourcedir " + RPM_IMAGE_DIR.fetchFrom(map).getAbsolutePath(), "--define", "%_rpmdir " + file.getAbsolutePath(), "--define", "%_topdir " + file2.getAbsolutePath());
        processBuilder = processBuilder.directory(RPM_IMAGE_DIR.fetchFrom(map));
        IOUtils.exec(processBuilder, (Boolean)StandardBundlerParam.VERBOSE.fetchFrom(map));
        if (!Log.isDebug()) {
            IOUtils.deleteRecursive(file2);
        }
        Log.info(MessageFormat.format(I18N.getString("message.output-bundle-location"), file.getAbsolutePath()));
        File file3 = null;
        long l = 0L;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file4 : fileArray) {
                if (!file4.getName().endsWith(".rpm") || file4.lastModified() <= l) continue;
                file3 = file4;
                l = file4.lastModified();
            }
        }
        return file3;
    }

    @Override
    public String getName() {
        return I18N.getString("bundler.name");
    }

    @Override
    public String getDescription() {
        return I18N.getString("bundler.description");
    }

    @Override
    public String getID() {
        return "rpm";
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    @Override
    public Collection<BundlerParamInfo<?>> getBundleParameters() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        linkedHashSet.addAll(LinuxAppBundler.getAppBundleParameters());
        linkedHashSet.addAll(LinuxRpmBundler.getRpmBundleParameters());
        return linkedHashSet;
    }

    public static Collection<BundlerParamInfo<?>> getRpmBundleParameters() {
        return Arrays.asList(BUNDLE_NAME, StandardBundlerParam.CATEGORY, StandardBundlerParam.DESCRIPTION, LinuxAppBundler.ICON_PNG, StandardBundlerParam.LICENSE_FILE, StandardBundlerParam.LICENSE_TYPE, StandardBundlerParam.TITLE, StandardBundlerParam.VENDOR);
    }

    @Override
    public File execute(Map<String, ? super Object> map, File file) {
        return this.bundle(map, file);
    }

    public int getSquareSizeOfImage(File file) {
        try {
            BufferedImage bufferedImage = ImageIO.read(file);
            if (bufferedImage.getWidth() == bufferedImage.getHeight()) {
                return bufferedImage.getWidth();
            }
            return 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return 0;
        }
    }
}

