/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.flightrecorder.ui;

import com.jrockit.mc.common.io.IOToolkit;
import com.jrockit.mc.components.ui.design.IComponentVerifier;
import com.jrockit.mc.flightrecorder.CouldNotLoadRecordingException;
import com.jrockit.mc.flightrecorder.FlightRecording;
import com.jrockit.mc.flightrecorder.FlightRecordingLoader;
import com.jrockit.mc.flightrecorder.NotEnoughMemoryException;
import com.jrockit.mc.flightrecorder.spi.IEvent;
import com.jrockit.mc.flightrecorder.spi.IEventType;
import com.jrockit.mc.flightrecorder.spi.IProducer;
import com.jrockit.mc.flightrecorder.spi.ITimeRange;
import com.jrockit.mc.flightrecorder.spi.IView;
import com.jrockit.mc.flightrecorder.ui.AbstractFlightRecordingEditor;
import com.jrockit.mc.flightrecorder.ui.FlightRecorderUI;
import com.jrockit.mc.flightrecorder.ui.SelectRangeWizardPage;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptor;
import com.jrockit.mc.flightrecorder.ui.components.selection.EventTypeDescriptorRepository;
import com.jrockit.mc.flightrecorder.ui.messages.internal.Messages;
import com.jrockit.mc.flightrecorder.ui.views.types.ITypeVisibilitySupport;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.TemporaryMessage;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.IMessageManager;
import org.eclipse.ui.forms.editor.IFormPage;

public final class FlightRecordingEditor
extends AbstractFlightRecordingEditor {
    private static int zippedFileMemoryFactor = 4;
    public static final String EDITOR_ID = "com.jrockit.mc.flightrecorder.ui.FlightRecordingEditor";

    private void checkForJRockitRecording(FlightRecording recording) {
        for (IProducer producer : recording.getProducers()) {
            if (!producer.getName().contains("JRockit")) continue;
            DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)FlightRecordingEditor.this.getSite().getShell(), (String)Messages.FILE_OPENER_JROCKIT_TITLE, (String)Messages.FILE_OPENER_JROCKIT_TEXT);
                }
            });
            throw new OperationCanceledException();
        }
    }

    @Override
    protected FlightRecording createRecording(File file, FlightRecordingLoader.ILoadingMonitor monitor) throws CouldNotLoadRecordingException, IOException {
        FlightRecording rec = this.doCreateRecording(file, monitor);
        this.checkForJRockitRecording(rec);
        ComponentVerifier cv = new ComponentVerifier(rec);
        if (cv.enabledEventTypes.isEmpty()) {
            DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openError((Shell)FlightRecordingEditor.this.getSite().getShell(), (String)Messages.FILE_OPENER_EVENT_SETTINGS_MISSING_TITLE, (String)Messages.FILE_OPENER_EVENT_SETTINGS_MISSING_TEXT);
                }
            });
        } else {
            this.getServiceLocator().registerService(IComponentVerifier.class, (Object)cv);
        }
        this.checkForLostEvents(rec);
        return rec;
    }

    private ITimeRange selectRangeWizard(double loadQuota, ITimeRange range) {
        SelectRangeWizardPage rangeWizard = new SelectRangeWizardPage(loadQuota, range);
        final OnePageWizardDialog dialog = new OnePageWizardDialog(this.getSite().getShell(), (IWizardPage)rangeWizard);
        dialog.setWidthConstraint(600, 600);
        dialog.setHeightConstraint(400, 400);
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        if (dialog.getReturnCode() == 0) {
            return rangeWizard.getRange();
        }
        throw new OperationCanceledException();
    }

    private FlightRecording doCreateRecording(File file, FlightRecordingLoader.ILoadingMonitor lm) throws CouldNotLoadRecordingException, IOException {
        System.gc();
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.maxMemory() - runtime.totalMemory() + runtime.freeMemory();
        if (!IOToolkit.isGZipFile((File)file) && !IOToolkit.isZipFile((File)file)) {
            return this.loadFromUnzippedFile(file, lm, availableMemory);
        }
        if (availableMemory > (long)zippedFileMemoryFactor * file.length()) {
            InputStream stream = IOToolkit.openUncompressedStream((File)file);
            try {
                boolean showHiddenMethods = FlightRecorderUI.getDefault().getShowHiddenMethods();
                FlightRecording flightRecording = FlightRecordingLoader.loadStream((InputStream)stream, (boolean)showHiddenMethods, (FlightRecordingLoader.ILoadingMonitor)lm);
                return flightRecording;
            }
            catch (NotEnoughMemoryException notEnoughMemoryException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
            }
            finally {
                IOToolkit.closeSilently((Closeable)stream);
            }
        }
        return this.loadFromUnzippedFile(this.unzipFile(file), lm, availableMemory);
    }

    private FlightRecording loadFromUnzippedFile(File unzippedFile, FlightRecordingLoader.ILoadingMonitor lm, long availableMemory) throws IOException, CouldNotLoadRecordingException {
        boolean showHiddenMethods = FlightRecorderUI.getDefault().getShowHiddenMethods();
        FlightRecordingLoader loader = new FlightRecordingLoader(unzippedFile);
        double loadQuota = Math.min((double)availableMemory / (2.0 * (double)unzippedFile.length()), 1.0);
        while (loadQuota > 0.05) {
            try {
                if (loadQuota < 1.0) {
                    ITimeRange newRange = this.selectRangeWizard(loadQuota, loader.getRecordingRange());
                    return loader.load(newRange, showHiddenMethods, lm);
                }
                return loader.load(null, showHiddenMethods, lm);
            }
            catch (NotEnoughMemoryException notEnoughMemoryException) {
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            loadQuota *= 0.7;
        }
        throw new NotEnoughMemoryException();
    }

    private void bringToFront() {
        DisplayToolkit.safeSyncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                FlightRecordingEditor.this.getSite().getShell().forceActive();
            }
        });
    }

    private File unzipFile(File file) throws IOException {
        File unzippedFile = FlightRecordingEditor.getUnzippedDestinationFile(file);
        if (unzippedFile.exists() && unzippedFile.lastModified() > file.lastModified()) {
            return unzippedFile;
        }
        this.bringToFront();
        boolean acceptUnzip = DialogToolkit.openQuestionOnUiThread((String)Messages.FILE_OPENER_ZIPPED_FILE_TITLE, (String)MessageFormat.format(Messages.FILE_OPENER_ZIPPED_FILE_TEXT, file.getName(), unzippedFile.getAbsolutePath()));
        if (acceptUnzip) {
            InputStream is = IOToolkit.openUncompressedStream((File)file);
            try {
                IOToolkit.write((InputStream)is, (File)unzippedFile, (boolean)false);
                File file2 = unzippedFile;
                return file2;
            }
            finally {
                IOToolkit.closeSilently((Closeable)is);
            }
        }
        throw new OperationCanceledException();
    }

    private static File getUnzippedDestinationFile(File file) throws IOException {
        String fileName = file.getName();
        int dot = fileName.lastIndexOf(46);
        String hash = IOToolkit.calculateFileHash((File)file);
        File tmpDir = FlightRecorderUI.getDefault().getTempRecordingsDir();
        return new File(tmpDir, String.valueOf(fileName.substring(0, dot)) + hash + fileName.substring(dot));
    }

    private void checkForLostEvents(FlightRecording recording) {
        IView v = recording.createView();
        for (IEventType type : recording.getEventTypes()) {
            if (!"recordings/buffer_lost".equals(type.getPath())) continue;
            v.setEventTypes(Arrays.asList(type));
            if (v.iterator().hasNext()) {
                this.showLostEventsErrorMessage();
            }
            return;
        }
    }

    private void showLostEventsErrorMessage() {
        int i = 0;
        while (i < this.pages.size()) {
            IMessageManager manager = (IMessageManager)((IFormPage)this.pages.get(i)).getAdapter(IMessageManager.class);
            if (manager != null) {
                TemporaryMessage message = new TemporaryMessage(Messages.EDITOR_ERROR_LOST_BUFFER_TEXT, 3);
                message.setDelay(Integer.MAX_VALUE);
                message.show(manager, this.getSite().getShell().getDisplay());
            }
            ++i;
        }
    }

    public static void setZippedFileMemoryFactor(int zippedFileMemoryFactor) {
        FlightRecordingEditor.zippedFileMemoryFactor = zippedFileMemoryFactor;
    }

    public static int getZippedFileMemoryFactor() {
        return zippedFileMemoryFactor;
    }

    private static class ComponentVerifier
    implements IComponentVerifier {
        private final List<String> enabledEventTypes = new ArrayList<String>();

        ComponentVerifier(FlightRecording recording) {
            IView view = recording.createView();
            for (IEventType type : recording.getEventTypes()) {
                if (!"recordings/recording_setting".equals(type.getPath())) continue;
                view.setEventTypes(Arrays.asList(type));
                for (IEvent e : view) {
                    if (!((Boolean)e.getValue("enabled")).booleanValue()) continue;
                    Object path = e.getValue("path");
                    if (path == null) {
                        return;
                    }
                    this.enabledEventTypes.add(path.toString());
                }
                return;
            }
        }

        public String getErrorMessage(Object component) {
            if (component instanceof ITypeVisibilitySupport) {
                EventTypeDescriptorRepository repo = ((ITypeVisibilitySupport)component).getEventTypeDescriptorRepository();
                HashSet<String> disabledEventTypeNames = new HashSet<String>();
                for (EventTypeDescriptor type : repo.getDescriptors()) {
                    for (String eventType : this.enabledEventTypes) {
                        if (!type.accepts(eventType)) continue;
                        return null;
                    }
                    disabledEventTypeNames.add(type.getName());
                }
                if (disabledEventTypeNames.size() == 1) {
                    return NLS.bind((String)Messages.EDITOR_ERROR_EVENT_TYPE_DISABLED_TEXT, (Object)("'" + (String)disabledEventTypeNames.iterator().next() + "'"));
                }
                StringBuilder events = new StringBuilder();
                Iterator it = disabledEventTypeNames.iterator();
                while (it.hasNext()) {
                    events.append("'").append((String)it.next()).append("'").append(it.hasNext() ? " " : "");
                }
                return NLS.bind((String)Messages.EDITOR_ERROR_EVENT_TYPES_DISABLED_TEXT, (Object)events.toString());
            }
            return null;
        }
    }
}

