/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import nl.justobjects.pushlet.core.Event;

public class EventQueue {
    private int capacity = 8;
    private Event[] queue = null;
    private int front;
    private int rear;

    public EventQueue() {
        this(8);
    }

    public EventQueue(int capacity) {
        this.capacity = capacity;
        this.queue = new Event[capacity];
        this.rear = 0;
        this.front = 0;
    }

    public synchronized boolean enQueue(Event item) throws InterruptedException {
        return this.enQueue(item, -1L);
    }

    public synchronized boolean enQueue(Event item, long maxWaitTime) throws InterruptedException {
        while (this.isFull()) {
            if (maxWaitTime > 0L) {
                this.wait(maxWaitTime);
                if (!this.isFull()) continue;
                return false;
            }
            this.wait();
        }
        this.queue[this.rear] = item;
        this.rear = this.next(this.rear);
        this.notifyAll();
        return true;
    }

    public synchronized Event deQueue() throws InterruptedException {
        return this.deQueue(-1L);
    }

    public synchronized Event deQueue(long maxWaitTime) throws InterruptedException {
        while (this.isEmpty()) {
            if (maxWaitTime >= 0L) {
                this.wait(maxWaitTime);
                if (!this.isEmpty()) continue;
                return null;
            }
            this.wait();
        }
        Event result = this.fetchNext();
        this.notifyAll();
        return result;
    }

    public synchronized Event[] deQueueAll(long maxWaitTime) throws InterruptedException {
        while (this.isEmpty()) {
            if (maxWaitTime >= 0L) {
                this.wait(maxWaitTime);
                if (!this.isEmpty()) continue;
                return null;
            }
            this.wait();
        }
        Event[] events = new Event[this.getSize()];
        for (int i = 0; i < events.length; ++i) {
            events[i] = this.fetchNext();
        }
        this.notifyAll();
        return events;
    }

    public synchronized int getSize() {
        return this.rear >= this.front ? this.rear - this.front : this.capacity - this.front + this.rear;
    }

    public synchronized boolean isEmpty() {
        return this.front == this.rear;
    }

    public synchronized boolean isFull() {
        return this.next(this.rear) == this.front;
    }

    private int next(int index) {
        return index + 1 < this.capacity ? index + 1 : 0;
    }

    private Event fetchNext() {
        Event temp = this.queue[this.front];
        this.queue[this.front] = null;
        this.front = this.next(this.front);
        return temp;
    }

    public static void p(String s) {
        System.out.println(s);
    }

    public static void main(String[] args) {
        EventQueue q = new EventQueue(8);
        Event event = new Event("t");
        try {
            q.enQueue(event);
            EventQueue.p("(1) size = " + q.getSize());
            q.enQueue(event);
            EventQueue.p("(2) size = " + q.getSize());
            q.deQueue();
            EventQueue.p("(1) size = " + q.getSize());
            q.deQueue();
            EventQueue.p("(0) size = " + q.getSize());
            q.enQueue(event);
            q.enQueue(event);
            q.enQueue(event);
            EventQueue.p("(3) size = " + q.getSize());
            q.deQueue();
            EventQueue.p("(2) size = " + q.getSize());
            q.enQueue(event);
            q.enQueue(event);
            q.enQueue(event);
            EventQueue.p("(5) size = " + q.getSize());
            q.enQueue(event);
            q.enQueue(event);
            EventQueue.p("(7) size = " + q.getSize());
            q.deQueue();
            q.deQueue();
            q.deQueue();
            EventQueue.p("(4) size = " + q.getSize());
            q.deQueue();
            q.deQueue();
            q.deQueue();
            q.deQueue();
            EventQueue.p("(0) size = " + q.getSize());
            q.enQueue(event);
            q.enQueue(event);
            q.enQueue(event);
            q.enQueue(event);
            q.enQueue(event);
            EventQueue.p("(5) size = " + q.getSize());
            q.deQueue();
            q.deQueue();
            q.deQueue();
            q.deQueue();
            EventQueue.p("(1) size = " + q.getSize());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

