/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.test;

import java.applet.Applet;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.TextArea;
import nl.justobjects.pushlet.client.PushletClient;
import nl.justobjects.pushlet.client.PushletClientListener;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.util.PushletException;

public class PushletApplet
extends Applet
implements PushletClientListener,
Protocol {
    private TextArea textArea;
    private String host = "localhost";
    private int port = 8080;
    private String subject;
    private PushletClient pushletClient;
    private String VERSION = "15.feb.05 #5";
    private String PUSH_MODE = "pull";

    public void init() {
        this.subject = this.getParameter("p_subject");
        this.host = this.getDocumentBase().getHost();
        this.port = this.getDocumentBase().getPort();
        if (this.port == -1) {
            this.port = 80;
        }
        this.setLayout(new GridLayout(1, 1));
        this.textArea = new TextArea(15, 40);
        this.textArea.setForeground(Color.yellow);
        this.textArea.setBackground(Color.gray);
        this.textArea.setEditable(false);
        this.add(this.textArea);
        this.p("PushletApplet - " + this.VERSION);
    }

    public void start() {
        this.dbg("start()");
        this.bailout();
        try {
            this.pushletClient = new PushletClient(this.host, this.port);
            this.p("Created PushletClient");
            this.pushletClient.join();
            this.p("Joined server");
            this.pushletClient.listen(this, this.PUSH_MODE);
            this.p("Listening in mode=" + this.PUSH_MODE);
            this.pushletClient.subscribe(this.subject);
            this.p("Subscribed to=" + this.subject);
        }
        catch (PushletException pe) {
            this.p("Error exception=" + pe);
            this.bailout();
        }
    }

    public void stop() {
        this.dbg("stop()");
        this.bailout();
    }

    public void onAbort(Event theEvent) {
        this.p(theEvent.toXML());
        this.bailout();
    }

    public void onData(Event theEvent) {
        this.p(theEvent.toXML());
    }

    public void onHeartbeat(Event theEvent) {
        this.p(theEvent.toXML());
    }

    public void onError(String message) {
        this.p(message);
        this.bailout();
    }

    private void bailout() {
        if (this.pushletClient != null) {
            this.p("Stopping PushletClient");
            try {
                this.pushletClient.leave();
            }
            catch (PushletException ignore) {
                this.p("Error during leave pe=" + ignore);
            }
            this.pushletClient = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void p(String s) {
        this.dbg("event: " + s);
        TextArea textArea = this.textArea;
        synchronized (textArea) {
            this.textArea.append(s + "\n");
        }
    }

    private void dbg(String s) {
        System.out.println("[PushletApplet] " + s);
    }
}

