/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import nl.justobjects.pushlet.core.Dispatcher;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.EventSource;
import nl.justobjects.pushlet.util.Log;

public abstract class EventPullSource
implements EventSource,
Runnable {
    private volatile boolean alive = false;
    private volatile boolean active = false;
    private static int threadNum = 0;
    private Thread thread;

    protected abstract long getSleepTime();

    protected abstract Event pullEvent();

    public void start() {
        this.thread = new Thread((Runnable)this, "EventPullSource-" + ++threadNum);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void stop() {
        this.alive = false;
        if (this.thread != null) {
            this.thread.interrupt();
            this.thread = null;
        }
    }

    public synchronized void activate() {
        if (this.active) {
            return;
        }
        this.active = true;
        if (!this.alive) {
            this.start();
            return;
        }
        Log.debug(this.getClass().getName() + ": notifying...");
        this.notifyAll();
    }

    public void passivate() {
        if (!this.active) {
            return;
        }
        this.active = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Log.debug(this.getClass().getName() + ": starting...");
        this.alive = true;
        while (this.alive) {
            try {
                Thread.sleep(this.getSleepTime());
                if (!this.alive) break;
                EventPullSource eventPullSource = this;
                synchronized (eventPullSource) {
                    while (!this.active) {
                        Log.debug(this.getClass().getName() + ": waiting...");
                        this.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                break;
            }
            try {
                Event event = this.pullEvent();
                Dispatcher.getInstance().multicast(event);
            }
            catch (Throwable t) {
                Log.warn("EventPullSource exception while multicasting ", t);
                t.printStackTrace();
            }
        }
        Log.debug(this.getClass().getName() + ": stopped");
    }
}

