/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.jdbc.Null;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;

public class SqlRunner {
    public static final int NO_GENERATED_KEY = -2147482647;
    private Connection connection;
    private TypeHandlerRegistry typeHandlerRegistry;
    private boolean useGeneratedKeySupport;

    public SqlRunner(Connection connection) {
        this.connection = connection;
        this.typeHandlerRegistry = new TypeHandlerRegistry();
    }

    public void setUseGeneratedKeySupport(boolean useGeneratedKeySupport) {
        this.useGeneratedKeySupport = useGeneratedKeySupport;
    }

    public Map<String, Object> selectOne(String sql, Object ... args) throws SQLException {
        List<Map<String, Object>> results = this.selectAll(sql, args);
        if (results.size() != 1) {
            throw new SQLException("Statement returned " + results.size() + " results where exactly one (1) was expected.");
        }
        return results.get(0);
    }

    public List<Map<String, Object>> selectAll(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            this.setParameters(ps, args);
            ResultSet rs = ps.executeQuery();
            List<Map<String, Object>> list = this.getResults(rs);
            return list;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public int insert(String sql, Object ... args) throws SQLException {
        PreparedStatement ps;
        block12: {
            Object genkey;
            Map<String, Object> key;
            Iterator<Object> i;
            List<Map<String, Object>> keys;
            ps = this.useGeneratedKeySupport ? this.connection.prepareStatement(sql, 1) : this.connection.prepareStatement(sql);
            this.setParameters(ps, args);
            ps.executeUpdate();
            if (!this.useGeneratedKeySupport || (keys = this.getResults(ps.getGeneratedKeys())).size() != 1 || !(i = (key = keys.get(0)).values().iterator()).hasNext() || (genkey = i.next()) == null) break block12;
            try {
                int n = Integer.parseInt(genkey.toString());
                return n;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return -2147482647;
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public int update(String sql, Object ... args) throws SQLException {
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            this.setParameters(ps, args);
            int n = ps.executeUpdate();
            return n;
        }
        finally {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public int delete(String sql, Object ... args) throws SQLException {
        return this.update(sql, args);
    }

    public void run(String sql) throws SQLException {
        Statement stmt = this.connection.createStatement();
        try {
            stmt.execute(sql);
        }
        finally {
            try {
                stmt.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    public void closeConnection() {
        try {
            this.connection.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void setParameters(PreparedStatement ps, Object ... args) throws SQLException {
        int i = 0;
        int n = args.length;
        while (i < n) {
            if (args[i] == null) {
                throw new SQLException("SqlRunner requires an instance of Null to represent typed null values for JDBC compatibility");
            }
            if (args[i] instanceof Null) {
                ((Null)((Object)args[i])).getTypeHandler().setParameter(ps, i + 1, null, ((Null)((Object)args[i])).getJdbcType());
            } else {
                TypeHandler<?> typeHandler = this.typeHandlerRegistry.getTypeHandler(args[i].getClass());
                if (typeHandler == null) {
                    throw new SQLException("SqlRunner could not find a TypeHandler instance for " + args[i].getClass());
                }
                typeHandler.setParameter(ps, i + 1, args[i], null);
            }
            ++i;
        }
    }

    private List<Map<String, Object>> getResults(ResultSet rs) throws SQLException {
        try {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ArrayList<String> columns = new ArrayList<String>();
            ArrayList typeHandlers = new ArrayList();
            ResultSetMetaData rsmd = rs.getMetaData();
            int i = 0;
            int n = rsmd.getColumnCount();
            while (i < n) {
                columns.add(rsmd.getColumnLabel(i + 1));
                try {
                    Class<?> type = Resources.classForName(rsmd.getColumnClassName(i + 1));
                    TypeHandler<Object> typeHandler = this.typeHandlerRegistry.getTypeHandler(type);
                    if (typeHandler == null) {
                        typeHandler = this.typeHandlerRegistry.getTypeHandler(Object.class);
                    }
                    typeHandlers.add(typeHandler);
                }
                catch (Exception e) {
                    typeHandlers.add(this.typeHandlerRegistry.getTypeHandler(Object.class));
                }
                ++i;
            }
            while (rs.next()) {
                HashMap row = new HashMap();
                int i2 = 0;
                int n2 = columns.size();
                while (i2 < n2) {
                    String name = (String)columns.get(i2);
                    TypeHandler handler = (TypeHandler)typeHandlers.get(i2);
                    row.put(name.toUpperCase(Locale.ENGLISH), handler.getResult(rs, name));
                    ++i2;
                }
                list.add(row);
            }
            ArrayList<Map<String, Object>> arrayList = list;
            return arrayList;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
        }
    }
}

