/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.ibatis.io.DefaultVFS;
import org.apache.ibatis.io.JBoss6VFS;
import org.apache.ibatis.io.ResolverUtil;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public abstract class VFS {
    private static final Log log = LogFactory.getLog(ResolverUtil.class);
    public static final Class<?>[] IMPLEMENTATIONS = new Class[]{JBoss6VFS.class, DefaultVFS.class};
    public static final List<Class<? extends VFS>> USER_IMPLEMENTATIONS = new ArrayList<Class<? extends VFS>>();
    private static VFS instance;

    public static VFS getInstance() {
        if (instance != null) {
            return instance;
        }
        ArrayList impls = new ArrayList();
        impls.addAll(USER_IMPLEMENTATIONS);
        impls.addAll(Arrays.asList(IMPLEMENTATIONS));
        VFS vfs = null;
        int i = 0;
        while (vfs == null || !vfs.isValid()) {
            Class impl = (Class)impls.get(i);
            try {
                vfs = (VFS)impl.newInstance();
                if (vfs == null || !vfs.isValid()) {
                    log.debug("VFS implementation " + impl.getName() + " is not valid in this environment.");
                }
            }
            catch (InstantiationException e) {
                log.error("Failed to instantiate " + impl, e);
                return null;
            }
            catch (IllegalAccessException e) {
                log.error("Failed to instantiate " + impl, e);
                return null;
            }
            ++i;
        }
        log.debug("Using VFS adapter " + vfs.getClass().getName());
        instance = vfs;
        return instance;
    }

    public static void addImplClass(Class<? extends VFS> clazz) {
        if (clazz != null) {
            USER_IMPLEMENTATIONS.add(clazz);
        }
    }

    protected static Class<?> getClass(String className) {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            log.debug("Class not found: " + className);
            return null;
        }
    }

    protected static Method getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        block4: {
            if (clazz != null) break block4;
            return null;
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            log.error("Security exception looking for method " + clazz.getName() + "." + methodName + ".  Cause: " + e);
            return null;
        }
        catch (NoSuchMethodException e) {
            log.error("Method not found " + clazz.getName() + "." + methodName + "." + methodName + ".  Cause: " + e);
            return null;
        }
    }

    protected static <T> T invoke(Method method, Object object, Object ... parameters) throws IOException, RuntimeException {
        try {
            return (T)method.invoke(object, parameters);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof IOException) {
                throw (IOException)e.getTargetException();
            }
            throw new RuntimeException(e);
        }
    }

    protected static List<URL> getResources(String path) throws IOException {
        return Collections.list(Thread.currentThread().getContextClassLoader().getResources(path));
    }

    public abstract boolean isValid();

    protected abstract List<String> list(URL var1, String var2) throws IOException;

    public List<String> list(String path) throws IOException {
        ArrayList<String> names = new ArrayList<String>();
        for (URL url : VFS.getResources(path)) {
            names.addAll(this.list(url, path));
        }
        return names;
    }
}

