/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.cache;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.cache.NullCacheKey;

public class CacheKey
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1146682552656046210L;
    public static final CacheKey NULL_CACHE_KEY = new NullCacheKey();
    private static final int DEFAULT_MULTIPLYER = 37;
    private static final int DEFAULT_HASHCODE = 17;
    private int multiplier = 37;
    private int hashcode = 17;
    private long checksum;
    private int count = 0;
    private List<Object> updateList = new ArrayList<Object>();

    public CacheKey() {
    }

    public CacheKey(Object[] objects) {
        this();
        this.updateAll(objects);
    }

    public int getUpdateCount() {
        return this.updateList.size();
    }

    public void update(Object object) {
        if (object != null && object.getClass().isArray()) {
            int length = Array.getLength(object);
            int i = 0;
            while (i < length) {
                Object element = Array.get(object, i);
                this.doUpdate(element);
                ++i;
            }
        } else {
            this.doUpdate(object);
        }
    }

    private void doUpdate(Object object) {
        int baseHashCode = object == null ? 1 : object.hashCode();
        ++this.count;
        this.checksum += (long)baseHashCode;
        this.hashcode = this.multiplier * this.hashcode + (baseHashCode *= this.count);
        this.updateList.add(object);
    }

    public void updateAll(Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            this.update(o);
            ++n2;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CacheKey)) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)object;
        if (this.hashcode != cacheKey.hashcode) {
            return false;
        }
        if (this.checksum != cacheKey.checksum) {
            return false;
        }
        if (this.count != cacheKey.count) {
            return false;
        }
        int i = 0;
        while (i < this.updateList.size()) {
            Object thisObject = this.updateList.get(i);
            Object thatObject = cacheKey.updateList.get(i);
            if (thisObject == null ? thatObject != null : !thisObject.equals(thatObject)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        StringBuilder returnValue = new StringBuilder().append(this.hashcode).append(':').append(this.checksum);
        int i = 0;
        while (i < this.updateList.size()) {
            returnValue.append(':').append(this.updateList.get(i));
            ++i;
        }
        return returnValue.toString();
    }

    public CacheKey clone() throws CloneNotSupportedException {
        CacheKey clonedCacheKey = (CacheKey)super.clone();
        clonedCacheKey.updateList = new ArrayList<Object>(this.updateList);
        return clonedCacheKey;
    }
}

