/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup.layers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import org.netbeans.core.startup.layers.NbinstURLMapper;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class NbinstURLStreamHandler
extends URLStreamHandler {
    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        return new NbinstURLConnection(uRL);
    }

    private static class NbinstURLConnection
    extends URLConnection {
        private File f;
        private InputStream iStream;

        public NbinstURLConnection(URL uRL) {
            super(uRL);
        }

        @Override
        public void connect() throws IOException {
            if (this.f == null) {
                this.f = NbinstURLMapper.decodeURL(this.url);
                if (this.f == null) {
                    throw new FileNotFoundException("Cannot find: " + this.url);
                }
            }
            if (!this.f.isFile()) {
                throw new UnknownServiceException();
            }
        }

        @Override
        public int getContentLength() {
            try {
                this.connect();
                return (int)this.f.length();
            }
            catch (IOException iOException) {
                return -1;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.connect();
            if (this.iStream == null) {
                this.iStream = new FileInputStream(this.f);
            }
            return this.iStream;
        }

        @Override
        public String getHeaderField(String string) {
            if ("content-type".equals(string)) {
                try {
                    this.connect();
                    FileObject fileObject = FileUtil.toFileObject((File)this.f);
                    if (fileObject != null) {
                        return fileObject.getMIMEType();
                    }
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return super.getHeaderField(string);
        }
    }
}

