/*
 * Decompiled with CFR 0.152.
 */
package jdk.internal.cmm;

import java.lang.management.ManagementPermission;
import javax.management.AttributeChangeNotification;
import javax.management.MBeanNotificationInfo;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import jdk.management.cmm.SystemResourcePressureMXBean;

public final class SystemResourcePressureImpl
extends NotificationBroadcasterSupport
implements SystemResourcePressureMXBean {
    private static final int MIN_PRESSURE_LEVEL = 0;
    private static final int MAX_PRESSURE_LEVEL = 10;
    public static final String RESOURCE_PRESSURE_MXBEAN_NAME = "com.oracle.management:type=ResourcePressureMBean";
    private static final String MEM_PRESSURE_ATTRIBUTE_NAME = "MemoryPressure";
    private int memoryPressureLevel = 0;
    private long notifSeqNum;
    private static ManagementPermission controlPermission = new ManagementPermission("control");

    public SystemResourcePressureImpl() {
        super(new MBeanNotificationInfo(new String[]{"jmx.attribute.change"}, AttributeChangeNotification.class.getName(), "Notification that Memory pressure level has changed"));
    }

    @Override
    public synchronized int getMemoryPressure() {
        return this.memoryPressureLevel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMemoryPressure(int n) {
        AttributeChangeNotification attributeChangeNotification;
        if (n < 0 || n > 10) {
            throw new IllegalArgumentException("Invalid pressure level: " + n);
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(controlPermission);
        }
        SystemResourcePressureImpl systemResourcePressureImpl = this;
        synchronized (systemResourcePressureImpl) {
            if (n == this.memoryPressureLevel) {
                return;
            }
            int n2 = this.memoryPressureLevel;
            this.memoryPressureLevel = n;
            attributeChangeNotification = new AttributeChangeNotification(this, ++this.notifSeqNum, System.currentTimeMillis(), "Memory pressure level change detected", MEM_PRESSURE_ATTRIBUTE_NAME, "int", n2, n);
            this.setVmMemoryPressure(n);
        }
        this.sendNotification(attributeChangeNotification);
    }

    private native void setVmMemoryPressure(int var1);

    @Override
    public ObjectName getObjectName() {
        try {
            return ObjectName.getInstance(RESOURCE_PRESSURE_MXBEAN_NAME);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new InternalError();
        }
    }
}

