/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.glass.ui.Pixels;
import com.sun.javafx.tk.quantum.GlassScene;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.RTTexture;
import com.sun.prism.Texture;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.QueuedPixelSource;
import java.nio.IntBuffer;

final class UploadingPainter
extends ViewPainter
implements Runnable {
    private RTTexture rttexture;
    private RTTexture resolveRTT = null;
    private QueuedPixelSource pixelSource = new QueuedPixelSource(true);
    private float penScale;
    private volatile float pixScaleFactor = 1.0f;

    UploadingPainter(GlassScene glassScene) {
        super(glassScene);
    }

    void disposeRTTexture() {
        if (this.rttexture != null) {
            this.rttexture.dispose();
            this.rttexture = null;
        }
        if (this.resolveRTT != null) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
    }

    public void setPixelScaleFactor(float f) {
        this.pixScaleFactor = f;
    }

    @Override
    public float getPixelScaleFactor() {
        return this.pixScaleFactor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean bl = false;
        try {
            Graphics graphics;
            boolean bl2;
            if (!this.validateStageGraphics()) {
                if (QuantumToolkit.verbose) {
                    System.err.println("UploadingPainter: validateStageGraphics failed");
                }
                this.paintImpl(null);
                return;
            }
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                return;
            }
            float f = this.pixScaleFactor;
            int n = Math.round((float)this.viewWidth * f);
            int n2 = Math.round((float)this.viewHeight * f);
            boolean bl3 = bl2 = this.penScale != f || this.penWidth != this.viewWidth || this.penHeight != this.viewHeight || this.rttexture == null;
            if (!bl2) {
                this.rttexture.lock();
                if (this.rttexture.isSurfaceLost()) {
                    this.rttexture.unlock();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    bl2 = true;
                }
            }
            if (bl2) {
                this.disposeRTTexture();
                this.rttexture = this.factory.createRTTexture(n, n2, Texture.WrapMode.CLAMP_NOT_NEEDED, this.sceneState.isMSAA());
                if (this.rttexture == null) {
                    return;
                }
                this.penScale = f;
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
                this.freshBackBuffer = true;
            }
            if ((graphics = this.rttexture.createGraphics()) == null) {
                this.disposeRTTexture();
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            graphics.scale(f, f);
            this.paintImpl(graphics);
            this.freshBackBuffer = false;
            Pixels pixels = this.pixelSource.getUnusedPixels(n, n2, f);
            IntBuffer intBuffer = (IntBuffer)pixels.getPixels();
            int[] nArray = this.rttexture.getPixels();
            if (nArray != null) {
                intBuffer.put(nArray, 0, n * n2);
            } else {
                RTTexture rTTexture;
                RTTexture rTTexture2 = rTTexture = this.rttexture.isMSAA() ? this.resolveRenderTarget(graphics) : this.rttexture;
                if (!rTTexture.readPixels(intBuffer)) {
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    this.disposeRTTexture();
                    pixels = null;
                }
            }
            if (this.rttexture != null) {
                this.rttexture.unlock();
            }
            if (pixels != null) {
                this.pixelSource.enqueuePixels(pixels);
                this.sceneState.uploadPixels(this.pixelSource);
            }
        }
        catch (Throwable throwable) {
            bl = true;
            throwable.printStackTrace(System.err);
        }
        finally {
            if (this.rttexture != null && this.rttexture.isLocked()) {
                this.rttexture.unlock();
            }
            if (this.resolveRTT != null && this.resolveRTT.isLocked()) {
                this.resolveRTT.unlock();
            }
            Disposer.cleanUp();
            this.sceneState.getScene().setPainting(false);
            if (this.factory != null) {
                this.factory.getTextureResourcePool().freeDisposalRequestedAndCheckResources(bl);
            }
            renderLock.unlock();
        }
    }

    private RTTexture resolveRenderTarget(Graphics graphics) {
        int n = this.rttexture.getContentWidth();
        int n2 = this.rttexture.getContentHeight();
        if (this.resolveRTT != null && (this.resolveRTT.getContentWidth() != n || this.resolveRTT.getContentHeight() != n2)) {
            this.resolveRTT.dispose();
            this.resolveRTT = null;
        }
        if (this.resolveRTT == null || this.resolveRTT.isSurfaceLost()) {
            this.resolveRTT = graphics.getResourceFactory().createRTTexture(n, n2, Texture.WrapMode.CLAMP_NOT_NEEDED, false);
        } else {
            this.resolveRTT.lock();
        }
        graphics.blit(this.rttexture, this.resolveRTT, 0, 0, n, n2, 0, 0, n, n2);
        return this.resolveRTT;
    }
}

