/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.caches.ehcache;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.ibatis.cache.Cache;
import org.apache.ibatis.cache.CacheException;

public final class EhcacheCache
implements Cache {
    private static final CacheManager CACHE_MANAGER = EhcacheCache.createCacheManager();
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final String id;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CacheManager createCacheManager() {
        CacheManager cacheManager;
        InputStream input = EhcacheCache.class.getResourceAsStream("/ehcache.xml");
        if (input != null) {
            try {
                cacheManager = CacheManager.create((InputStream)input);
            }
            catch (Throwable t) {
                cacheManager = CacheManager.create();
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        } else {
            cacheManager = CacheManager.create();
        }
        return cacheManager;
    }

    public EhcacheCache(String id) {
        if (id == null) {
            throw new IllegalArgumentException("Cache instances require an ID");
        }
        this.id = id;
        if (!CACHE_MANAGER.cacheExists(this.id)) {
            CACHE_MANAGER.addCache(this.id);
        }
    }

    public void clear() {
        this.getCache().removeAll();
    }

    public String getId() {
        return this.id;
    }

    public Object getObject(Object key) {
        try {
            Element cachedElement = this.getCache().get((Serializable)Integer.valueOf(key.hashCode()));
            if (cachedElement == null) {
                return null;
            }
            return cachedElement.getObjectValue();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public ReadWriteLock getReadWriteLock() {
        return this.readWriteLock;
    }

    public int getSize() {
        try {
            return this.getCache().getSize();
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public void putObject(Object key, Object value) {
        try {
            this.getCache().put(new Element((Object)key.hashCode(), value));
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    public Object removeObject(Object key) {
        try {
            Object obj = this.getObject(key);
            this.getCache().remove((Serializable)Integer.valueOf(key.hashCode()));
            return obj;
        }
        catch (Throwable t) {
            throw new CacheException(t);
        }
    }

    private Ehcache getCache() {
        return CACHE_MANAGER.getCache(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cache)) {
            return false;
        }
        Cache otherCache = (Cache)obj;
        return this.id.equals(otherCache.getId());
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String toString() {
        return "EHCache {" + this.id + "}";
    }
}

