/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rcp.application;

import com.jrockit.mc.commands.CommandsPlugin;
import com.jrockit.mc.rcp.application.ApplicationPlugin;
import com.jrockit.mc.rcp.application.ApplicationWorkbenchWindowAdvisor;
import com.jrockit.mc.rcp.application.BlockingWorkbenchErrorHandler;
import com.jrockit.mc.rcp.application.HighContrastModeChangeListener;
import com.jrockit.mc.rcp.application.OpenDocumentEventProcessor;
import java.text.ParseException;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchAdvisor;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;

public class ApplicationWorkbenchAdvisor
extends WorkbenchAdvisor {
    private final IApplicationContext m_context;
    private final OpenDocumentEventProcessor m_openDocProcessor;
    private AbstractStatusHandler workbenchErrorHandler;
    private boolean shouldExecuteCommands = true;

    ApplicationWorkbenchAdvisor(IApplicationContext context, OpenDocumentEventProcessor openDocProcessor) {
        this.m_context = context;
        this.m_openDocProcessor = openDocProcessor;
    }

    public WorkbenchWindowAdvisor createWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        return new ApplicationWorkbenchWindowAdvisor(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
        configurer.setSaveAndRestore(true);
        this.initializeHighContrastModeListener();
    }

    private void initializeHighContrastModeListener() {
        Display current = Display.getCurrent();
        current.addListener(39, (Listener)new HighContrastModeChangeListener(current.getHighContrast()));
    }

    public String getInitialWindowPerspectiveId() {
        return "com.jrockit.mc.ui.idesupport.StandardPerspective";
    }

    public void eventLoopIdle(Display display) {
        this.executeCommandsOnce();
        this.m_openDocProcessor.openFiles();
        super.eventLoopIdle(display);
    }

    private void executeCommandsOnce() {
        if (this.shouldExecuteCommands) {
            this.shouldExecuteCommands = false;
            Map arguments = this.m_context.getArguments();
            String[] appArguments = (String[])arguments.get("application.args");
            if (appArguments.length > 0) {
                this.execute(this.buildCommandText(appArguments).split(";"));
            }
        }
    }

    private void execute(String[] commands) {
        String[] stringArray = commands;
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            String command = stringArray[n2];
            try {
                CommandsPlugin.getDefault().execute(command, System.out);
            }
            catch (ParseException e) {
                ApplicationPlugin.getLogger().log(Level.WARNING, e.getMessage());
            }
            ++n2;
        }
    }

    private String buildCommandText(String[] appArguments) {
        StringBuilder builder = new StringBuilder();
        int n = 0;
        while (n < appArguments.length) {
            String arg = appArguments[n];
            if (arg.startsWith("-")) {
                if (n != 0) {
                    builder.append(';');
                }
                builder.append(arg.substring(1));
            } else {
                builder.append(" \"");
                builder.append(arg);
                builder.append('\"');
            }
            ++n;
        }
        return builder.toString();
    }

    public synchronized AbstractStatusHandler getWorkbenchErrorHandler() {
        if (this.workbenchErrorHandler == null) {
            this.workbenchErrorHandler = new BlockingWorkbenchErrorHandler();
        }
        return this.workbenchErrorHandler;
    }
}

