/*
 * Decompiled with CFR 0.152.
 */
package nl.justobjects.pushlet.core;

import java.io.IOException;
import nl.justobjects.pushlet.core.Command;
import nl.justobjects.pushlet.core.Config;
import nl.justobjects.pushlet.core.ConfigDefs;
import nl.justobjects.pushlet.core.Dispatcher;
import nl.justobjects.pushlet.core.Event;
import nl.justobjects.pushlet.core.Protocol;
import nl.justobjects.pushlet.core.Session;
import nl.justobjects.pushlet.core.Subscriber;
import nl.justobjects.pushlet.core.Subscription;
import nl.justobjects.pushlet.util.PushletException;

public class Controller
implements Protocol,
ConfigDefs {
    private Session session;

    protected Controller() {
    }

    public static Controller create(Session aSession) throws PushletException {
        Controller controller;
        try {
            controller = (Controller)Config.getClass("controller.class", "nl.justobjects.pushlet.core.Controller").newInstance();
        }
        catch (Throwable t) {
            throw new PushletException("Cannot instantiate Controller from config", t);
        }
        controller.session = aSession;
        return controller;
    }

    public void doCommand(Command aCommand) {
        try {
            this.session.kick();
            this.session.setAddress(aCommand.httpReq.getRemoteAddr());
            this.debug("doCommand() event=" + aCommand.reqEvent);
            String eventType = aCommand.reqEvent.getEventType();
            if (eventType.equals("refresh")) {
                this.doRefresh(aCommand);
            } else if (eventType.equals("subscribe")) {
                this.doSubscribe(aCommand);
            } else if (eventType.equals("unsubscribe")) {
                this.doUnsubscribe(aCommand);
            } else if (eventType.equals("join")) {
                this.doJoin(aCommand);
            } else if (eventType.equals("join-listen")) {
                this.doJoinListen(aCommand);
            } else if (eventType.equals("leave")) {
                this.doLeave(aCommand);
            } else if (eventType.equals("hb")) {
                this.doHeartbeat(aCommand);
            } else if (eventType.equals("publish")) {
                this.doPublish(aCommand);
            } else if (eventType.equals("listen")) {
                this.doListen(aCommand);
            }
            if (eventType.endsWith("listen") || eventType.equals("refresh")) {
                this.getSubscriber().fetchEvents(aCommand);
            } else {
                this.sendControlResponse(aCommand);
            }
        }
        catch (Throwable t) {
            this.warn("Exception in doCommand(): " + t);
            t.printStackTrace();
        }
    }

    public String toString() {
        return this.session.toString();
    }

    protected void doHeartbeat(Command aCommand) {
        aCommand.setResponseEvent(new Event("hb-ack"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doJoin(Command aCommand) throws PushletException {
        Event responseEvent = null;
        try {
            this.session.start();
            String format = aCommand.reqEvent.getField("p_format", "js");
            this.session.setFormat(format);
            responseEvent = new Event("join-ack");
            responseEvent.setField("p_id", this.session.getId());
            responseEvent.setField("p_format", format);
            this.info("joined");
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                this.session.stop();
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doJoin() error: " + t);
                t.printStackTrace();
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    protected void doJoinListen(Command aCommand) throws PushletException {
        this.doJoin(aCommand);
        if (!aCommand.getResponseEvent().getEventType().equals("nack")) {
            this.doListen(aCommand);
            if (!aCommand.getResponseEvent().getEventType().equals("nack")) {
                aCommand.getResponseEvent().setField("p_event", "join-listen-ack");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doLeave(Command aCommand) throws IOException {
        Event responseEvent = null;
        try {
            this.session.stop();
            responseEvent = new Event("leave-ack");
            responseEvent.setField("p_id", this.session.getId());
            this.info("left");
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doLeave() error: " + t);
                t.printStackTrace();
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    protected void doListen(Command aCommand) throws PushletException {
        String mode;
        block7: {
            mode = "stream";
            if (Config.getBoolProperty("listen.force.pull.all")) {
                mode = "pull";
            } else {
                mode = aCommand.reqEvent.getField("p_mode", "stream");
                String userAgent = aCommand.httpReq.getHeader("User-Agent");
                if (userAgent != null) {
                    userAgent = userAgent.toLowerCase();
                    int i = 0;
                    while (true) {
                        if (i >= Session.FORCED_PULL_AGENTS.length) break block7;
                        if (userAgent.indexOf(Session.FORCED_PULL_AGENTS[i]) != -1) {
                            this.info("Forcing pull mode for agent=" + userAgent);
                            mode = "pull";
                            break block7;
                        }
                        ++i;
                    }
                }
                userAgent = "unknown";
            }
        }
        this.getSubscriber().setMode(mode);
        Event listenAckEvent = new Event("listen-ack");
        String subject = aCommand.reqEvent.getField("p_subject");
        if (subject != null) {
            String label = aCommand.reqEvent.getField("p_label");
            Subscription subscription = this.getSubscriber().addSubscription(subject, label);
            listenAckEvent.setField("p_sid", subscription.getId());
            if (label != null) {
                listenAckEvent.setField("p_label", label);
            }
        }
        listenAckEvent.setField("p_id", this.session.getId());
        listenAckEvent.setField("p_mode", mode);
        listenAckEvent.setField("p_format", this.session.getFormat());
        this.getSubscriber().start();
        aCommand.setResponseEvent(listenAckEvent);
        this.info("Listening mode=" + mode + " userAgent=" + this.session.getUserAgent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPublish(Command aCommand) {
        Event responseEvent = null;
        try {
            String subject = aCommand.reqEvent.getField("p_subject");
            if (subject == null) {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "no subject provided");
            } else {
                aCommand.reqEvent.setField("p_from", this.session.getId());
                aCommand.reqEvent.setField("p_event", "data");
                String to = aCommand.reqEvent.getField("p_to");
                if (to != null) {
                    Dispatcher.getInstance().unicast(aCommand.reqEvent, to);
                } else {
                    this.debug("doPublish() event=" + aCommand.reqEvent);
                    Dispatcher.getInstance().multicast(aCommand.reqEvent);
                }
                responseEvent = new Event("publish-ack");
            }
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doPublish() error: " + t);
                t.printStackTrace();
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    protected void doRefresh(Command aCommand) {
        aCommand.setResponseEvent(new Event("refresh-ack"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doSubscribe(Command aCommand) throws IOException {
        Event responseEvent = null;
        try {
            String subject = aCommand.reqEvent.getField("p_subject");
            Subscription subscription = null;
            if (subject == null) {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "no subject provided");
            } else {
                String label = aCommand.reqEvent.getField("p_label");
                subscription = this.getSubscriber().addSubscription(subject, label);
                responseEvent = new Event("subscribe-ack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_subject", subject);
                responseEvent.setField("p_sid", subscription.getId());
                if (label != null) {
                    responseEvent.setField("p_label", label);
                }
                this.info("subscribed to " + subject + " sid=" + subscription.getId());
            }
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doSubscribe() error: " + t);
                t.printStackTrace();
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUnsubscribe(Command aCommand) throws IOException {
        Event responseEvent = null;
        try {
            String subscriptionId = aCommand.reqEvent.getField("p_sid");
            if (subscriptionId == null) {
                this.getSubscriber().removeSubscriptions();
                responseEvent = new Event("unsubscribe-ack");
                responseEvent.setField("p_id", this.session.getId());
                this.info("unsubscribed all");
            } else {
                Subscription subscription = this.getSubscriber().removeSubscription(subscriptionId);
                if (subscription == null) {
                    responseEvent = new Event("nack");
                    responseEvent.setField("p_id", this.session.getId());
                    responseEvent.setField("p_reason", "no subscription for sid=" + subscriptionId);
                    this.warn("unsubscribe: no subscription for sid=" + subscriptionId);
                } else {
                    responseEvent = new Event("unsubscribe-ack");
                    responseEvent.setField("p_id", this.session.getId());
                    responseEvent.setField("p_sid", subscription.getId());
                    responseEvent.setField("p_subject", subscription.getSubject());
                    if (subscription.getLabel() != null) {
                        responseEvent.setField("p_label", subscription.getLabel());
                    }
                    this.info("unsubscribed sid= " + subscriptionId);
                }
            }
            aCommand.setResponseEvent(responseEvent);
        }
        catch (Throwable t) {
            try {
                responseEvent = new Event("nack");
                responseEvent.setField("p_id", this.session.getId());
                responseEvent.setField("p_reason", "unexpected error: " + t);
                this.warn("doUnsubscribe() error: " + t);
                t.printStackTrace();
                aCommand.setResponseEvent(responseEvent);
            }
            catch (Throwable throwable) {
                aCommand.setResponseEvent(responseEvent);
                throw throwable;
            }
        }
    }

    public Subscriber getSubscriber() {
        return this.session.getSubscriber();
    }

    protected void sendControlResponse(Command aCommand) {
        try {
            aCommand.sendResponseHeaders();
            aCommand.getClientAdapter().start();
            aCommand.getClientAdapter().push(aCommand.getResponseEvent());
            aCommand.getClientAdapter().stop();
        }
        catch (Throwable t) {
            this.session.stop();
        }
    }

    protected void info(String s) {
        this.session.info("[Controller] " + s);
    }

    protected void warn(String s) {
        this.session.warn("[Controller] " + s);
    }

    protected void debug(String s) {
        this.session.debug("[Controller] " + s);
    }
}

