/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.logging.jdbc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.jdbc.BaseJdbcLogger;
import org.apache.ibatis.logging.jdbc.ResultSetLogger;
import org.apache.ibatis.reflection.ExceptionUtil;

public final class StatementLogger
extends BaseJdbcLogger
implements InvocationHandler {
    private Statement statement;

    private StatementLogger(Statement stmt, Log statementLog, int queryStack) {
        super(statementLog, queryStack);
        this.statement = stmt;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] params) throws Throwable {
        try {
            if (Object.class.equals(method.getDeclaringClass())) {
                return method.invoke((Object)this, params);
            }
            if (EXECUTE_METHODS.contains(method.getName())) {
                if (this.isDebugEnabled()) {
                    this.debug(" Executing: " + this.removeBreakingWhitespace((String)params[0]), true);
                }
                if (!"executeQuery".equals(method.getName())) {
                    return method.invoke((Object)this.statement, params);
                }
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
                }
                return null;
            }
            if ("getResultSet".equals(method.getName())) {
                ResultSet rs = (ResultSet)method.invoke((Object)this.statement, params);
                if (rs != null) {
                    return ResultSetLogger.newInstance(rs, this.statementLog, this.queryStack);
                }
                return null;
            }
            if ("equals".equals(method.getName())) {
                Object ps = params[0];
                if (ps instanceof Proxy && proxy == ps) {
                    return true;
                }
                return false;
            }
            if ("hashCode".equals(method.getName())) {
                return proxy.hashCode();
            }
            return method.invoke((Object)this.statement, params);
        }
        catch (Throwable t) {
            throw ExceptionUtil.unwrapThrowable(t);
        }
    }

    public static Statement newInstance(Statement stmt, Log statementLog, int queryStack) {
        StatementLogger handler = new StatementLogger(stmt, statementLog, queryStack);
        ClassLoader cl = Statement.class.getClassLoader();
        return (Statement)Proxy.newProxyInstance(cl, new Class[]{Statement.class}, (InvocationHandler)handler);
    }

    public Statement getStatement() {
        return this.statement;
    }
}

