/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.frame.draft76;

import com.taobao.top.link.embedded.websocket.frame.Frame;
import com.taobao.top.link.embedded.websocket.frame.FrameHeader;
import com.taobao.top.link.embedded.websocket.frame.draft76.BinaryFrame;
import com.taobao.top.link.embedded.websocket.frame.draft76.CloseFrame;
import com.taobao.top.link.embedded.websocket.frame.draft76.FrameHeaderDraft76;
import com.taobao.top.link.embedded.websocket.frame.draft76.TextFrame;
import java.nio.ByteBuffer;

public class FrameBuilderDraft76 {
    public static FrameHeader createFrameHeader(ByteBuffer chunkData) {
        if (chunkData == null) {
            throw new IllegalArgumentException("Data is null.");
        }
        int length = chunkData.limit() - chunkData.position();
        if (length < 2) {
            return null;
        }
        int payloadLength = 0;
        byte type = chunkData.get();
        int position = chunkData.position();
        if (0 <= type && type <= 127) {
            chunkData.mark();
            boolean completed = false;
            while (chunkData.hasRemaining() && !completed) {
                if (chunkData.get() != -1) continue;
                completed = true;
            }
            if (!completed) {
                return null;
            }
            payloadLength = chunkData.position() - position;
            chunkData.reset();
        } else if (-128 <= type && type <= -1) {
            boolean completed = false;
            while (chunkData.hasRemaining() && !completed) {
                byte lengthByte = chunkData.get();
                int length7Bit = lengthByte & 0x7F;
                payloadLength = payloadLength << 7 | length7Bit;
                if (length7Bit != lengthByte) continue;
                completed = true;
            }
            if (!completed) {
                return null;
            }
        } else {
            throw new IllegalStateException("Not found Opcode type! (" + type + ")");
        }
        return new FrameHeaderDraft76(type, payloadLength);
    }

    public static Frame createFrame(FrameHeader h, byte[] bodyData) {
        FrameHeaderDraft76 header = (FrameHeaderDraft76)h;
        if (0 <= header.getFrameType() && header.getFrameType() <= 127) {
            return new TextFrame(header, bodyData);
        }
        if (-128 <= header.getFrameType() && header.getFrameType() <= -1) {
            if (bodyData.length == 1 && bodyData[0] == 0) {
                return new CloseFrame(header, bodyData);
            }
            return new BinaryFrame(header, bodyData);
        }
        throw new IllegalStateException("Not found Opcode type! (" + header.getFrameType() + ")");
    }
}

