/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.auth;

import com.taobao.top.link.embedded.websocket.auth.AbstractAuthenticator;
import com.taobao.top.link.embedded.websocket.auth.AuthScheme;
import com.taobao.top.link.embedded.websocket.auth.BasicAuthenticator;
import com.taobao.top.link.embedded.websocket.auth.Challenge;
import com.taobao.top.link.embedded.websocket.auth.DigestAuthenticator;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import java.util.EnumMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultAuthenticator
extends AbstractAuthenticator {
    private BasicAuthenticator basicAuthenticator;
    private DigestAuthenticator digestAuthenticator;

    public DefaultAuthenticator() {
        this.basicAuthenticator = new BasicAuthenticator();
        this.digestAuthenticator = new DigestAuthenticator();
    }

    public DefaultAuthenticator(BasicAuthenticator basicAuthenticator, DigestAuthenticator digestAuthenticator) {
        this.basicAuthenticator = basicAuthenticator;
        this.digestAuthenticator = digestAuthenticator;
    }

    @Override
    public String getCredentials(List<Challenge> challengeList) throws WebSocketException {
        EnumMap<AuthScheme, Challenge> schemeMap = new EnumMap<AuthScheme, Challenge>(AuthScheme.class);
        for (Challenge challenge : challengeList) {
            schemeMap.put(challenge.getScheme(), challenge);
        }
        if (schemeMap.containsKey((Object)AuthScheme.Digest)) {
            this.digestAuthenticator.init(this.websocket, this.credentials);
            return this.digestAuthenticator.getCredentials((Challenge)schemeMap.get((Object)AuthScheme.Digest));
        }
        if (schemeMap.containsKey((Object)AuthScheme.Basic)) {
            this.basicAuthenticator.init(this.websocket, this.credentials);
            return this.basicAuthenticator.getCredentials((Challenge)schemeMap.get((Object)AuthScheme.Basic));
        }
        return null;
    }
}

