/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.ApiException;
import com.taobao.api.TaobaoResponse;
import com.taobao.api.internal.parser.json.ObjectJsonParser;
import com.taobao.api.internal.util.Base64;
import com.taobao.api.internal.util.RequestParametersHolder;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.WebUtils;
import com.taobao.api.internal.util.json.JSONReader;
import com.taobao.api.internal.util.json.JSONValidatingReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.InetAddress;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TaobaoUtils {
    private TaobaoUtils() {
    }

    public static String signTopRequest(RequestParametersHolder requestHolder, String secret) throws IOException {
        Map<String, String> params = requestHolder.getAllParams();
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder(secret);
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        byte[] bytes = TaobaoUtils.encryptMD5(query.toString());
        return TaobaoUtils.byte2hex(bytes);
    }

    public static String signTopRequestNew(RequestParametersHolder requestHolder, String secret, boolean isHmac) throws IOException {
        return TaobaoUtils.signTopRequestNew(requestHolder.getAllParams(), secret, isHmac);
    }

    public static String signTopRequestNew(Map<String, String> params, String secret, boolean isHmac) throws IOException {
        byte[] bytes;
        Object[] keys = params.keySet().toArray(new String[0]);
        Arrays.sort(keys);
        StringBuilder query = new StringBuilder();
        if (!isHmac) {
            query.append(secret);
        }
        for (Object key : keys) {
            String value = params.get(key);
            if (!StringUtils.areNotEmpty(new String[]{key, value})) continue;
            query.append((String)key).append(value);
        }
        if (isHmac) {
            bytes = TaobaoUtils.encryptHMAC(query.toString(), secret);
        } else {
            query.append(secret);
            bytes = TaobaoUtils.encryptMD5(query.toString());
        }
        return TaobaoUtils.byte2hex(bytes);
    }

    private static byte[] encryptHMAC(String data, String secret) throws IOException {
        byte[] bytes = null;
        try {
            SecretKeySpec secretKey = new SecretKeySpec(secret.getBytes("UTF-8"), "HmacMD5");
            Mac mac = Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
            bytes = mac.doFinal(data.getBytes("UTF-8"));
        }
        catch (GeneralSecurityException gse) {
            String msg = TaobaoUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    private static String getStringFromException(Throwable e) {
        String result = "";
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        e.printStackTrace(ps);
        try {
            result = bos.toString("UTF-8");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return result;
    }

    public static byte[] encryptMD5(String data) throws IOException {
        return TaobaoUtils.encryptMD5(data.getBytes("UTF-8"));
    }

    public static byte[] encryptMD5(byte[] data) throws IOException {
        byte[] bytes = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            bytes = md.digest(data);
        }
        catch (GeneralSecurityException gse) {
            String msg = TaobaoUtils.getStringFromException(gse);
            throw new IOException(msg);
        }
        return bytes;
    }

    public static String byte2hex(byte[] bytes) {
        StringBuilder sign = new StringBuilder();
        for (int i = 0; i < bytes.length; ++i) {
            String hex = Integer.toHexString(bytes[i] & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static boolean verifyTopResponse(String topParams, String topSession, String topSign, String appKey, String appSecret) throws IOException {
        StringBuilder result = new StringBuilder();
        result.append(appKey).append(topParams).append(topSession).append(appSecret);
        byte[] bytes = TaobaoUtils.encryptMD5(result.toString());
        return Base64.encodeToString(bytes, false).equals(topSign);
    }

    public static Map<String, String> decodeTopParams(String topParams) throws IOException {
        return TaobaoUtils.decodeTopParams(topParams, "GBK");
    }

    public static Map<String, String> decodeTopParams(String topParams, String charset) throws IOException {
        if (StringUtils.isEmpty(topParams)) {
            return null;
        }
        byte[] buffer = Base64.decode(WebUtils.decode(topParams).getBytes());
        String originTopParams = new String(buffer, charset);
        return WebUtils.splitUrlQuery(originTopParams);
    }

    public static String getFileSuffix(byte[] bytes) {
        if (bytes == null || bytes.length < 10) {
            return null;
        }
        if (bytes[0] == 71 && bytes[1] == 73 && bytes[2] == 70) {
            return "GIF";
        }
        if (bytes[1] == 80 && bytes[2] == 78 && bytes[3] == 71) {
            return "PNG";
        }
        if (bytes[6] == 74 && bytes[7] == 70 && bytes[8] == 73 && bytes[9] == 70) {
            return "JPG";
        }
        if (bytes[0] == 66 && bytes[1] == 77) {
            return "BMP";
        }
        return null;
    }

    public static String getMimeType(byte[] bytes) {
        String suffix = TaobaoUtils.getFileSuffix(bytes);
        String mimeType = "JPG".equals(suffix) ? "image/jpeg" : ("GIF".equals(suffix) ? "image/gif" : ("PNG".equals(suffix) ? "image/png" : ("BMP".equals(suffix) ? "image/bmp" : "application/octet-stream")));
        return mimeType;
    }

    public static <V> Map<String, V> cleanupMap(Map<String, V> map) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        HashMap<String, V> result = new HashMap<String, V>(map.size());
        Set<Map.Entry<String, V>> entries = map.entrySet();
        for (Map.Entry<String, V> entry : entries) {
            if (entry.getValue() == null) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public static Map<?, ?> parseJson(String body) {
        JSONValidatingReader jr = new JSONValidatingReader();
        Object obj = ((JSONReader)jr).read(body);
        if (obj instanceof Map) {
            return (Map)obj;
        }
        return null;
    }

    public static <T extends TaobaoResponse> T parseResponse(String json, Class<T> clazz) throws ApiException {
        ObjectJsonParser<T> parser = new ObjectJsonParser<T>(clazz);
        T rsp = parser.parse(json);
        ((TaobaoResponse)rsp).setBody(json);
        return rsp;
    }

    public static String getIntranetIp() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception e) {
            return "127.0.0.1";
        }
    }
}

