/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.messaging;

import org.springframework.messaging.Message;
import org.springframework.util.Assert;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.messaging.AbstractSubProtocolEvent;

public class SessionDisconnectEvent
extends AbstractSubProtocolEvent {
    private final String sessionId;
    private final CloseStatus status;

    public SessionDisconnectEvent(Object source, Message<byte[]> message, String sessionId, CloseStatus closeStatus) {
        super(source, message);
        Assert.notNull((Object)sessionId, (String)"'sessionId' must not be null");
        this.sessionId = sessionId;
        this.status = closeStatus;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public CloseStatus getCloseStatus() {
        return this.status;
    }

    @Override
    public String toString() {
        return "SessionDisconnectEvent[sessionId=" + this.sessionId + ", " + (this.status != null ? this.status.toString() : "closeStatus=null") + "]";
    }
}

