/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.FileItem;
import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WebUtils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static boolean ignoreSSLCheck = true;
    private static boolean ignoreHostCheck = true;

    private WebUtils() {
    }

    public static void setIgnoreSSLCheck(boolean ignoreSSLCheck) {
        WebUtils.ignoreSSLCheck = ignoreSSLCheck;
    }

    public static void setIgnoreHostCheck(boolean ignoreHostCheck) {
        WebUtils.ignoreHostCheck = ignoreHostCheck;
    }

    public static String doPost(String url, Map<String, String> params, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, charset, connectTimeout, readTimeout, null, null);
    }

    public static String doPost(String url, Map<String, String> params, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String ctype = "application/x-www-form-urlencoded;charset=" + charset;
        String query = WebUtils.buildQuery(params, charset);
        byte[] content = new byte[]{};
        if (query != null) {
            content = query.getBytes(charset);
        }
        return WebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, headerMap, proxy);
    }

    public static String doPost(String url, String apiBody, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String ctype = "text/plain;charset=" + charset;
        byte[] content = apiBody.getBytes(charset);
        return WebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, headerMap, null);
    }

    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, null, null);
    }

    public static String doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        return WebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, headerMap, proxy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPost(String url, String ctype, byte[] content, int connectTimeout, int readTimeout, Map<String, String> headerMap, Proxy proxy) throws IOException {
        String rsp;
        HttpURLConnection conn;
        block5: {
            conn = null;
            OutputStream out = null;
            rsp = null;
            try {
                conn = WebUtils.getConnection(new URL(url), "POST", ctype, headerMap, proxy);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                out = conn.getOutputStream();
                out.write(content);
                rsp = WebUtils.getResponseAsString(conn);
                Object var11_10 = null;
                if (out == null) break block5;
            }
            catch (Throwable throwable) {
                Object var11_11 = null;
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
            out.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return rsp;
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, int connectTimeout, int readTimeout) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, params, DEFAULT_CHARSET, connectTimeout, readTimeout);
        }
        return WebUtils.doPost(url, params, fileParams, DEFAULT_CHARSET, connectTimeout, readTimeout);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout) throws IOException {
        return WebUtils.doPost(url, params, fileParams, charset, connectTimeout, readTimeout, null);
    }

    public static String doPost(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        if (fileParams == null || fileParams.isEmpty()) {
            return WebUtils.doPost(url, params, charset, connectTimeout, readTimeout, headerMap, null);
        }
        return WebUtils._doPostWithFile(url, params, fileParams, charset, connectTimeout, readTimeout, headerMap);
    }

    public static String doPostWithJson(String url, Map<String, Object> params, String charset, int connectTimeout, int readTimeout) throws IOException {
        String ctype = "application/json;charset=" + charset;
        byte[] content = new byte[]{};
        String body = TaobaoUtils.objectToJson(params);
        if (body != null) {
            content = body.getBytes(charset);
        }
        return WebUtils._doPost(url, ctype, content, connectTimeout, readTimeout, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _doPostWithFile(String url, Map<String, String> params, Map<String, FileItem> fileParams, String charset, int connectTimeout, int readTimeout, Map<String, String> headerMap) throws IOException {
        String rsp;
        HttpURLConnection conn;
        block8: {
            String boundary = String.valueOf(System.nanoTime());
            conn = null;
            OutputStream out = null;
            rsp = null;
            try {
                String ctype = "multipart/form-data;charset=" + charset + ";boundary=" + boundary;
                conn = WebUtils.getConnection(new URL(url), "POST", ctype, headerMap, null);
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
                out = conn.getOutputStream();
                byte[] entryBoundaryBytes = ("\r\n--" + boundary + "\r\n").getBytes(charset);
                Set<Map.Entry<String, String>> textEntrySet = params.entrySet();
                for (Map.Entry<String, String> textEntry : textEntrySet) {
                    byte[] textBytes = WebUtils.getTextEntry(textEntry.getKey(), textEntry.getValue(), charset);
                    out.write(entryBoundaryBytes);
                    out.write(textBytes);
                }
                Set<Map.Entry<String, FileItem>> fileEntrySet = fileParams.entrySet();
                for (Map.Entry<String, FileItem> fileEntry : fileEntrySet) {
                    FileItem fileItem = fileEntry.getValue();
                    if (!fileItem.isValid()) {
                        throw new IOException("FileItem is invalid");
                    }
                    byte[] fileBytes = WebUtils.getFileEntry(fileEntry.getKey(), fileItem.getFileName(), fileItem.getMimeType(), charset);
                    out.write(entryBoundaryBytes);
                    out.write(fileBytes);
                    fileItem.write(out);
                }
                byte[] endBoundaryBytes = ("\r\n--" + boundary + "--\r\n").getBytes(charset);
                out.write(endBoundaryBytes);
                rsp = WebUtils.getResponseAsString(conn);
                Object var20_19 = null;
                if (out == null) break block8;
            }
            catch (Throwable throwable) {
                Object var20_20 = null;
                if (out != null) {
                    out.close();
                }
                if (conn != null) {
                    conn.disconnect();
                }
                throw throwable;
            }
            out.close();
        }
        if (conn != null) {
            conn.disconnect();
        }
        return rsp;
    }

    private static byte[] getTextEntry(String fieldName, String fieldValue, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\"\r\nContent-Type:text/plain\r\n\r\n");
        entry.append(fieldValue);
        return entry.toString().getBytes(charset);
    }

    private static byte[] getFileEntry(String fieldName, String fileName, String mimeType, String charset) throws IOException {
        StringBuilder entry = new StringBuilder();
        entry.append("Content-Disposition:form-data;name=\"");
        entry.append(fieldName);
        entry.append("\";filename=\"");
        entry.append(fileName);
        entry.append("\"\r\nContent-Type:");
        entry.append(mimeType);
        entry.append("\r\n\r\n");
        return entry.toString().getBytes(charset);
    }

    public static String doGet(String url, Map<String, String> params) throws IOException {
        return WebUtils.doGet(url, params, DEFAULT_CHARSET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doGet(String url, Map<String, String> params, String charset) throws IOException {
        HttpURLConnection conn = null;
        String rsp = null;
        try {
            String ctype = "application/x-www-form-urlencoded;charset=" + charset;
            String query = WebUtils.buildQuery(params, charset);
            conn = WebUtils.getConnection(WebUtils.buildGetUrl(url, query), "GET", ctype, null, null);
            rsp = WebUtils.getResponseAsString(conn);
            Object var8_7 = null;
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (conn != null) {
                conn.disconnect();
            }
            throw throwable;
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, String ctype, Map<String, String> headerMap, Proxy proxy) throws IOException {
        HttpURLConnection conn = null;
        conn = proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(proxy);
        if (conn instanceof HttpsURLConnection) {
            HttpsURLConnection connHttps = (HttpsURLConnection)conn;
            if (ignoreSSLCheck) {
                try {
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    ctx.init(null, new TrustManager[]{new TrustAllTrustManager()}, new SecureRandom());
                    connHttps.setSSLSocketFactory(ctx.getSocketFactory());
                    connHttps.setHostnameVerifier(new HostnameVerifier(){

                        public boolean verify(String hostname, SSLSession session) {
                            return true;
                        }
                    });
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            } else if (ignoreHostCheck) {
                connHttps.setHostnameVerifier(new HostnameVerifier(){

                    public boolean verify(String hostname, SSLSession session) {
                        return true;
                    }
                });
            }
            conn = connHttps;
        }
        conn.setRequestMethod(method);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        if (headerMap != null && headerMap.get("TOP_HTTP_DNS_HOST") != null) {
            conn.setRequestProperty("Host", headerMap.get("TOP_HTTP_DNS_HOST"));
        } else {
            conn.setRequestProperty("Host", url.getHost());
        }
        conn.setRequestProperty("Accept", "text/xml,text/javascript");
        conn.setRequestProperty("User-Agent", "top-sdk-java");
        conn.setRequestProperty("Content-Type", ctype);
        if (headerMap != null) {
            for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                if ("TOP_HTTP_DNS_HOST".equals(entry.getKey())) continue;
                conn.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return conn;
    }

    private static URL buildGetUrl(String url, String query) throws IOException {
        if (StringUtils.isEmpty(query)) {
            return new URL(url);
        }
        return new URL(WebUtils.buildRequestUrl(url, query));
    }

    public static String buildRequestUrl(String url, String ... queries) {
        if (queries == null || queries.length == 0) {
            return url;
        }
        StringBuilder newUrl = new StringBuilder(url);
        boolean hasQuery = url.contains("?");
        boolean hasPrepend = url.endsWith("?") || url.endsWith("&");
        for (String query : queries) {
            if (StringUtils.isEmpty(query)) continue;
            if (!hasPrepend) {
                if (hasQuery) {
                    newUrl.append("&");
                } else {
                    newUrl.append("?");
                    hasQuery = true;
                }
            }
            newUrl.append(query);
            hasPrepend = false;
        }
        return newUrl.toString();
    }

    public static String buildQuery(Map<String, String> params, String charset) throws IOException {
        if (params == null || params.isEmpty()) {
            return null;
        }
        StringBuilder query = new StringBuilder();
        Set<Map.Entry<String, String>> entries = params.entrySet();
        boolean hasParam = false;
        for (Map.Entry<String, String> entry : entries) {
            String value;
            String name = entry.getKey();
            if (!StringUtils.areNotEmpty(name, value = entry.getValue())) continue;
            if (hasParam) {
                query.append("&");
            } else {
                hasParam = true;
            }
            query.append(name).append("=").append(URLEncoder.encode(value, charset));
        }
        return query.toString();
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        InputStream error;
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        if (conn.getResponseCode() < 400) {
            String contentEncoding = conn.getContentEncoding();
            if ("gzip".equalsIgnoreCase(contentEncoding)) {
                return WebUtils.getStreamAsString(new GZIPInputStream(conn.getInputStream()), charset);
            }
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        if (conn.getResponseCode() == 400 && (error = conn.getErrorStream()) != null) {
            return WebUtils.getStreamAsString(error, charset);
        }
        throw new IOException(conn.getResponseCode() + " " + conn.getResponseMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStreamAsString(InputStream stream, String charset) throws IOException {
        String string;
        block3: {
            try {
                InputStreamReader reader = new InputStreamReader(stream, charset);
                StringBuilder response = new StringBuilder();
                char[] buff = new char[1024];
                int read = 0;
                while ((read = reader.read(buff)) > 0) {
                    response.append(buff, 0, read);
                }
                string = response.toString();
                Object var8_7 = null;
                if (stream == null) break block3;
            }
            catch (Throwable throwable) {
                block4: {
                    Object var8_8 = null;
                    if (stream == null) break block4;
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        return string;
    }

    public static String getResponseCharset(String ctype) {
        String charset = DEFAULT_CHARSET;
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    public static String decode(String value) {
        return WebUtils.decode(value, DEFAULT_CHARSET);
    }

    public static String encode(String value) {
        return WebUtils.encode(value, DEFAULT_CHARSET);
    }

    public static String decode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLDecoder.decode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static String encode(String value, String charset) {
        String result = null;
        if (!StringUtils.isEmpty(value)) {
            try {
                result = URLEncoder.encode(value, charset);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Map<String, String> splitUrlQuery(String query) {
        HashMap<String, String> result = new HashMap<String, String>();
        String[] pairs = query.split("&");
        if (pairs != null && pairs.length > 0) {
            for (String pair : pairs) {
                String[] param = pair.split("=", 2);
                if (param == null || param.length != 2) continue;
                result.put(param[0], param[1]);
            }
        }
        return result;
    }

    public static class TrustAllTrustManager
    implements X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }
}

