/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded;

import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.ExpandedPair;
import java.util.List;

final class BitArrayBuilder {
    private BitArrayBuilder() {
    }

    static BitArray buildBitArray(List<ExpandedPair> pairs) {
        int charNumber = pairs.size() * 2 - 1;
        if (pairs.get(pairs.size() - 1).getRightChar() == null) {
            --charNumber;
        }
        int size = 12 * charNumber;
        BitArray binary = new BitArray(size);
        int accPos = 0;
        ExpandedPair firstPair = pairs.get(0);
        int firstValue = firstPair.getRightChar().getValue();
        int i = 11;
        while (i >= 0) {
            if ((firstValue & 1 << i) != 0) {
                binary.set(accPos);
            }
            ++accPos;
            --i;
        }
        i = 1;
        while (i < pairs.size()) {
            ExpandedPair currentPair = pairs.get(i);
            int leftValue = currentPair.getLeftChar().getValue();
            int j = 11;
            while (j >= 0) {
                if ((leftValue & 1 << j) != 0) {
                    binary.set(accPos);
                }
                ++accPos;
                --j;
            }
            if (currentPair.getRightChar() != null) {
                int rightValue = currentPair.getRightChar().getValue();
                int j2 = 11;
                while (j2 >= 0) {
                    if ((rightValue & 1 << j2) != 0) {
                        binary.set(accPos);
                    }
                    ++accPos;
                    --j2;
                }
            }
            ++i;
        }
        return binary;
    }
}

