/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ibatis.mapping;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.ibatis.executor.BaseExecutor;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.mapping.DatabaseIdProvider;

public class VendorDatabaseIdProvider
implements DatabaseIdProvider {
    private static final Log log = LogFactory.getLog(BaseExecutor.class);
    private Properties properties;

    @Override
    public String getDatabaseId(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource cannot be null");
        }
        try {
            return this.getDatabaseName(dataSource);
        }
        catch (Exception e) {
            log.error("Could not get a databaseId from dataSource", e);
            return null;
        }
    }

    @Override
    public void setProperties(Properties p) {
        this.properties = p;
    }

    private String getDatabaseName(DataSource dataSource) throws SQLException {
        String productName = this.getDatabaseProductName(dataSource);
        if (this.properties != null) {
            for (Map.Entry<Object, Object> property : this.properties.entrySet()) {
                if (!productName.contains((String)property.getKey())) continue;
                return (String)property.getValue();
            }
            return null;
        }
        return productName;
    }

    private String getDatabaseProductName(DataSource dataSource) throws SQLException {
        Connection con = null;
        try {
            con = dataSource.getConnection();
            DatabaseMetaData metaData = con.getMetaData();
            String string = metaData.getDatabaseProductName();
            return string;
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

