/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tools.packager;

import com.oracle.tools.packager.Bundler;
import com.oracle.tools.packager.Bundlers;
import com.oracle.tools.packager.ConfigException;
import com.oracle.tools.packager.Log;
import com.oracle.tools.packager.RelativeFileSet;
import com.oracle.tools.packager.UnsupportedPlatformException;
import com.sun.javafx.tools.packager.CreateBSSParams;
import com.sun.javafx.tools.packager.CreateJarParams;
import com.sun.javafx.tools.packager.DeployParams;
import com.sun.javafx.tools.packager.HtmlParam;
import com.sun.javafx.tools.packager.JSCallback;
import com.sun.javafx.tools.packager.JarSignature;
import com.sun.javafx.tools.packager.MakeAllParams;
import com.sun.javafx.tools.packager.PackagerException;
import com.sun.javafx.tools.packager.Param;
import com.sun.javafx.tools.packager.SignJarParams;
import com.sun.javafx.tools.packager.TemplatePlaceholders;
import com.sun.javafx.tools.packager.bundlers.BundleParams;
import com.sun.javafx.tools.packager.bundlers.Bundler;
import com.sun.javafx.tools.resource.DeployResource;
import com.sun.javafx.tools.resource.PackagerResource;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class PackagerLib {
    public static final String JAVAFX_VERSION = "8.0";
    private static final ResourceBundle bundle = ResourceBundle.getBundle("com/sun/javafx/tools/packager/Bundle");
    private static final String dtFX = "dtjava.js";
    private static final String webfilesDir = "web-files";
    private static final String EMBEDDED_DT = "./web-files/dtjava.js";
    private static final String PUBLIC_DT = "http://java.com/js/dtjava.js";
    private CreateJarParams createJarParams;
    private DeployParams deployParams;
    private CreateBSSParams createBssParams;
    private File bssTmpDir;
    private ClassLoader classLoader;
    private Set<String> alreadyAddedEntries = new HashSet<String>();
    private static String[] webFiles = new String[]{"javafx-loading-100x100.gif", "dtjava.js", "javafx-loading-25x25.gif", "error.png", "upgrade_java.png", "javafx-chrome.png", "get_java.png", "upgrade_javafx.png", "get_javafx.png"};
    private static String prefixWebFiles = "/resources/web-files/";

    private ClassLoader getClassLoader() throws PackagerException {
        if (this.classLoader == null) {
            try {
                URL[] uRLArray = new URL[]{new URL(this.getJfxrtPath())};
                this.classLoader = URLClassLoader.newInstance(uRLArray);
            }
            catch (MalformedURLException malformedURLException) {
                throw new PackagerException(malformedURLException, "ERR_CantFindRuntime", new String[0]);
            }
        }
        return this.classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File jarFileToUpdate(CreateJarParams createJarParams) {
        if (createJarParams.resources.size() != 1) return null;
        PackagerResource packagerResource = createJarParams.resources.get(0);
        File file2 = packagerResource.getFile();
        if (!file2.isFile()) return null;
        if (!file2.getAbsolutePath().toLowerCase().endsWith(".jar")) {
            return null;
        }
        try (JarFile jarFile = new JarFile(file2);){
            jarFile.getManifest();
            File file = file2;
            return file;
        }
        catch (Exception exception) {
            Log.verbose(exception);
        }
        return null;
    }

    public void packageAsJar(CreateJarParams createJarParams) throws PackagerException {
        Attributes attributes;
        Serializable serializable;
        Object object;
        if (createJarParams == null) {
            throw new IllegalArgumentException("Parameters must not be null");
        }
        if (createJarParams.outfile == null) {
            throw new IllegalArgumentException("Output file is not specified");
        }
        this.createJarParams = createJarParams;
        Serializable serializable2 = this.jarFileToUpdate(createJarParams);
        Manifest manifest = null;
        if (serializable2 != null) {
            Log.info(MessageFormat.format(bundle.getString("MSG_UpdatingJar"), serializable2.getAbsolutePath()));
            try {
                object = new JarFile((File)serializable2);
                serializable = null;
                try {
                    manifest = ((JarFile)object).getManifest();
                    if (manifest != null) {
                        attributes = manifest.getMainAttributes();
                        if (createJarParams.applicationClass == null) {
                            createJarParams.applicationClass = attributes.getValue(Attributes.Name.MAIN_CLASS);
                        }
                        if (createJarParams.classpath == null) {
                            createJarParams.classpath = attributes.getValue(Attributes.Name.CLASS_PATH);
                        }
                    }
                }
                catch (Throwable throwable) {
                    serializable = throwable;
                    throw throwable;
                }
                finally {
                    if (object != null) {
                        if (serializable != null) {
                            try {
                                ((ZipFile)object).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)serializable).addSuppressed(throwable);
                            }
                        } else {
                            ((ZipFile)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_FileReadFailed", serializable2.getAbsolutePath());
            }
        }
        if (createJarParams.applicationClass == null) {
            throw new IllegalArgumentException("Main application class is not specified");
        }
        object = new File(createJarParams.outdir, createJarParams.outfile.endsWith(".jar") ? createJarParams.outfile : createJarParams.outfile + ".jar");
        if (serializable2 != null && ((File)object).getAbsoluteFile().equals(serializable2.getAbsoluteFile())) {
            try {
                serializable = File.createTempFile("tempcopy", ".jar");
                Files.move(serializable2.toPath(), ((File)serializable).toPath(), StandardCopyOption.REPLACE_EXISTING);
                serializable2 = serializable;
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_FileCopyFailed", serializable2.getAbsolutePath());
            }
        }
        if ((serializable = ((File)object).getParentFile()) != null) {
            ((File)serializable).mkdirs();
        }
        if (manifest == null) {
            manifest = new Manifest();
        }
        attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Created-By"), "JavaFX Packager");
        if (createJarParams.manifestAttrs != null) {
            for (Map.Entry<String, String> iterator : createJarParams.manifestAttrs.entrySet()) {
                attributes.put(new Attributes.Name(iterator.getKey()), iterator.getValue());
            }
        }
        attributes.put(Attributes.Name.MAIN_CLASS, createJarParams.applicationClass);
        if (createJarParams.classpath != null) {
            Object object2 = createJarParams.classpath;
            object2 = ((String)object2).replace(';', ' ').replace(',', ' ');
            attributes.put(new Attributes.Name("Class-Path"), object2);
        }
        attributes.put(new Attributes.Name("JavaFX-Version"), createJarParams.fxVersion);
        if (createJarParams.preloader != null) {
            attributes.put(new Attributes.Name("JavaFX-Preloader-Class"), createJarParams.preloader);
        }
        if (createJarParams.arguments != null) {
            int n = 1;
            for (String string : createJarParams.arguments) {
                attributes.put(new Attributes.Name("JavaFX-Argument-" + n), this.encodeAsBase64(string.getBytes()));
                ++n;
            }
        }
        if (createJarParams.params != null) {
            int n = 1;
            for (Param param : createJarParams.params) {
                if (param.name == null) continue;
                attributes.put(new Attributes.Name("JavaFX-Parameter-Name-" + n), this.encodeAsBase64(param.name.getBytes()));
                if (param.value != null) {
                    attributes.put(new Attributes.Name("JavaFX-Parameter-Value-" + n), this.encodeAsBase64(param.value.getBytes()));
                }
                ++n;
            }
        }
        if (createJarParams.css2bin) {
            try {
                this.bssTmpDir = File.createTempFile("bssfiles", "");
            }
            catch (IOException iOException) {
                throw new PackagerException(iOException, "ERR_CreatingTempFileFailed", new String[0]);
            }
            this.bssTmpDir.delete();
        }
        if (((File)object).exists() && !((File)object).delete()) {
            throw new PackagerException("ERR_CantDeleteFile", createJarParams.outfile);
        }
        try {
            this.jar(manifest, createJarParams.resources, (File)serializable2, new JarOutputStream(new FileOutputStream((File)object)), Filter.ALL);
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_CreatingJarFailed", createJarParams.outfile);
        }
        PackagerLib.deleteDirectory(this.bssTmpDir);
        this.createJarParams = null;
    }

    private String readTextFile(File file) throws PackagerException {
        StringBuilder stringBuilder = new StringBuilder();
        try (InputStreamReader inputStreamReader = new InputStreamReader(new FileInputStream(file));){
            int n;
            char[] cArray = new char[16384];
            while ((n = inputStreamReader.read(cArray)) > 0) {
                stringBuilder.append(cArray, stringBuilder.length(), n);
            }
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_FileReadFailed", file.getAbsolutePath());
        }
        return stringBuilder.toString();
    }

    private String processTemplate(String string, Map<TemplatePlaceholders, String> map) {
        String string2 = "(#[\\w\\.\\(\\)]+#)";
        String string3 = "[\\/\\*-<\\!]*[ \\t]*";
        String string4 = "[ \\t]*[\\*\\/>-]*";
        Pattern pattern = Pattern.compile(string3 + string2 + string4);
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string5;
            String string6 = matcher.group();
            String string7 = matcher.group(1);
            boolean bl = string6.startsWith("<!--") && string6.endsWith("-->") || string6.startsWith("//") || string6.startsWith("/*") && string6.endsWith(" */");
            String string8 = null;
            String[] stringArray = string7.substring(1, string7.length() - 1).split("[\\(\\)]");
            String string9 = stringArray[0];
            String string10 = string5 = stringArray.length == 1 ? null : stringArray[1];
            if (map.containsKey((Object)TemplatePlaceholders.fromString(string9)) && (string5 == null || string5.equals(this.deployParams.appId))) {
                string8 = map.get((Object)TemplatePlaceholders.fromString(string9));
            }
            if (string8 == null) continue;
            if (bl || string7.length() == string6.length()) {
                matcher.appendReplacement(stringBuffer, string8);
                continue;
            }
            int n = string6.indexOf(string7);
            String string11 = string6.substring(0, n) + string8 + string6.substring(n + string7.length());
            matcher.appendReplacement(stringBuffer, string11);
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public void generateDeploymentPackages(DeployParams deployParams) throws PackagerException {
        if (deployParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.deployParams = deployParams;
        boolean bl = !deployParams.templates.isEmpty();
        EnumMap<TemplatePlaceholders, String> enumMap = null;
        if (bl) {
            enumMap = new EnumMap<TemplatePlaceholders, String>(TemplatePlaceholders.class);
        }
        try {
            Object object;
            String string = deployParams.outfile + ".jnlp";
            String string2 = deployParams.isSwingApp ? deployParams.outfile + "_browser.jnlp" : string;
            String string3 = deployParams.outfile + ".html";
            File file = deployParams.outdir;
            file.mkdirs();
            if (deployParams.includeDT && !this.extractWebFiles()) {
                throw new PackagerException("ERR_NoEmbeddedDT");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
            if (deployParams.isSwingApp) {
                object = new PrintStream(byteArrayOutputStream);
                this.generateJNLP((PrintStream)object, string, Mode.SwingAPP);
                ((PrintStream)object).close();
                this.save(string, byteArrayOutputStream.toByteArray());
                object = new PrintStream(byteArrayOutputStream2);
                this.generateJNLP((PrintStream)object, string2, Mode.APPLET);
                ((PrintStream)object).close();
                this.save(string2, byteArrayOutputStream2.toByteArray());
            } else {
                object = new PrintStream(byteArrayOutputStream2);
                this.generateJNLP((PrintStream)object, string2, Mode.FX);
                ((PrintStream)object).close();
                this.save(string2, byteArrayOutputStream2.toByteArray());
                byteArrayOutputStream = byteArrayOutputStream2;
            }
            if (!deployParams.isExtension) {
                object = new ByteArrayOutputStream();
                PrintStream object2 = new PrintStream((OutputStream)object);
                this.generateHTML(object2, byteArrayOutputStream2.toByteArray(), string2, byteArrayOutputStream.toByteArray(), string, enumMap, deployParams.isSwingApp);
                object2.close();
                if (bl) {
                    for (DeployParams.Template template : deployParams.templates) {
                        File file2 = template.out;
                        if (file2 == null) {
                            System.out.println("Perform inplace substitution for " + template.in.getAbsolutePath());
                            file2 = template.in;
                        }
                        this.save(file2, this.processTemplate(this.readTextFile(template.in), enumMap).getBytes());
                    }
                } else {
                    this.save(string3, ((ByteArrayOutputStream)object).toByteArray());
                }
            }
            for (DeployResource deployResource : deployParams.resources) {
                PackagerLib.copyFiles(deployResource, deployParams.outdir);
            }
            object = deployParams.getBundleParams();
            if (object != null) {
                this.generateNativeBundles(deployParams.outdir, ((BundleParams)object).getBundleParamsAsMap(), deployParams.getBundleType().toString(), deployParams.getTargetFormat());
            }
        }
        catch (PackagerException packagerException) {
            throw packagerException;
        }
        catch (Exception exception) {
            throw new PackagerException(exception, "ERR_DeployFailed", exception.getMessage());
        }
        this.deployParams = null;
    }

    private void generateNativeBundles(File file, Map<String, ? super Object> map, String string, String string2) throws PackagerException {
        file = new File(file, "bundles");
        if (map.containsKey("runtime")) {
            RelativeFileSet relativeFileSet = BundleParams.getRuntime(map);
            if (relativeFileSet == null) {
                Log.info(bundle.getString("MSG_NoJREPackaged"));
            } else {
                Log.info(MessageFormat.format(bundle.getString("MSG_UserProvidedJRE"), relativeFileSet.getBaseDirectory().getAbsolutePath()));
                if (Log.isDebug()) {
                    relativeFileSet.dump();
                }
            }
        } else {
            Log.info(bundle.getString("MSG_UseSystemJRE"));
        }
        for (Bundler bundler : Bundlers.createBundlersInstance().getBundlers(string)) {
            if (string2 != null && !string2.equalsIgnoreCase(bundler.getID())) continue;
            HashMap<String, ? super Object> hashMap = new HashMap<String, Object>(map);
            try {
                File file2;
                if (!bundler.validate(hashMap) || (file2 = bundler.execute(hashMap, file)) != null) continue;
                throw new PackagerException("MSG_BundlerFailed", bundler.getID(), bundler.getName());
            }
            catch (UnsupportedPlatformException unsupportedPlatformException) {
                Log.debug(MessageFormat.format(bundle.getString("MSG_BundlerPlatformException"), bundler.getName()));
            }
            catch (ConfigException configException) {
                Log.debug(configException);
                if (configException.getAdvice() != null) {
                    Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigException"), bundler.getName(), configException.getMessage(), configException.getAdvice()));
                    continue;
                }
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerConfigExceptionNoAdvice"), bundler.getName(), configException.getMessage()));
            }
            catch (RuntimeException runtimeException) {
                Log.info(MessageFormat.format(bundle.getString("MSG_BundlerRuntimeException"), bundler.getName(), runtimeException.toString()));
                Log.debug(runtimeException);
            }
        }
    }

    private static void copyFiles(DeployResource deployResource, File file) throws IOException, PackagerException {
        if (deployResource.getFile().isDirectory()) {
            File file2 = deployResource.getBaseDir();
            File[] fileArray = deployResource.getFile().listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    PackagerLib.copyFiles(new DeployResource(file2, file3), file);
                }
            }
        } else {
            File file4 = deployResource.getFile();
            if (file4.exists() && file4.isFile()) {
                File file5 = new File(file, deployResource.getRelativePath());
                if (!file4.getCanonicalFile().equals(file5.getCanonicalFile())) {
                    PackagerLib.copyFileToOutDir(new FileInputStream(file4), file5);
                } else {
                    Log.verbose(MessageFormat.format(bundle.getString("MSG_JarNoSelfCopy"), deployResource.getRelativePath()));
                }
            }
        }
    }

    public void generateBSS(CreateBSSParams createBSSParams) throws PackagerException {
        if (createBSSParams == null) {
            throw new IllegalArgumentException("Parameters must not be null.");
        }
        this.createBssParams = createBSSParams;
        this.createBinaryCss(this.createBssParams.resources, this.createBssParams.outdir);
        this.createBssParams = null;
    }

    public void signJar(SignJarParams signJarParams) throws PackagerException {
        try {
            JarSignature jarSignature = this.retrieveSignature(signJarParams);
            for (PackagerResource packagerResource : signJarParams.resources) {
                this.signFile(packagerResource, jarSignature, signJarParams.outdir, signJarParams.verbose);
            }
        }
        catch (Exception exception) {
            Log.verbose(exception);
            throw new PackagerException("ERR_SignFailed", exception);
        }
    }

    private JarSignature retrieveSignature(SignJarParams signJarParams) throws KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, IOException, CertificateException, InvalidKeyException {
        if (signJarParams.keyPass == null) {
            signJarParams.keyPass = signJarParams.storePass;
        }
        if (signJarParams.keyStore == null) {
            throw new IOException("No keystore specified");
        }
        if (signJarParams.storePass == null) {
            throw new IOException("No store password specified");
        }
        if (signJarParams.storeType == null) {
            throw new IOException("No store type is specified");
        }
        KeyStore keyStore = KeyStore.getInstance(signJarParams.storeType);
        keyStore.load(new FileInputStream(signJarParams.keyStore), signJarParams.storePass.toCharArray());
        Certificate[] certificateArray = keyStore.getCertificateChain(signJarParams.alias);
        X509Certificate[] x509CertificateArray = new X509Certificate[certificateArray.length];
        for (int i = 0; i < certificateArray.length; ++i) {
            x509CertificateArray[i] = (X509Certificate)certificateArray[i];
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(signJarParams.alias, signJarParams.keyPass.toCharArray());
        return JarSignature.create(privateKey, x509CertificateArray);
    }

    private void signFile(PackagerResource packagerResource, JarSignature jarSignature, File file, boolean bl) throws NoSuchAlgorithmException, IOException, SignatureException {
        if (packagerResource.getFile().isDirectory()) {
            File[] fileArray = packagerResource.getFile().listFiles();
            if (fileArray != null) {
                for (File file2 : fileArray) {
                    this.signFile(new PackagerResource(packagerResource.getBaseDir(), file2), jarSignature, file, bl);
                }
            }
        } else {
            File file3;
            File file4 = packagerResource.getFile();
            File file5 = file4.getParentFile();
            String string = "bsigned_" + file4.getName();
            File file6 = new File(file5, string);
            System.out.println("Signing (BLOB) " + file4.getPath());
            this.signAsBLOB(file4, file6, jarSignature);
            if (file != null) {
                file3 = new File(file, packagerResource.getRelativePath());
            } else {
                file4.delete();
                file3 = file4;
            }
            file3.delete();
            file3.getParentFile().mkdirs();
            file6.renameTo(file3);
            if (bl) {
                System.out.println("Signed as " + file3.getPath());
            }
        }
    }

    private void signAsBLOB(File file, File file2, JarSignature jarSignature) throws IOException, NoSuchAlgorithmException, SignatureException {
        if (jarSignature == null) {
            throw new IllegalStateException("Should retrieve signature first");
        }
        JarSignature.InputStreamSource inputStreamSource = () -> new FileInputStream(file);
        if (!file2.isFile()) {
            file2.createNewFile();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        jarSignature.signJarAsBLOB(inputStreamSource, new ZipOutputStream(fileOutputStream));
    }

    public void makeAll(MakeAllParams makeAllParams) throws PackagerException {
        Object object;
        Object object2;
        String string = System.getProperty("os.name").startsWith("Windows") ? ".exe" : "";
        String string2 = System.getenv("JAVA_HOME");
        if (string2 == null) {
            string2 = System.getProperty("java.home");
        }
        if (string2 == null) {
            throw new PackagerException("ERR_MissingJavaHome");
        }
        File file = new File(new File(string2), "bin/javac" + string);
        String string3 = System.getenv("JAVAFX_HOME");
        if (string3 == null) {
            string3 = System.getProperty("javafx.home");
        }
        if (string3 == null) {
            throw new PackagerException("ERR_MissingJavaFxHome");
        }
        File file2 = new File("dist");
        File file3 = new File("compiled");
        file3.mkdir();
        try {
            int n;
            object2 = File.createTempFile("javac", "sources", new File("."));
            ((File)object2).deleteOnExit();
            object = new FileWriter((File)object2);
            Throwable throwable = null;
            try {
                PackagerLib.scanAndCopy(new PackagerResource(new File("src"), "."), (Writer)object, file3);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            ((OutputStreamWriter)object).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((OutputStreamWriter)object).close();
                    }
                }
            }
            object = string3 + "/../rt/lib/ext/jfxrt.jar";
            if (makeAllParams.classpath != null) {
                object = (String)object + File.pathSeparator + makeAllParams.classpath;
            }
            if (makeAllParams.verbose) {
                System.out.println("Executing javac:");
                System.out.printf("%s %s %s %s %s %s%n", file.getAbsolutePath(), "-d", "compiled", "-cp", object, "@" + ((File)object2).getAbsolutePath());
            }
            if ((n = PackagerLib.execute(file.getAbsolutePath(), "-d", "compiled", "-cp", object, "@" + ((File)object2).getAbsolutePath())) != 0) {
                throw new PackagerException("ERR_JavacFailed", Integer.toString(n));
            }
        }
        catch (PackagerException packagerException) {
            throw packagerException;
        }
        catch (Exception exception) {
            throw new PackagerException(exception, "ERR_MakeAllJavacFailed", new String[0]);
        }
        object2 = new CreateJarParams();
        ((CreateJarParams)object2).applicationClass = makeAllParams.appClass;
        ((CreateJarParams)object2).preloader = makeAllParams.preloader;
        ((CreateJarParams)object2).classpath = makeAllParams.classpath;
        ((CreateJarParams)object2).css2bin = false;
        ((CreateJarParams)object2).outdir = file2;
        ((CreateJarParams)object2).outfile = "dist.jar";
        ((CreateJarParams)object2).addResource(file3, ".");
        this.packageAsJar((CreateJarParams)object2);
        object = new DeployParams();
        ((DeployParams)object).applicationClass = makeAllParams.appClass;
        ((DeployParams)object).appName = makeAllParams.appName;
        ((DeployParams)object).description = "Application description";
        ((DeployParams)object).height = makeAllParams.height;
        ((DeployParams)object).width = makeAllParams.width;
        ((DeployParams)object).vendor = "Application vendor";
        ((DeployParams)object).outdir = file2;
        ((DeployParams)object).outfile = "dist";
        ((DeployParams)object).addResource(file2, "dist.jar");
        ((DeployParams)object).setBundleType(Bundler.BundleType.ALL);
        this.generateDeploymentPackages((DeployParams)object);
        PackagerLib.deleteDirectory(file3);
    }

    private static int execute(Object ... objectArray) throws IOException, InterruptedException {
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object object2 : objectArray) {
            if (object2 instanceof List) {
                arrayList.addAll((List)object2);
                continue;
            }
            if (!(object2 instanceof String)) continue;
            arrayList.add((String)object2);
        }
        Process process = Runtime.getRuntime().exec(arrayList.toArray(new String[arrayList.size()]));
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        Thread thread = new Thread(() -> {
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            catch (IOException iOException) {
                Log.verbose(iOException);
            }
        });
        thread.setDaemon(true);
        thread.start();
        object2 = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        thread = new Thread(() -> PackagerLib.lambda$execute$223((BufferedReader)object2));
        thread.setDaemon(true);
        thread.start();
        return process.waitFor();
    }

    private static void scanAndCopy(PackagerResource packagerResource, Writer writer, File file) throws PackagerException {
        if (!packagerResource.getFile().exists()) {
            throw new PackagerException("ERR_MissingDirectory", packagerResource.getFile().getName());
        }
        File[] fileArray = packagerResource.getFile().listFiles();
        if (fileArray == null || fileArray.length == 0) {
            throw new PackagerException("ERR_EmptySourceDirectory", packagerResource.getFile().getName());
        }
        try {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    PackagerLib.scanAndCopy(new PackagerResource(packagerResource.getBaseDir(), file2), writer, file);
                    continue;
                }
                if (file2.getName().endsWith(".java")) {
                    writer.write('\'' + file2.getAbsolutePath().replace('\\', '/') + "'\n");
                    continue;
                }
                PackagerLib.copyFileToOutDir(new FileInputStream(file2), new File(file.getPath() + File.separator + packagerResource.getRelativePath() + File.separator + file2.getName()));
            }
        }
        catch (IOException iOException) {
            throw new PackagerException("ERR_FileCopyFailed", packagerResource.getFile().getName());
        }
    }

    private String getJvmArguments(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : this.deployParams.jvmargs) {
            stringBuilder.append(string);
            stringBuilder.append(" ");
        }
        if (bl) {
            for (String string : this.deployParams.properties.keySet()) {
                stringBuilder.append("-D");
                stringBuilder.append(string);
                stringBuilder.append("=");
                stringBuilder.append(this.deployParams.properties.get(string));
                stringBuilder.append(" ");
            }
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void generateJNLP(PrintStream printStream, String string, Mode mode) throws IOException, CertificateEncodingException {
        String string22;
        printStream.println("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        printStream.println("<jnlp spec=\"1.0\" xmlns:jfx=\"http://javafx.com\"" + (this.deployParams.codebase != null ? " codebase=\"" + this.deployParams.codebase + "\"" : "") + " href=\"" + string + "\">");
        printStream.println("  <information>");
        printStream.println("    <title>" + (this.deployParams.title != null ? this.deployParams.title : "Sample JavaFX Application") + "</title>");
        printStream.println("    <vendor>" + (this.deployParams.vendor != null ? this.deployParams.vendor : "Unknown vendor") + "</vendor>");
        printStream.println("    <description>" + (this.deployParams.description != null ? this.deployParams.description : "Sample JavaFX 2.0 application.") + "</description>");
        for (DeployParams.Icon object2 : this.deployParams.icons) {
            if (object2.mode != DeployParams.RunMode.WEBSTART && object2.mode != DeployParams.RunMode.ALL) continue;
            printStream.println("    <icon href=\"" + object2.href + "\" " + (object2.kind != null ? " kind=\"" + object2.kind + "\"" : "") + (object2.width != -1 ? " width=\"" + object2.width + "\"" : "") + (object2.height != -1 ? " height=\"" + object2.height + "\"" : "") + (object2.depth != -1 ? " depth=\"" + object2.depth + "\"" : "") + "/>");
        }
        if (this.deployParams.offlineAllowed && !this.deployParams.isExtension) {
            printStream.println("    <offline-allowed/>");
        }
        if (Boolean.TRUE.equals(this.deployParams.needShortcut)) {
            printStream.println("  <shortcut><desktop/></shortcut>");
        }
        printStream.println("  </information>");
        boolean bl = false;
        if (!this.deployParams.isExtension) {
            printStream.println("  <resources>");
            bl = true;
            String string4 = this.getJvmArguments(false);
            string4 = string4 == null ? "" : " java-vm-args=\"" + string4 + "\" ";
            printStream.println("    <j2se version=\"" + this.deployParams.jrePlatform + "\"" + string4 + " href=\"http://java.sun.com/products/autodl/j2se\"/>");
            for (String string22 : this.deployParams.properties.keySet()) {
                printStream.println("    <property name=\"" + string22 + "\" value=\"" + this.deployParams.properties.get(string22) + "\"/>");
            }
        }
        Object var5_10 = null;
        Object object = null;
        string22 = null;
        for (DeployResource deployResource : this.deployParams.resources) {
            File file;
            void var5_11;
            if (!bl || var5_11 == null && deployResource.getOs() != null || var5_11 != null && !var5_11.equals(deployResource.getOs()) || object == null && deployResource.getArch() != null || object != null && !((String)object).equals(deployResource.getArch())) {
                string22 = bl ? "  </resources>\n" : "";
                String string5 = deployResource.getOs();
                object = deployResource.getArch();
                string22 = string22 + "  <resources" + (string5 != null ? " os=\"" + string5 + "\"" : "") + (object != null ? " arch=\"" + (String)object + "\"" : "") + ">\n";
            }
            if (!(file = deployResource.getFile()).exists() || !file.isFile()) continue;
            String string6 = deployResource.getRelativePath();
            DeployResource.Type type = deployResource.getType();
            switch (type) {
                case jar: {
                    if (string22 != null) {
                        printStream.print(string22);
                        string22 = null;
                        bl = true;
                    }
                    printStream.print("    <jar href=\"" + string6 + "\" size=\"" + file.length() + "\"");
                    printStream.print(" download=\"" + deployResource.getMode() + "\" ");
                    printStream.println("/>");
                    break;
                }
                case jnlp: {
                    if (string22 != null) {
                        printStream.print(string22);
                        string22 = null;
                        bl = true;
                    }
                    printStream.println("    <extension href=\"" + string6 + "\"/>");
                    break;
                }
                case nativelib: {
                    if (string22 != null) {
                        printStream.print(string22);
                        bl = true;
                        string22 = null;
                    }
                    printStream.println("    <nativelib href=\"" + string6 + "\"/>");
                }
            }
        }
        if (bl) {
            printStream.println("  </resources>");
        }
        if (this.deployParams.allPermissions) {
            printStream.println("<security>");
            printStream.println("  <all-permissions/>");
            printStream.println("</security>");
        }
        if (!this.deployParams.isExtension) {
            if (mode == Mode.APPLET) {
                printStream.print("  <applet-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                printStream.print(" main-class=\"" + this.deployParams.applicationClass + "\" ");
                printStream.println(" name=\"" + this.deployParams.appName + "\" >");
                if (this.deployParams.params != null) {
                    for (Param param : this.deployParams.params) {
                        printStream.println("    <param name=\"" + param.name + "\"" + (param.value != null ? " value=\"" + param.value + "\"" : "") + "/>");
                    }
                }
                printStream.println("  </applet-desc>");
            } else if (mode == Mode.SwingAPP) {
                printStream.print("  <application-desc main-class=\"" + this.deployParams.applicationClass + "\" ");
                printStream.println(" name=\"" + this.deployParams.appName + "\" >");
                if (this.deployParams.arguments != null) {
                    for (String string7 : this.deployParams.arguments) {
                        printStream.println("    <argument>" + string7 + "</argument>");
                    }
                }
                printStream.println("  </application-desc>");
            } else {
                if (this.deployParams.fallbackApp != null) {
                    printStream.print("  <applet-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                    printStream.print(" main-class=\"" + this.deployParams.fallbackApp + "\" ");
                    printStream.println(" name=\"" + this.deployParams.appName + "\" >");
                    printStream.println("    <param name=\"requiredFXVersion\" value=\"" + this.deployParams.fxPlatform + "\"/>");
                    printStream.println("  </applet-desc>");
                }
                printStream.print("  <jfx:javafx-desc  width=\"" + this.deployParams.width + "\" height=\"" + this.deployParams.height + "\"");
                printStream.print(" main-class=\"" + this.deployParams.applicationClass + "\" ");
                printStream.print(" name=\"" + this.deployParams.appName + "\" ");
                if (this.deployParams.preloader != null) {
                    printStream.print(" preloader-class=\"" + this.deployParams.preloader + "\"");
                }
                if ((this.deployParams.params == null || this.deployParams.params.isEmpty()) && (this.deployParams.arguments == null || this.deployParams.arguments.isEmpty())) {
                    printStream.println("/>");
                } else {
                    printStream.println(">");
                    if (this.deployParams.params != null) {
                        for (Param param : this.deployParams.params) {
                            printStream.println("    <fx:param name=\"" + param.name + "\"" + (param.value != null ? " value=\"" + param.value + "\"" : "") + "/>");
                        }
                    }
                    if (this.deployParams.arguments != null) {
                        for (String string8 : this.deployParams.arguments) {
                            printStream.println("    <fx:argument>" + string8 + "</fx:argument>");
                        }
                    }
                    printStream.println("  </jfx:javafx-desc>");
                }
            }
        }
        printStream.println("  <update check=\"" + this.deployParams.updateMode + "\"/>");
        printStream.println("</jnlp>");
    }

    private void addToList(List<String> list, String string, String string2, boolean bl) {
        String string3 = bl ? "'" : "";
        String string4 = string + " : " + string3 + string2 + string3;
        list.add(string4);
    }

    private String listToString(List<String> list, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list == null || list.isEmpty()) {
            return string + "{}";
        }
        stringBuilder.append(string).append("{\n");
        boolean bl = true;
        for (String string2 : list) {
            if (!bl) {
                stringBuilder.append(",\n");
            }
            bl = false;
            stringBuilder.append(string).append("    ");
            stringBuilder.append(string2);
        }
        stringBuilder.append("\n");
        stringBuilder.append(string).append("}");
        return stringBuilder.toString();
    }

    private String encodeAsBase64(byte[] byArray) {
        return Base64.getEncoder().encodeToString(byArray);
    }

    /*
     * WARNING - void declaration
     */
    private void generateHTML(PrintStream printStream, byte[] byArray, String string, byte[] byArray2, String string2, Map<TemplatePlaceholders, String> map, boolean bl) {
        void var24_27;
        String string3 = "    ";
        String string4 = string3 + string3;
        String string5 = string4 + string3;
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        StringBuilder stringBuilder3 = new StringBuilder();
        String string6 = this.getAppletParameters();
        String string7 = null;
        String string8 = null;
        if (this.deployParams.embedJNLP) {
            string7 = this.encodeAsBase64(byArray);
            string8 = this.encodeAsBase64(byArray2);
        }
        printStream.println("<html><head>");
        String string9 = this.deployParams.includeDT ? EMBEDDED_DT : PUBLIC_DT;
        String string10 = "<SCRIPT src=\"" + string9 + "\"></SCRIPT>";
        if (map != null) {
            map.put(TemplatePlaceholders.SCRIPT_URL, string9);
            map.put(TemplatePlaceholders.SCRIPT_CODE, string10);
        }
        printStream.println("  " + string10);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        this.addToList(arrayList, "url", string2, true);
        if (string8 != null) {
            this.addToList(arrayList, "jnlp_content", string8, true);
        }
        this.addToList(arrayList2, "javafx", this.deployParams.fxPlatform, true);
        String string11 = this.getJvmArguments(true);
        if (string11 != null) {
            this.addToList(arrayList2, "jvmargs", string11, true);
        }
        if (!"".equals(string6)) {
            this.addToList(arrayList, "params", "{" + string6 + "}", false);
        }
        if (this.deployParams.callbacks != null && !this.deployParams.callbacks.isEmpty()) {
            for (JSCallback object22 : this.deployParams.callbacks) {
                this.addToList(arrayList3, object22.getName(), object22.getCmd(), false);
            }
        }
        stringBuilder3.append(string4).append("dtjava.launch(");
        stringBuilder3.append(this.listToString(arrayList, string5)).append(",\n");
        stringBuilder3.append(this.listToString(arrayList2, string5)).append(",\n");
        stringBuilder3.append(this.listToString(arrayList3, string5)).append("\n");
        stringBuilder3.append(string4).append(");\n");
        printStream.println("<script>");
        printStream.println(string3 + "function launchApplication(jnlpfile) {");
        printStream.print(stringBuilder3.toString());
        printStream.println(string4 + "return false;");
        printStream.println(string3 + "}");
        printStream.println("</script>");
        if (map != null) {
            map.put(TemplatePlaceholders.LAUNCH_CODE, stringBuilder3.toString());
        }
        String string12 = this.deployParams.appId;
        String string13 = this.deployParams.placeholder;
        if (string13 == null) {
            String string14 = "'javafx-app-placeholder'";
        }
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        ArrayList<String> arrayList6 = new ArrayList<String>();
        if (string12 != null) {
            this.addToList(arrayList4, "id", string12, true);
        }
        if (this.deployParams.isSwingApp) {
            this.addToList(arrayList4, "toolkit", "swing", true);
        }
        this.addToList(arrayList4, "url", string, true);
        this.addToList(arrayList4, "placeholder", (String)var24_27, false);
        if (this.deployParams.embeddedWidth != null && this.deployParams.embeddedHeight != null) {
            this.addToList(arrayList4, "width", "" + this.deployParams.embeddedWidth, true);
            this.addToList(arrayList4, "height", "" + this.deployParams.embeddedHeight, true);
        } else {
            this.addToList(arrayList4, "width", "" + this.deployParams.width, false);
            this.addToList(arrayList4, "height", "" + this.deployParams.height, false);
        }
        if (string7 != null) {
            this.addToList(arrayList4, "jnlp_content", string7, true);
        }
        this.addToList(arrayList5, "javafx", this.deployParams.fxPlatform, true);
        if (string11 != null) {
            this.addToList(arrayList5, "jvmargs", string11, true);
        }
        if (this.deployParams.callbacks != null && !this.deployParams.callbacks.isEmpty()) {
            for (JSCallback jSCallback : this.deployParams.callbacks) {
                this.addToList(arrayList6, jSCallback.getName(), jSCallback.getCmd(), false);
            }
        }
        if (!"".equals(string6)) {
            this.addToList(arrayList4, "params", "{" + string6 + "}", false);
        }
        if (bl) {
            boolean bl2 = true;
            if (this.deployParams.callbacks != null) {
                for (JSCallback jSCallback : this.deployParams.callbacks) {
                    if (!"onGetSplash".equals(jSCallback.getName())) continue;
                    bl2 = false;
                }
            }
            if (bl2) {
                this.addToList(arrayList6, "onGetSplash", "function() {}", false);
            }
        }
        stringBuilder.append("dtjava.embed(\n");
        stringBuilder.append(this.listToString(arrayList4, string5)).append(",\n");
        stringBuilder.append(this.listToString(arrayList5, string5)).append(",\n");
        stringBuilder.append(this.listToString(arrayList6, string5)).append("\n");
        stringBuilder.append(string4).append(");\n");
        String string15 = "javafxEmbed" + (this.deployParams.appId != null ? "_" + this.deployParams.appId : "");
        stringBuilder2.append("\n<script>\n");
        stringBuilder2.append(string3).append("function ").append(string15).append("() {\n");
        stringBuilder2.append(string4);
        stringBuilder2.append((CharSequence)stringBuilder);
        stringBuilder2.append(string3).append("}\n");
        stringBuilder2.append(string3).append("<!-- Embed FX application into web page once page is loaded -->\n");
        stringBuilder2.append(string3).append("dtjava.addOnloadCallback(").append(string15).append(");\n");
        stringBuilder2.append("</script>\n");
        if (map != null) {
            map.put(TemplatePlaceholders.EMBED_CODE_ONLOAD, stringBuilder2.toString());
            map.put(TemplatePlaceholders.EMBED_CODE_DYNAMIC, stringBuilder.toString());
        }
        printStream.println(stringBuilder2.toString());
        printStream.println("</head><body>");
        printStream.println("<h2>Test page for <b>" + this.deployParams.appName + "</b></h2>");
        String string16 = "return launchApplication('" + string2 + "');";
        printStream.println("  <b>Webstart:</b> <a href='" + string2 + "' onclick=\"" + string16 + "\">" + "click to launch this app as webstart</a><br><hr><br>");
        printStream.println("");
        printStream.println("  <!-- Applet will be inserted here -->");
        printStream.println("  <div id=" + (String)var24_27 + "></div>");
        printStream.println("</body></html>");
    }

    private void save(String string, byte[] byArray) throws IOException {
        File file = this.deployParams.outdir;
        this.save(new File(file, string), byArray);
    }

    private void save(File file, byte[] byArray) throws IOException {
        if (file.exists()) {
            file.delete();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    private static void copyFileToOutDir(InputStream inputStream, File file) throws PackagerException {
        File file2 = file.getParentFile();
        if (!file2.exists() && !file2.mkdirs()) {
            throw new PackagerException("ERR_CreatingDirFailed", file2.getPath());
        }
        try (InputStream inputStream2 = inputStream;
             FileOutputStream fileOutputStream = new FileOutputStream(file);){
            int n;
            byte[] byArray = new byte[16384];
            while ((n = inputStream2.read(byArray)) > 0) {
                ((OutputStream)fileOutputStream).write(byArray, 0, n);
            }
        }
        catch (IOException iOException) {
            throw new PackagerException(iOException, "ERR_FileCopyFailed", file2.getPath());
        }
    }

    private String getAppletParameters() {
        String string = "";
        if (this.deployParams.htmlParams != null) {
            for (HtmlParam htmlParam : this.deployParams.htmlParams) {
                if (!string.isEmpty()) {
                    string = string + ", ";
                }
                String string2 = htmlParam.needEscape ? "\"" : "";
                string = string + "\"" + htmlParam.name + "\": " + string2 + htmlParam.value + string2;
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jar(Manifest manifest, List<PackagerResource> list, File file, JarOutputStream jarOutputStream, Filter filter) throws IOException, PackagerException {
        try {
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/"));
            jarOutputStream.closeEntry();
            jarOutputStream.putNextEntry(new ZipEntry("META-INF/MANIFEST.MF"));
            manifest.write(jarOutputStream);
            jarOutputStream.closeEntry();
            this.alreadyAddedEntries.add("META-INF/");
            if (file != null) {
                this.copyFromOtherJar(jarOutputStream, file);
            } else {
                for (PackagerResource packagerResource : list) {
                    this.jar(packagerResource.getFile(), jarOutputStream, filter, packagerResource.getBaseDir().getAbsolutePath().length() + 1);
                }
            }
        }
        finally {
            jarOutputStream.close();
            this.alreadyAddedEntries.clear();
        }
    }

    private void createParentEntries(String string, JarOutputStream jarOutputStream) throws IOException {
        String[] stringArray = string.split("/");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length - 1; ++i) {
            stringBuilder.append(stringArray[i]).append("/");
            if (!this.alreadyAddedEntries.contains(stringBuilder.toString())) {
                jarOutputStream.putNextEntry(new ZipEntry(stringBuilder.toString()));
                jarOutputStream.closeEntry();
            }
            this.alreadyAddedEntries.add(stringBuilder.toString());
        }
    }

    private void copyFromOtherJar(JarOutputStream jarOutputStream, File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            if ("META-INF/MANIFEST.MF".equals(jarEntry.getName().toUpperCase()) || "META-INF/".equals(jarEntry.getName().toUpperCase())) continue;
            jarOutputStream.putNextEntry(new JarEntry(jarEntry.getName()));
            byte[] byArray = new byte[65000];
            try (InputStream inputStream = jarFile.getInputStream(jarEntry);){
                int n;
                while ((n = inputStream.read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n);
                }
            }
            jarOutputStream.closeEntry();
        }
    }

    private void jar(File object, JarOutputStream jarOutputStream, Filter filter, int n) throws IOException, PackagerException {
        if (!((File)object).exists()) {
            throw new FileNotFoundException("Input folder does not exist [" + ((File)object).getAbsolutePath() + "]");
        }
        if (((File)object).isDirectory()) {
            File[] fileArray = ((File)object).listFiles();
            if (fileArray != null) {
                for (File file : fileArray) {
                    this.jar(file, jarOutputStream, filter, n);
                }
            }
        } else if (filter == Filter.ALL || filter == Filter.CLASSES_ONLY && ((File)object).getName().endsWith(".class") || filter == Filter.RESOURCES && this.isResource(((File)object).getAbsolutePath())) {
            Object object2;
            String string = ((File)object).getAbsolutePath();
            if (string.endsWith("META-INF\\MANIFEST.MF") || string.endsWith("META-INF/MANIFEST.MF")) {
                return;
            }
            this.createParentEntries(string.substring(n).replace('\\', '/'), jarOutputStream);
            if (this.createJarParams.css2bin && ((File)object).getName().endsWith(".css")) {
                int n2 = string.lastIndexOf(".") + 1;
                String string2 = string.substring(n, n2).concat("bss");
                object2 = new File(this.bssTmpDir, string2);
                ((File)object2).getParentFile().mkdirs();
                this.createBinaryCss(string, ((File)object2).getAbsolutePath());
                jarOutputStream.putNextEntry(new ZipEntry(string2.replace('\\', '/')));
                object = object2;
            } else {
                jarOutputStream.putNextEntry(new ZipEntry(string.substring(n).replace('\\', '/')));
            }
            byte[] byArray = new byte[65000];
            object2 = new FileInputStream((File)object);
            Throwable throwable = null;
            try {
                int n3;
                while ((n3 = ((FileInputStream)object2).read(byArray)) > 0) {
                    jarOutputStream.write(byArray, 0, n3);
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((FileInputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((FileInputStream)object2).close();
                    }
                }
            }
            jarOutputStream.closeEntry();
        }
    }

    private void createBinaryCss(List<PackagerResource> list, File file) throws PackagerException {
        for (PackagerResource packagerResource : list) {
            String string = packagerResource.getRelativePath();
            this.createBinaryCss(packagerResource.getFile(), file, string);
        }
    }

    private void createBinaryCss(File file, File file2, String string) throws PackagerException {
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (File file3 : fileArray) {
                    this.createBinaryCss(file3, file2, string + '/' + file3.getName());
                }
            }
        } else if (file.getName().endsWith(".css")) {
            String string2 = file.getAbsolutePath();
            String string3 = new File(file2.getAbsolutePath(), PackagerLib.replaceExtensionByBSS(string)).getAbsolutePath();
            this.createBinaryCss(string2, string3);
        }
    }

    private String getJfxrtPath() throws PackagerException {
        Class<PackagerLib> clazz = PackagerLib.class;
        String string = "PackagerLib.class";
        String string2 = clazz.getResource(string).toString();
        if (!string2.startsWith("jar:file:") || !string2.contains("!")) {
            throw new PackagerException("ERR_CantFindRuntime");
        }
        string2 = string2.substring(0, string2.lastIndexOf("!"));
        int n = Math.max(string2.lastIndexOf("/"), string2.lastIndexOf("\\"));
        return string2.substring(0, n) + "/../rt/lib/ext/jfxrt.jar!/";
    }

    private Class loadClassFromRuntime(String string) throws PackagerException {
        try {
            ClassLoader classLoader = this.getClassLoader();
            return classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PackagerException(classNotFoundException, "ERR_CantFindRuntime", new String[0]);
        }
    }

    private void createBinaryCss(String string, String string2) throws PackagerException {
        Class clazz;
        String string3 = string2 != null ? string2 : PackagerLib.replaceExtensionByBSS(string);
        File file = new File(string3);
        File file2 = file.getParentFile();
        if (file2 != null) {
            file2.mkdirs();
        }
        try {
            clazz = Class.forName("com.sun.javafx.css.parser.Css2Bin");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = this.loadClassFromRuntime("com.sun.javafx.css.parser.Css2Bin");
        }
        try {
            Method method = clazz.getMethod("convertToBinary", String.class, String.class);
            method.invoke(null, string, string3);
        }
        catch (Exception exception) {
            Throwable throwable = exception.getCause();
            String string4 = throwable != null ? throwable.getMessage() : bundle.getString("ERR_UnknownReason");
            throw new PackagerException(exception, "ERR_BSSConversionFailed", string, string4);
        }
    }

    private static String replaceExtensionByBSS(String string) {
        return string.substring(0, string.lastIndexOf(".") + 1).concat("bss");
    }

    private boolean isResource(String string) {
        if (string.endsWith(".class")) {
            return false;
        }
        if (string.endsWith(".java")) {
            return false;
        }
        if (string.endsWith(".fx")) {
            return false;
        }
        if (string.endsWith(".cvsignore")) {
            return false;
        }
        if (string.endsWith(".hgignore")) {
            return false;
        }
        if (string.endsWith("vssver.scc")) {
            return false;
        }
        if (string.endsWith(".DS_Store")) {
            return false;
        }
        if (string.endsWith("~")) {
            return false;
        }
        if ((string = string.replace('\\', '/')).contains("/CVS/")) {
            return false;
        }
        if (string.contains("/.svn/")) {
            return false;
        }
        if (string.contains("/.hg/")) {
            return false;
        }
        if (string.contains("/.#")) {
            return false;
        }
        if (string.contains("/._")) {
            return false;
        }
        if (string.endsWith("#") && string.contains("/#")) {
            return false;
        }
        if (string.endsWith("%") && string.contains("/%")) {
            return false;
        }
        return !string.endsWith("MANIFEST.MF");
    }

    private boolean extractWebFiles() throws PackagerException {
        return this.doExtractWebFiles(webFiles);
    }

    private boolean doExtractWebFiles(String[] stringArray) throws PackagerException {
        File file = new File(this.deployParams.outdir, webfilesDir);
        file.mkdirs();
        for (String string : stringArray) {
            InputStream inputStream = PackagerLib.class.getResourceAsStream(prefixWebFiles + string);
            if (inputStream == null) {
                System.err.println("Internal error. Missing resources [" + prefixWebFiles + string + "]");
                return false;
            }
            PackagerLib.copyFileToOutDir(inputStream, new File(file, string));
        }
        return true;
    }

    private static boolean deleteDirectory(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            for (String string : file.list()) {
                PackagerLib.deleteDirectory(new File(file, string));
            }
        }
        return file.delete();
    }

    private static /* synthetic */ void lambda$execute$223(BufferedReader bufferedReader) {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                System.err.println(string);
            }
        }
        catch (IOException iOException) {
            Log.verbose(iOException);
        }
    }

    private static enum Mode {
        FX,
        APPLET,
        SwingAPP;

    }

    private static enum Filter {
        ALL,
        CLASSES_ONLY,
        RESOURCES;

    }
}

