/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.simp.annotation.support;

import java.lang.annotation.Annotation;
import java.security.Principal;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.handler.annotation.SendTo;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.SimpMessageSendingOperations;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.annotation.SendToUser;
import org.springframework.messaging.simp.annotation.support.MissingSessionUserException;
import org.springframework.messaging.simp.user.DestinationUserNameProvider;
import org.springframework.messaging.support.MessageHeaderInitializer;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class SendToMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    private final SimpMessageSendingOperations messagingTemplate;
    private final boolean annotationRequired;
    private String defaultDestinationPrefix = "/topic";
    private String defaultUserDestinationPrefix = "/queue";
    private MessageHeaderInitializer headerInitializer;

    public SendToMethodReturnValueHandler(SimpMessageSendingOperations messagingTemplate, boolean annotationRequired) {
        Assert.notNull((Object)messagingTemplate, (String)"messagingTemplate must not be null");
        this.messagingTemplate = messagingTemplate;
        this.annotationRequired = annotationRequired;
    }

    public void setDefaultDestinationPrefix(String defaultDestinationPrefix) {
        this.defaultDestinationPrefix = defaultDestinationPrefix;
    }

    public String getDefaultDestinationPrefix() {
        return this.defaultDestinationPrefix;
    }

    public void setDefaultUserDestinationPrefix(String prefix) {
        this.defaultUserDestinationPrefix = prefix;
    }

    public String getDefaultUserDestinationPrefix() {
        return this.defaultUserDestinationPrefix;
    }

    public void setHeaderInitializer(MessageHeaderInitializer headerInitializer) {
        this.headerInitializer = headerInitializer;
    }

    public MessageHeaderInitializer getHeaderInitializer() {
        return this.headerInitializer;
    }

    @Override
    public boolean supportsReturnType(MethodParameter returnType) {
        if (returnType.getMethodAnnotation(SendTo.class) != null || returnType.getMethodAnnotation(SendToUser.class) != null) {
            return true;
        }
        return !this.annotationRequired;
    }

    @Override
    public void handleReturnValue(Object returnValue, MethodParameter returnType, Message<?> message) throws Exception {
        if (returnValue == null) {
            return;
        }
        MessageHeaders headers = message.getHeaders();
        String sessionId = SimpMessageHeaderAccessor.getSessionId(headers);
        SendToUser sendToUser = (SendToUser)returnType.getMethodAnnotation(SendToUser.class);
        if (sendToUser != null) {
            String[] destinations;
            boolean broadcast = sendToUser.broadcast();
            String user = this.getUserName(message, headers);
            if (user == null) {
                if (sessionId == null) {
                    throw new MissingSessionUserException(message);
                }
                user = sessionId;
                broadcast = false;
            }
            for (String destination : destinations = this.getTargetDestinations(sendToUser, message, this.defaultUserDestinationPrefix)) {
                if (broadcast) {
                    this.messagingTemplate.convertAndSendToUser(user, destination, returnValue);
                    continue;
                }
                this.messagingTemplate.convertAndSendToUser(user, destination, returnValue, this.createHeaders(sessionId));
            }
        } else {
            String[] destinations;
            SendTo sendTo = (SendTo)returnType.getMethodAnnotation(SendTo.class);
            for (String destination : destinations = this.getTargetDestinations(sendTo, message, this.defaultDestinationPrefix)) {
                this.messagingTemplate.convertAndSend(destination, returnValue, this.createHeaders(sessionId));
            }
        }
    }

    protected String getUserName(Message<?> message, MessageHeaders headers) {
        Principal principal = SimpMessageHeaderAccessor.getUser(headers);
        if (principal != null) {
            return principal instanceof DestinationUserNameProvider ? ((DestinationUserNameProvider)((Object)principal)).getDestinationUserName() : principal.getName();
        }
        return null;
    }

    protected String[] getTargetDestinations(Annotation annotation, Message<?> message, String defaultPrefix) {
        String[] stringArray;
        Object[] value;
        if (annotation != null && !ObjectUtils.isEmpty((Object[])(value = (String[])AnnotationUtils.getValue((Annotation)annotation)))) {
            return value;
        }
        String name = "lookupDestination";
        String destination = (String)message.getHeaders().get(name);
        Assert.hasText((String)destination, (String)("No lookup destination header in " + message));
        if (destination.startsWith("/")) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = defaultPrefix + destination;
        } else {
            String[] stringArray3 = new String[1];
            stringArray = stringArray3;
            stringArray3[0] = defaultPrefix + "/" + destination;
        }
        return stringArray;
    }

    private MessageHeaders createHeaders(String sessionId) {
        SimpMessageHeaderAccessor headerAccessor = SimpMessageHeaderAccessor.create(SimpMessageType.MESSAGE);
        if (this.getHeaderInitializer() != null) {
            this.getHeaderInitializer().initHeaders(headerAccessor);
        }
        headerAccessor.setSessionId(sessionId);
        headerAccessor.setLeaveMutable(true);
        return headerAccessor.getMessageHeaders();
    }

    public String toString() {
        return "SendToMethodReturnValueHandler [annotationRequired=" + this.annotationRequired + "]";
    }
}

