/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.subscription.internal;

public final class Range {
    private Number m_min;
    private Number m_max;

    public Range() {
    }

    public Range(Number min, Number max) {
        this.m_min = min;
        this.m_max = max;
    }

    public boolean isValid() {
        return this.m_min != null && this.m_max != null && this.m_min.doubleValue() <= this.m_max.doubleValue();
    }

    public Number getMinValue() {
        if (this.isValid()) {
            return this.m_min;
        }
        return null;
    }

    public Number getMaxValue() {
        if (this.isValid()) {
            return this.m_max;
        }
        return null;
    }

    public void setMinValue(Number value) {
        this.m_min = value;
    }

    public void setMaxValue(Number value) {
        this.m_max = value;
    }

    public void update(Number number) {
        if (this.m_min == null || this.m_min.doubleValue() > number.doubleValue()) {
            this.m_min = number;
        }
        if (this.m_max == null || this.m_max.doubleValue() < number.doubleValue()) {
            this.m_max = number;
        }
    }

    public void clear() {
        this.m_min = null;
        this.m_max = null;
    }

    public String toString() {
        return "[" + this.getMinValue() + ", " + this.getMaxValue() + ']';
    }
}

