/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSOriginDeniedException;
import com.thetransactioncompany.cors.CORSRequestType;
import com.thetransactioncompany.cors.HTTPMethod;
import com.thetransactioncompany.cors.HeaderFieldName;
import com.thetransactioncompany.cors.InvalidCORSRequestException;
import com.thetransactioncompany.cors.Origin;
import com.thetransactioncompany.cors.UnsupportedHTTPHeaderException;
import com.thetransactioncompany.cors.UnsupportedHTTPMethodException;
import java.util.Iterator;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CORSRequestHandler {
    private final CORSConfiguration config;
    private final String supportedMethods;
    private final String supportedHeaders;
    private final String exposedHeaders;

    public CORSRequestHandler(CORSConfiguration config) {
        this.config = config;
        this.supportedMethods = CORSRequestHandler.serialize(config.supportedMethods, ", ");
        this.supportedHeaders = !config.supportAnyHeader ? CORSRequestHandler.serialize(config.supportedHeaders, ", ") : null;
        this.exposedHeaders = CORSRequestHandler.serialize(config.exposedHeaders, ", ");
    }

    private static String serialize(Set set, String sep) {
        Iterator it = set.iterator();
        String s = "";
        while (it.hasNext()) {
            s = s + it.next().toString();
            if (!it.hasNext()) continue;
            s = s + sep;
        }
        return s;
    }

    private static String[] parseMultipleHeaderValues(String headerValue) {
        if (headerValue == null) {
            return new String[0];
        }
        String trimmedHeaderValue = headerValue.trim();
        if (trimmedHeaderValue.isEmpty()) {
            return new String[0];
        }
        return trimmedHeaderValue.split("\\s*,\\s*|\\s+");
    }

    public void tagRequest(HttpServletRequest request) {
        CORSRequestType type = CORSRequestType.detect(request);
        switch (type) {
            case ACTUAL: {
                request.setAttribute("cors.isCorsRequest", (Object)true);
                request.setAttribute("cors.origin", (Object)request.getHeader("Origin"));
                request.setAttribute("cors.requestType", (Object)"actual");
                break;
            }
            case PREFLIGHT: {
                request.setAttribute("cors.isCorsRequest", (Object)true);
                request.setAttribute("cors.origin", (Object)request.getHeader("Origin"));
                request.setAttribute("cors.requestType", (Object)"preflight");
                request.setAttribute("cors.requestHeaders", (Object)request.getHeader("Access-Control-Request-Headers"));
                break;
            }
            case OTHER: {
                request.setAttribute("cors.isCorsRequest", (Object)false);
            }
        }
    }

    public void handleActualRequest(HttpServletRequest request, HttpServletResponse response) throws InvalidCORSRequestException, CORSOriginDeniedException, UnsupportedHTTPMethodException {
        if (CORSRequestType.detect(request) != CORSRequestType.ACTUAL) {
            throw new InvalidCORSRequestException("Invalid simple/actual CORS request");
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw new CORSOriginDeniedException("CORS origin denied", requestOrigin);
        }
        HTTPMethod method = null;
        try {
            method = HTTPMethod.valueOf(request.getMethod());
        }
        catch (Exception e) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method: " + request.getMethod());
        }
        if (!this.config.isSupportedMethod(method)) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method", method);
        }
        response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Credentials", "true");
        }
        if (!this.exposedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Expose-Headers", this.exposedHeaders);
        }
        request.setAttribute("cors.origin", (Object)requestOrigin.toString());
        request.setAttribute("cors.requestType", (Object)"actual");
    }

    public void handlePreflightRequest(HttpServletRequest request, HttpServletResponse response) throws InvalidCORSRequestException, CORSOriginDeniedException, UnsupportedHTTPMethodException, UnsupportedHTTPHeaderException {
        int i;
        if (CORSRequestType.detect(request) != CORSRequestType.PREFLIGHT) {
            throw new InvalidCORSRequestException("Invalid preflight CORS request");
        }
        Origin requestOrigin = new Origin(request.getHeader("Origin"));
        if (!this.config.isAllowedOrigin(requestOrigin)) {
            throw new CORSOriginDeniedException("CORS origin denied", requestOrigin);
        }
        String requestMethodHeader = request.getHeader("Access-Control-Request-Method");
        if (requestMethodHeader == null) {
            throw new InvalidCORSRequestException("Invalid preflight CORS request: Missing Access-Control-Request-Method header");
        }
        HTTPMethod requestedMethod = null;
        try {
            requestedMethod = HTTPMethod.valueOf(requestMethodHeader.toUpperCase());
        }
        catch (Exception e) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method: " + requestMethodHeader);
        }
        String rawRequestHeadersString = request.getHeader("Access-Control-Request-Headers");
        String[] requestHeaderValues = CORSRequestHandler.parseMultipleHeaderValues(rawRequestHeadersString);
        HeaderFieldName[] requestHeaders = new HeaderFieldName[requestHeaderValues.length];
        for (i = 0; i < requestHeaders.length; ++i) {
            try {
                requestHeaders[i] = new HeaderFieldName(requestHeaderValues[i]);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new InvalidCORSRequestException("Invalid preflight CORS request: Bad request header value");
            }
        }
        if (!this.config.isSupportedMethod(requestedMethod)) {
            throw new UnsupportedHTTPMethodException("Unsupported HTTP method", requestedMethod);
        }
        if (!this.config.supportAnyHeader) {
            for (i = 0; i < requestHeaders.length; ++i) {
                if (this.config.supportedHeaders.contains(requestHeaders[i])) continue;
                throw new UnsupportedHTTPHeaderException("Unsupported HTTP request header", requestHeaders[i]);
            }
        }
        if (this.config.supportsCredentials) {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
            response.addHeader("Access-Control-Allow-Credentials", "true");
        } else if (this.config.allowAnyOrigin) {
            response.addHeader("Access-Control-Allow-Origin", "*");
        } else {
            response.addHeader("Access-Control-Allow-Origin", requestOrigin.toString());
        }
        if (this.config.maxAge > 0) {
            response.addHeader("Access-Control-Max-Age", Integer.toString(this.config.maxAge));
        }
        response.addHeader("Access-Control-Allow-Methods", this.supportedMethods);
        if (this.config.supportAnyHeader && rawRequestHeadersString != null) {
            response.addHeader("Access-Control-Allow-Headers", rawRequestHeadersString);
        } else if (!this.supportedHeaders.isEmpty()) {
            response.addHeader("Access-Control-Allow-Headers", this.supportedHeaders);
        }
    }
}

